/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import com.google.android.gms.R;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.zzbf;
import com.google.android.gms.internal.zzbcc;
import com.google.android.gms.internal.zzbcf;
import com.google.android.gms.maps.internal.zza;
import com.google.android.gms.maps.model.CameraPosition;
import com.google.android.gms.maps.model.LatLngBounds;
import com.google.android.gms.maps.zzz;

public final class GoogleMapOptions
extends zzbcc
implements ReflectedParcelable {
    public static final Parcelable.Creator<GoogleMapOptions> CREATOR = new zzz();
    private Boolean zzifw;
    private Boolean zzifx;
    private int zzify = -1;
    private CameraPosition zzifz;
    private Boolean zziga;
    private Boolean zzigb;
    private Boolean zzigc;
    private Boolean zzigd;
    private Boolean zzige;
    private Boolean zzigf;
    private Boolean zzigg;
    private Boolean zzigh;
    private Boolean zzigi;
    private Float zzigj = null;
    private Float zzigk = null;
    private LatLngBounds zzigl = null;

    GoogleMapOptions(byte by, byte by2, int n, CameraPosition cameraPosition, byte by3, byte by4, byte by5, byte by6, byte by7, byte by8, byte by9, byte by10, byte by11, Float f, Float f2, LatLngBounds latLngBounds) {
        this.zzifw = zza.zza(by);
        this.zzifx = zza.zza(by2);
        this.zzify = n;
        this.zzifz = cameraPosition;
        this.zziga = zza.zza(by3);
        this.zzigb = zza.zza(by4);
        this.zzigc = zza.zza(by5);
        this.zzigd = zza.zza(by6);
        this.zzige = zza.zza(by7);
        this.zzigf = zza.zza(by8);
        this.zzigg = zza.zza(by9);
        this.zzigh = zza.zza(by10);
        this.zzigi = zza.zza(by11);
        this.zzigj = f;
        this.zzigk = f2;
        this.zzigl = latLngBounds;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        GoogleMapOptions googleMapOptions = this;
        int n2 = zzbcf.zze((Parcel)parcel2);
        zzbcf.zza((Parcel)parcel2, (int)2, (byte)zza.zzb(googleMapOptions.zzifw));
        zzbcf.zza((Parcel)parcel2, (int)3, (byte)zza.zzb(googleMapOptions.zzifx));
        zzbcf.zzc((Parcel)parcel2, (int)4, (int)googleMapOptions.getMapType());
        zzbcf.zza((Parcel)parcel2, (int)5, (Parcelable)googleMapOptions.getCamera(), (int)n, (boolean)false);
        zzbcf.zza((Parcel)parcel2, (int)6, (byte)zza.zzb(googleMapOptions.zziga));
        zzbcf.zza((Parcel)parcel2, (int)7, (byte)zza.zzb(googleMapOptions.zzigb));
        zzbcf.zza((Parcel)parcel2, (int)8, (byte)zza.zzb(googleMapOptions.zzigc));
        zzbcf.zza((Parcel)parcel2, (int)9, (byte)zza.zzb(googleMapOptions.zzigd));
        zzbcf.zza((Parcel)parcel2, (int)10, (byte)zza.zzb(googleMapOptions.zzige));
        zzbcf.zza((Parcel)parcel2, (int)11, (byte)zza.zzb(googleMapOptions.zzigf));
        zzbcf.zza((Parcel)parcel2, (int)12, (byte)zza.zzb(googleMapOptions.zzigg));
        zzbcf.zza((Parcel)parcel2, (int)14, (byte)zza.zzb(googleMapOptions.zzigh));
        zzbcf.zza((Parcel)parcel2, (int)15, (byte)zza.zzb(googleMapOptions.zzigi));
        zzbcf.zza((Parcel)parcel2, (int)16, (Float)googleMapOptions.getMinZoomPreference(), (boolean)false);
        zzbcf.zza((Parcel)parcel2, (int)17, (Float)googleMapOptions.getMaxZoomPreference(), (boolean)false);
        zzbcf.zza((Parcel)parcel2, (int)18, (Parcelable)googleMapOptions.getLatLngBoundsForCameraTarget(), (int)n, (boolean)false);
        zzbcf.zzai((Parcel)parcel2, (int)n2);
    }

    public GoogleMapOptions() {
    }

    public final GoogleMapOptions zOrderOnTop(boolean bl) {
        this.zzifw = bl;
        return this;
    }

    public final GoogleMapOptions useViewLifecycleInFragment(boolean bl) {
        this.zzifx = bl;
        return this;
    }

    public final GoogleMapOptions mapType(int n) {
        this.zzify = n;
        return this;
    }

    public final GoogleMapOptions camera(CameraPosition cameraPosition) {
        this.zzifz = cameraPosition;
        return this;
    }

    public final GoogleMapOptions zoomControlsEnabled(boolean bl) {
        this.zziga = bl;
        return this;
    }

    public final GoogleMapOptions compassEnabled(boolean bl) {
        this.zzigb = bl;
        return this;
    }

    public final GoogleMapOptions scrollGesturesEnabled(boolean bl) {
        this.zzigc = bl;
        return this;
    }

    public final GoogleMapOptions zoomGesturesEnabled(boolean bl) {
        this.zzigd = bl;
        return this;
    }

    public final GoogleMapOptions tiltGesturesEnabled(boolean bl) {
        this.zzige = bl;
        return this;
    }

    public final GoogleMapOptions rotateGesturesEnabled(boolean bl) {
        this.zzigf = bl;
        return this;
    }

    public final GoogleMapOptions liteMode(boolean bl) {
        this.zzigg = bl;
        return this;
    }

    public final GoogleMapOptions mapToolbarEnabled(boolean bl) {
        this.zzigh = bl;
        return this;
    }

    public final GoogleMapOptions ambientEnabled(boolean bl) {
        this.zzigi = bl;
        return this;
    }

    public final GoogleMapOptions minZoomPreference(float f) {
        this.zzigj = Float.valueOf(f);
        return this;
    }

    public final GoogleMapOptions maxZoomPreference(float f) {
        this.zzigk = Float.valueOf(f);
        return this;
    }

    public final GoogleMapOptions latLngBoundsForCameraTarget(LatLngBounds latLngBounds) {
        this.zzigl = latLngBounds;
        return this;
    }

    public final Boolean getZOrderOnTop() {
        return this.zzifw;
    }

    public final Boolean getUseViewLifecycleInFragment() {
        return this.zzifx;
    }

    public final int getMapType() {
        return this.zzify;
    }

    public final CameraPosition getCamera() {
        return this.zzifz;
    }

    public final Boolean getZoomControlsEnabled() {
        return this.zziga;
    }

    public final Boolean getCompassEnabled() {
        return this.zzigb;
    }

    public final Boolean getScrollGesturesEnabled() {
        return this.zzigc;
    }

    public final Boolean getZoomGesturesEnabled() {
        return this.zzigd;
    }

    public final Boolean getTiltGesturesEnabled() {
        return this.zzige;
    }

    public final Boolean getRotateGesturesEnabled() {
        return this.zzigf;
    }

    public final Boolean getLiteMode() {
        return this.zzigg;
    }

    public final Boolean getMapToolbarEnabled() {
        return this.zzigh;
    }

    public final Boolean getAmbientEnabled() {
        return this.zzigi;
    }

    public final Float getMinZoomPreference() {
        return this.zzigj;
    }

    public final Float getMaxZoomPreference() {
        return this.zzigk;
    }

    public final LatLngBounds getLatLngBoundsForCameraTarget() {
        return this.zzigl;
    }

    public static GoogleMapOptions createFromAttributes(Context context, AttributeSet attributeSet) {
        if (attributeSet == null) {
            return null;
        }
        TypedArray typedArray = context.getResources().obtainAttributes(attributeSet, R.styleable.MapAttrs);
        GoogleMapOptions googleMapOptions = new GoogleMapOptions();
        if (typedArray.hasValue(R.styleable.MapAttrs_mapType)) {
            googleMapOptions.mapType(typedArray.getInt(R.styleable.MapAttrs_mapType, -1));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_zOrderOnTop)) {
            googleMapOptions.zOrderOnTop(typedArray.getBoolean(R.styleable.MapAttrs_zOrderOnTop, false));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_useViewLifecycle)) {
            googleMapOptions.useViewLifecycleInFragment(typedArray.getBoolean(R.styleable.MapAttrs_useViewLifecycle, false));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiCompass)) {
            googleMapOptions.compassEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiCompass, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiRotateGestures)) {
            googleMapOptions.rotateGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiRotateGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiScrollGestures)) {
            googleMapOptions.scrollGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiScrollGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiTiltGestures)) {
            googleMapOptions.tiltGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiTiltGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiZoomGestures)) {
            googleMapOptions.zoomGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiZoomGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiZoomControls)) {
            googleMapOptions.zoomControlsEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiZoomControls, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_liteMode)) {
            googleMapOptions.liteMode(typedArray.getBoolean(R.styleable.MapAttrs_liteMode, false));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiMapToolbar)) {
            googleMapOptions.mapToolbarEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiMapToolbar, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_ambientEnabled)) {
            googleMapOptions.ambientEnabled(typedArray.getBoolean(R.styleable.MapAttrs_ambientEnabled, false));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_cameraMinZoomPreference)) {
            googleMapOptions.minZoomPreference(typedArray.getFloat(R.styleable.MapAttrs_cameraMinZoomPreference, Float.NEGATIVE_INFINITY));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_cameraMinZoomPreference)) {
            googleMapOptions.maxZoomPreference(typedArray.getFloat(R.styleable.MapAttrs_cameraMaxZoomPreference, Float.POSITIVE_INFINITY));
        }
        LatLngBounds latLngBounds = LatLngBounds.createFromAttributes(context, attributeSet);
        googleMapOptions.latLngBoundsForCameraTarget(latLngBounds);
        CameraPosition cameraPosition = CameraPosition.createFromAttributes(context, attributeSet);
        googleMapOptions.camera(cameraPosition);
        typedArray.recycle();
        return googleMapOptions;
    }

    public final String toString() {
        return zzbf.zzt((Object)((Object)this)).zzg("MapType", (Object)this.zzify).zzg("LiteMode", (Object)this.zzigg).zzg("Camera", (Object)this.zzifz).zzg("CompassEnabled", (Object)this.zzigb).zzg("ZoomControlsEnabled", (Object)this.zziga).zzg("ScrollGesturesEnabled", (Object)this.zzigc).zzg("ZoomGesturesEnabled", (Object)this.zzigd).zzg("TiltGesturesEnabled", (Object)this.zzige).zzg("RotateGesturesEnabled", (Object)this.zzigf).zzg("MapToolbarEnabled", (Object)this.zzigh).zzg("AmbientEnabled", (Object)this.zzigi).zzg("MinZoomPreference", (Object)this.zzigj).zzg("MaxZoomPreference", (Object)this.zzigk).zzg("LatLngBoundsForCameraTarget", (Object)this.zzigl).zzg("ZOrderOnTop", (Object)this.zzifw).zzg("UseViewLifecycleInFragment", (Object)this.zzifx).toString();
    }
}

