/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.PatternItem;
import com.google.android.gms.maps.model.zzk;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class PolygonOptions
extends zza {
    public static final Parcelable.Creator<PolygonOptions> CREATOR = new zzk();
    private final List<LatLng> zzbnN;
    private final List<List<LatLng>> zzbnO;
    private float mStrokeWidth = 10.0f;
    private int mStrokeColor = -16777216;
    private int mFillColor = 0;
    private float zzbnk = 0.0f;
    private boolean zzbnl = true;
    private boolean zzbnP = false;
    private boolean zzbnm = false;
    private int zzbnQ = 0;
    @Nullable
    private List<PatternItem> zzbnn = null;

    public PolygonOptions() {
        this.zzbnN = new ArrayList<LatLng>();
        this.zzbnO = new ArrayList<List<LatLng>>();
    }

    PolygonOptions(List<LatLng> list, List list2, float f, int n, int n2, float f2, boolean bl, boolean bl2, boolean bl3, int n3, @Nullable List<PatternItem> list3) {
        this.zzbnN = list;
        this.zzbnO = list2;
        this.mStrokeWidth = f;
        this.mStrokeColor = n;
        this.mFillColor = n2;
        this.zzbnk = f2;
        this.zzbnl = bl;
        this.zzbnP = bl2;
        this.zzbnm = bl3;
        this.zzbnQ = n3;
        this.zzbnn = list3;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        PolygonOptions polygonOptions = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zzc((Parcel)parcel2, (int)2, polygonOptions.getPoints(), (boolean)false);
        zzd.zzd((Parcel)parcel2, (int)3, polygonOptions.zzbnO, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)4, (float)polygonOptions.getStrokeWidth());
        zzd.zzc((Parcel)parcel2, (int)5, (int)polygonOptions.getStrokeColor());
        zzd.zzc((Parcel)parcel2, (int)6, (int)polygonOptions.getFillColor());
        zzd.zza((Parcel)parcel2, (int)7, (float)polygonOptions.getZIndex());
        zzd.zza((Parcel)parcel2, (int)8, (boolean)polygonOptions.isVisible());
        zzd.zza((Parcel)parcel2, (int)9, (boolean)polygonOptions.isGeodesic());
        zzd.zza((Parcel)parcel2, (int)10, (boolean)polygonOptions.isClickable());
        zzd.zzc((Parcel)parcel2, (int)11, (int)polygonOptions.getStrokeJointType());
        zzd.zzc((Parcel)parcel2, (int)12, polygonOptions.getStrokePattern(), (boolean)false);
        zzd.zzI((Parcel)parcel2, (int)n2);
    }

    public final PolygonOptions add(LatLng latLng) {
        this.zzbnN.add(latLng);
        return this;
    }

    public final PolygonOptions add(LatLng ... latLngArray) {
        this.zzbnN.addAll(Arrays.asList(latLngArray));
        return this;
    }

    public final PolygonOptions addAll(Iterable<LatLng> iterable) {
        for (LatLng latLng : iterable) {
            this.zzbnN.add(latLng);
        }
        return this;
    }

    public final PolygonOptions addHole(Iterable<LatLng> iterable) {
        ArrayList<LatLng> arrayList = new ArrayList<LatLng>();
        for (LatLng latLng : iterable) {
            arrayList.add(latLng);
        }
        this.zzbnO.add(arrayList);
        return this;
    }

    public final PolygonOptions strokeWidth(float f) {
        this.mStrokeWidth = f;
        return this;
    }

    public final PolygonOptions strokeColor(int n) {
        this.mStrokeColor = n;
        return this;
    }

    public final PolygonOptions strokeJointType(int n) {
        this.zzbnQ = n;
        return this;
    }

    public final PolygonOptions strokePattern(@Nullable List<PatternItem> list) {
        this.zzbnn = list;
        return this;
    }

    public final PolygonOptions fillColor(int n) {
        this.mFillColor = n;
        return this;
    }

    public final PolygonOptions zIndex(float f) {
        this.zzbnk = f;
        return this;
    }

    public final PolygonOptions visible(boolean bl) {
        this.zzbnl = bl;
        return this;
    }

    public final PolygonOptions geodesic(boolean bl) {
        this.zzbnP = bl;
        return this;
    }

    public final PolygonOptions clickable(boolean bl) {
        this.zzbnm = bl;
        return this;
    }

    public final List<LatLng> getPoints() {
        return this.zzbnN;
    }

    public final List<List<LatLng>> getHoles() {
        return this.zzbnO;
    }

    public final float getStrokeWidth() {
        return this.mStrokeWidth;
    }

    public final int getStrokeColor() {
        return this.mStrokeColor;
    }

    public final int getStrokeJointType() {
        return this.zzbnQ;
    }

    @Nullable
    public final List<PatternItem> getStrokePattern() {
        return this.zzbnn;
    }

    public final int getFillColor() {
        return this.mFillColor;
    }

    public final float getZIndex() {
        return this.zzbnk;
    }

    public final boolean isVisible() {
        return this.zzbnl;
    }

    public final boolean isGeodesic() {
        return this.zzbnP;
    }

    public final boolean isClickable() {
        return this.zzbnm;
    }
}

