/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.PatternItem;
import com.google.android.gms.maps.model.zzk;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class PolygonOptions
extends zza {
    public static final Parcelable.Creator<PolygonOptions> CREATOR = new zzk();
    private final List<LatLng> zzbnR;
    private final List<List<LatLng>> zzbnS;
    private float mStrokeWidth = 10.0f;
    private int mStrokeColor = -16777216;
    private int mFillColor = 0;
    private float zzbno = 0.0f;
    private boolean zzbnp = true;
    private boolean zzbnT = false;
    private boolean zzbnq = false;
    private int zzbnU = 0;
    @Nullable
    private List<PatternItem> zzbnr = null;

    public PolygonOptions() {
        this.zzbnR = new ArrayList<LatLng>();
        this.zzbnS = new ArrayList<List<LatLng>>();
    }

    PolygonOptions(List<LatLng> list, List list2, float f, int n, int n2, float f2, boolean bl, boolean bl2, boolean bl3, int n3, @Nullable List<PatternItem> list3) {
        this.zzbnR = list;
        this.zzbnS = list2;
        this.mStrokeWidth = f;
        this.mStrokeColor = n;
        this.mFillColor = n2;
        this.zzbno = f2;
        this.zzbnp = bl;
        this.zzbnT = bl2;
        this.zzbnq = bl3;
        this.zzbnU = n3;
        this.zzbnr = list3;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        PolygonOptions polygonOptions = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zzc((Parcel)parcel2, (int)2, polygonOptions.getPoints(), (boolean)false);
        zzd.zzd((Parcel)parcel2, (int)3, polygonOptions.zzbnS, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)4, (float)polygonOptions.getStrokeWidth());
        zzd.zzc((Parcel)parcel2, (int)5, (int)polygonOptions.getStrokeColor());
        zzd.zzc((Parcel)parcel2, (int)6, (int)polygonOptions.getFillColor());
        zzd.zza((Parcel)parcel2, (int)7, (float)polygonOptions.getZIndex());
        zzd.zza((Parcel)parcel2, (int)8, (boolean)polygonOptions.isVisible());
        zzd.zza((Parcel)parcel2, (int)9, (boolean)polygonOptions.isGeodesic());
        zzd.zza((Parcel)parcel2, (int)10, (boolean)polygonOptions.isClickable());
        zzd.zzc((Parcel)parcel2, (int)11, (int)polygonOptions.getStrokeJointType());
        zzd.zzc((Parcel)parcel2, (int)12, polygonOptions.getStrokePattern(), (boolean)false);
        zzd.zzI((Parcel)parcel2, (int)n2);
    }

    public final PolygonOptions add(LatLng latLng) {
        this.zzbnR.add(latLng);
        return this;
    }

    public final PolygonOptions add(LatLng ... latLngArray) {
        this.zzbnR.addAll(Arrays.asList(latLngArray));
        return this;
    }

    public final PolygonOptions addAll(Iterable<LatLng> iterable) {
        for (LatLng latLng : iterable) {
            this.zzbnR.add(latLng);
        }
        return this;
    }

    public final PolygonOptions addHole(Iterable<LatLng> iterable) {
        ArrayList<LatLng> arrayList = new ArrayList<LatLng>();
        for (LatLng latLng : iterable) {
            arrayList.add(latLng);
        }
        this.zzbnS.add(arrayList);
        return this;
    }

    public final PolygonOptions strokeWidth(float f) {
        this.mStrokeWidth = f;
        return this;
    }

    public final PolygonOptions strokeColor(int n) {
        this.mStrokeColor = n;
        return this;
    }

    public final PolygonOptions strokeJointType(int n) {
        this.zzbnU = n;
        return this;
    }

    public final PolygonOptions strokePattern(@Nullable List<PatternItem> list) {
        this.zzbnr = list;
        return this;
    }

    public final PolygonOptions fillColor(int n) {
        this.mFillColor = n;
        return this;
    }

    public final PolygonOptions zIndex(float f) {
        this.zzbno = f;
        return this;
    }

    public final PolygonOptions visible(boolean bl) {
        this.zzbnp = bl;
        return this;
    }

    public final PolygonOptions geodesic(boolean bl) {
        this.zzbnT = bl;
        return this;
    }

    public final PolygonOptions clickable(boolean bl) {
        this.zzbnq = bl;
        return this;
    }

    public final List<LatLng> getPoints() {
        return this.zzbnR;
    }

    public final List<List<LatLng>> getHoles() {
        return this.zzbnS;
    }

    public final float getStrokeWidth() {
        return this.mStrokeWidth;
    }

    public final int getStrokeColor() {
        return this.mStrokeColor;
    }

    public final int getStrokeJointType() {
        return this.zzbnU;
    }

    @Nullable
    public final List<PatternItem> getStrokePattern() {
        return this.zzbnr;
    }

    public final int getFillColor() {
        return this.mFillColor;
    }

    public final float getZIndex() {
        return this.zzbno;
    }

    public final boolean isVisible() {
        return this.zzbnp;
    }

    public final boolean isGeodesic() {
        return this.zzbnT;
    }

    public final boolean isClickable() {
        return this.zzbnq;
    }
}

