/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.internal.zzbh;
import com.google.android.gms.common.internal.zzbr;
import com.google.android.gms.maps.model.Dash;
import com.google.android.gms.maps.model.Dot;
import com.google.android.gms.maps.model.Gap;
import com.google.android.gms.maps.model.zzi;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PatternItem
extends zza {
    private static final String TAG = PatternItem.class.getSimpleName();
    public static final Parcelable.Creator<PatternItem> CREATOR = new zzi();
    private final int type;
    @Nullable
    private final Float zzbnP;

    public PatternItem(int n, @Nullable Float f) {
        String string = String.valueOf(f);
        zzbr.zzb((n == 1 || f != null && f.floatValue() >= 0.0f ? 1 : 0) != 0, (Object)new StringBuilder(45 + String.valueOf(string).length()).append("Invalid PatternItem: type=").append(n).append(" length=").append(string).toString());
        this.type = n;
        this.zzbnP = f;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        PatternItem patternItem = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zzc((Parcel)parcel2, (int)2, (int)patternItem.type);
        zzd.zza((Parcel)parcel2, (int)3, (Float)patternItem.zzbnP, (boolean)false);
        zzd.zzI((Parcel)parcel2, (int)n2);
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.type, this.zzbnP});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof PatternItem)) {
            return false;
        }
        PatternItem patternItem = (PatternItem)((Object)object);
        return this.type == patternItem.type && zzbh.equal((Object)this.zzbnP, (Object)patternItem.zzbnP);
    }

    public String toString() {
        int n = this.type;
        String string = String.valueOf(this.zzbnP);
        return new StringBuilder(39 + String.valueOf(string).length()).append("[PatternItem: type=").append(n).append(" length=").append(string).append("]").toString();
    }

    @Nullable
    static List<PatternItem> zzF(@Nullable List<PatternItem> list) {
        if (list == null) {
            return null;
        }
        ArrayList<PatternItem> arrayList = new ArrayList<PatternItem>(list.size());
        for (PatternItem patternItem : list) {
            PatternItem patternItem2;
            if (patternItem == null) {
                patternItem2 = null;
            } else {
                PatternItem patternItem3 = patternItem;
                switch (patternItem3.type) {
                    case 0: {
                        patternItem2 = new Dash(patternItem3.zzbnP.floatValue());
                        break;
                    }
                    case 1: {
                        patternItem2 = new Dot();
                        break;
                    }
                    case 2: {
                        patternItem2 = new Gap(patternItem3.zzbnP.floatValue());
                        break;
                    }
                    default: {
                        int n = patternItem3.type;
                        Log.w((String)TAG, (String)new StringBuilder(37).append("Unknown PatternItem type: ").append(n).toString());
                        patternItem2 = patternItem3;
                    }
                }
            }
            arrayList.add(patternItem2);
        }
        return arrayList;
    }
}

