/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.maps.model.Dash;
import com.google.android.gms.maps.model.Dot;
import com.google.android.gms.maps.model.Gap;
import com.google.android.gms.maps.model.zzi;
import java.util.ArrayList;
import java.util.List;

public class PatternItem
extends zza {
    private static final String TAG = PatternItem.class.getSimpleName();
    public static final Parcelable.Creator<PatternItem> CREATOR = new zzi();
    private final int type;
    @Nullable
    private final Float zzbpJ;

    public PatternItem(int n, @Nullable Float f) {
        String string = String.valueOf(f);
        zzac.zzb((n == 1 || f != null && f.floatValue() >= 0.0f ? 1 : 0) != 0, (Object)new StringBuilder(45 + String.valueOf(string).length()).append("Invalid PatternItem: type=").append(n).append(" length=").append(string).toString());
        this.type = n;
        this.zzbpJ = f;
    }

    public int getType() {
        return this.type;
    }

    @Nullable
    public Float zzJN() {
        return this.zzbpJ;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzi.zza(this, parcel, n);
    }

    public int hashCode() {
        return zzaa.hashCode((Object[])new Object[]{this.type, this.zzbpJ});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof PatternItem)) {
            return false;
        }
        PatternItem patternItem = (PatternItem)((Object)object);
        return this.type == patternItem.type && zzaa.equal((Object)this.zzbpJ, (Object)patternItem.zzbpJ);
    }

    public String toString() {
        int n = this.type;
        String string = String.valueOf(this.zzbpJ);
        return new StringBuilder(39 + String.valueOf(string).length()).append("[PatternItem: type=").append(n).append(" length=").append(string).append("]").toString();
    }

    @Nullable
    static List<PatternItem> zzI(@Nullable List<PatternItem> list) {
        if (list == null) {
            return null;
        }
        ArrayList<PatternItem> arrayList = new ArrayList<PatternItem>(list.size());
        for (PatternItem patternItem : list) {
            arrayList.add(patternItem == null ? null : patternItem.zzJO());
        }
        return arrayList;
    }

    private PatternItem zzJO() {
        switch (this.type) {
            case 0: {
                return new Dash(this.zzbpJ.floatValue());
            }
            case 1: {
                return new Dot();
            }
            case 2: {
                return new Gap(this.zzbpJ.floatValue());
            }
        }
        int n = this.type;
        Log.w((String)TAG, (String)new StringBuilder(37).append("Unknown PatternItem type: ").append(n).toString());
        return this;
    }
}

