/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.RemoteException;
import android.support.v4.app.Fragment;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.LifecycleDelegate;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.maps.GoogleMap;
import com.google.android.gms.maps.GoogleMapOptions;
import com.google.android.gms.maps.MapsInitializer;
import com.google.android.gms.maps.OnMapReadyCallback;
import com.google.android.gms.maps.internal.IGoogleMapDelegate;
import com.google.android.gms.maps.internal.IMapFragmentDelegate;
import com.google.android.gms.maps.internal.MapLifecycleDelegate;
import com.google.android.gms.maps.internal.zzah;
import com.google.android.gms.maps.internal.zzai;
import com.google.android.gms.maps.internal.zzt;
import com.google.android.gms.maps.model.RuntimeRemoteException;
import java.util.ArrayList;
import java.util.List;

public class SupportMapFragment
extends Fragment {
    private final zzb zzboY = new zzb(this);

    public static SupportMapFragment newInstance() {
        return new SupportMapFragment();
    }

    public static SupportMapFragment newInstance(GoogleMapOptions googleMapOptions) {
        SupportMapFragment supportMapFragment = new SupportMapFragment();
        Bundle bundle = new Bundle();
        bundle.putParcelable("MapOptions", (Parcelable)googleMapOptions);
        supportMapFragment.setArguments(bundle);
        return supportMapFragment;
    }

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        this.zzboY.setActivity(activity);
    }

    public void onInflate(Activity activity, AttributeSet attributeSet, Bundle bundle) {
        super.onInflate(activity, attributeSet, bundle);
        this.zzboY.setActivity(activity);
        GoogleMapOptions googleMapOptions = GoogleMapOptions.createFromAttributes((Context)activity, attributeSet);
        Bundle bundle2 = new Bundle();
        bundle2.putParcelable("MapOptions", (Parcelable)googleMapOptions);
        this.zzboY.onInflate(activity, bundle2, bundle);
    }

    public void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.zzboY.onCreate(bundle);
    }

    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        View view = this.zzboY.onCreateView(layoutInflater, viewGroup, bundle);
        view.setClickable(true);
        return view;
    }

    public void onResume() {
        super.onResume();
        this.zzboY.onResume();
    }

    public void onPause() {
        this.zzboY.onPause();
        super.onPause();
    }

    public void onStart() {
        super.onStart();
        this.zzboY.onStart();
    }

    public void onStop() {
        this.zzboY.onStop();
        super.onStop();
    }

    public void onDestroyView() {
        this.zzboY.onDestroyView();
        super.onDestroyView();
    }

    public void onDestroy() {
        this.zzboY.onDestroy();
        super.onDestroy();
    }

    public void onLowMemory() {
        this.zzboY.onLowMemory();
        super.onLowMemory();
    }

    public void onActivityCreated(Bundle bundle) {
        if (bundle != null) {
            bundle.setClassLoader(SupportMapFragment.class.getClassLoader());
        }
        super.onActivityCreated(bundle);
    }

    public void onSaveInstanceState(Bundle bundle) {
        if (bundle != null) {
            bundle.setClassLoader(SupportMapFragment.class.getClassLoader());
        }
        super.onSaveInstanceState(bundle);
        this.zzboY.onSaveInstanceState(bundle);
    }

    public final void onEnterAmbient(Bundle bundle) {
        zzac.zzdj((String)"onEnterAmbient must be called on the main thread.");
        this.zzboY.onEnterAmbient(bundle);
    }

    public final void onExitAmbient() {
        zzac.zzdj((String)"onExitAmbient must be called on the main thread.");
        this.zzboY.onExitAmbient();
    }

    public void getMapAsync(OnMapReadyCallback onMapReadyCallback) {
        zzac.zzdj((String)"getMapAsync must be called on the main thread.");
        this.zzboY.getMapAsync(onMapReadyCallback);
    }

    public void setArguments(Bundle bundle) {
        super.setArguments(bundle);
    }

    static class zzb
    extends com.google.android.gms.dynamic.zza<zza> {
        private final Fragment zzaRN;
        protected zze<zza> zzbov;
        private Activity mActivity;
        private final List<OnMapReadyCallback> zzbow = new ArrayList<OnMapReadyCallback>();

        zzb(Fragment fragment) {
            this.zzaRN = fragment;
        }

        protected void zza(zze<zza> zze2) {
            this.zzbov = zze2;
            this.zzJy();
        }

        public void zzJy() {
            if (this.mActivity != null && this.zzbov != null && this.zzBM() == null) {
                try {
                    MapsInitializer.initialize((Context)this.mActivity);
                    IMapFragmentDelegate iMapFragmentDelegate = zzai.zzbI((Context)this.mActivity).zzI(zzd.zzA((Object)this.mActivity));
                    if (iMapFragmentDelegate == null) {
                        return;
                    }
                    this.zzbov.zza((LifecycleDelegate)new zza(this.zzaRN, iMapFragmentDelegate));
                    for (OnMapReadyCallback onMapReadyCallback : this.zzbow) {
                        ((zza)this.zzBM()).getMapAsync(onMapReadyCallback);
                    }
                    this.zzbow.clear();
                }
                catch (RemoteException remoteException) {
                    throw new RuntimeRemoteException(remoteException);
                }
                catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {}
            }
        }

        private void setActivity(Activity activity) {
            this.mActivity = activity;
            this.zzJy();
        }

        public void getMapAsync(OnMapReadyCallback onMapReadyCallback) {
            if (this.zzBM() != null) {
                ((zza)this.zzBM()).getMapAsync(onMapReadyCallback);
            } else {
                this.zzbow.add(onMapReadyCallback);
            }
        }

        public void onEnterAmbient(Bundle bundle) {
            if (this.zzBM() != null) {
                ((zza)this.zzBM()).onEnterAmbient(bundle);
            }
        }

        public void onExitAmbient() {
            if (this.zzBM() != null) {
                ((zza)this.zzBM()).onExitAmbient();
            }
        }
    }

    static class zza
    implements MapLifecycleDelegate {
        private final Fragment zzaRN;
        private final IMapFragmentDelegate zzbot;

        public zza(Fragment fragment, IMapFragmentDelegate iMapFragmentDelegate) {
            this.zzbot = (IMapFragmentDelegate)zzac.zzw((Object)iMapFragmentDelegate);
            this.zzaRN = (Fragment)zzac.zzw((Object)fragment);
        }

        public void onInflate(Activity activity, Bundle bundle, Bundle bundle2) {
            GoogleMapOptions googleMapOptions = (GoogleMapOptions)bundle.getParcelable("MapOptions");
            try {
                Bundle bundle3 = new Bundle();
                zzah.zzd(bundle2, bundle3);
                this.zzbot.onInflate(zzd.zzA((Object)activity), googleMapOptions, bundle3);
                zzah.zzd(bundle3, bundle2);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onCreate(Bundle bundle) {
            try {
                Bundle bundle2 = new Bundle();
                zzah.zzd(bundle, bundle2);
                Bundle bundle3 = this.zzaRN.getArguments();
                if (bundle3 != null && bundle3.containsKey("MapOptions")) {
                    zzah.zza(bundle2, "MapOptions", bundle3.getParcelable("MapOptions"));
                }
                this.zzbot.onCreate(bundle2);
                zzah.zzd(bundle2, bundle);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
            IObjectWrapper iObjectWrapper;
            try {
                Bundle bundle2 = new Bundle();
                zzah.zzd(bundle, bundle2);
                iObjectWrapper = this.zzbot.onCreateView(zzd.zzA((Object)layoutInflater), zzd.zzA((Object)viewGroup), bundle2);
                zzah.zzd(bundle2, bundle);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
            return (View)zzd.zzF((IObjectWrapper)iObjectWrapper);
        }

        public void onStart() {
            try {
                this.zzbot.onStart();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onResume() {
            try {
                this.zzbot.onResume();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onPause() {
            try {
                this.zzbot.onPause();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onStop() {
            try {
                this.zzbot.onStop();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onDestroyView() {
            try {
                this.zzbot.onDestroyView();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onDestroy() {
            try {
                this.zzbot.onDestroy();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onLowMemory() {
            try {
                this.zzbot.onLowMemory();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onSaveInstanceState(Bundle bundle) {
            try {
                Bundle bundle2 = new Bundle();
                zzah.zzd(bundle, bundle2);
                this.zzbot.onSaveInstanceState(bundle2);
                zzah.zzd(bundle2, bundle);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        @Override
        public void getMapAsync(final OnMapReadyCallback onMapReadyCallback) {
            try {
                this.zzbot.getMapAsync(new zzt.zza(this){

                    @Override
                    public void zza(IGoogleMapDelegate iGoogleMapDelegate) throws RemoteException {
                        onMapReadyCallback.onMapReady(new GoogleMap(iGoogleMapDelegate));
                    }
                });
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onEnterAmbient(Bundle bundle) {
            try {
                Bundle bundle2 = new Bundle();
                zzah.zzd(bundle, bundle2);
                this.zzbot.onEnterAmbient(bundle2);
                zzah.zzd(bundle2, bundle);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onExitAmbient() {
            try {
                this.zzbot.onExitAmbient();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }
    }
}

