/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.location.zzat;

@SafeParcelable.Reserved(value={1000})
@SafeParcelable.Class(creator="UserPreferredSleepWindowCreator")
@ShowFirstParty
public final class zzas
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<zzas> CREATOR = new zzat();
    @SafeParcelable.Field(id=1, getter="getStartHour")
    private final int zza;
    @SafeParcelable.Field(id=2, getter="getStartMinute")
    private final int zzb;
    @SafeParcelable.Field(id=3, getter="getEndHour")
    private final int zzc;
    @SafeParcelable.Field(id=4, getter="getEndMinute")
    private final int zzd;

    /*
     * Enabled aggressive block sorting
     */
    @SafeParcelable.Constructor
    public zzas(@SafeParcelable.Param(id=1) int n, @SafeParcelable.Param(id=2) int n2, @SafeParcelable.Param(id=3) int n3, @SafeParcelable.Param(id=4) int n4) {
        boolean bl = n >= 0 ? n <= 23 : false;
        Preconditions.checkState((boolean)bl, (Object)"Start hour must be in range [0, 23].");
        bl = n2 >= 0 ? n2 <= 59 : false;
        Preconditions.checkState((boolean)bl, (Object)"Start minute must be in range [0, 59].");
        bl = n3 >= 0 ? n3 <= 23 : false;
        Preconditions.checkState((boolean)bl, (Object)"End hour must be in range [0, 23].");
        bl = n4 >= 0 ? n4 <= 59 : false;
        Preconditions.checkState((boolean)bl, (Object)"End minute must be in range [0, 59].");
        bl = n + n2 + n3 + n4 > 0;
        Preconditions.checkState((boolean)bl, (Object)"Parameters can't be all 0.");
        this.zza = n;
        this.zzb = n2;
        this.zzc = n3;
        this.zzd = n4;
    }

    public final int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.zza, this.zzb, this.zzc, this.zzd});
    }

    public final boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzas)) {
            return false;
        }
        object = (zzas)((Object)object);
        return this.zza == ((zzas)((Object)object)).zza && this.zzb == ((zzas)((Object)object)).zzb && this.zzc == ((zzas)((Object)object)).zzc && this.zzd == ((zzas)((Object)object)).zzd;
    }

    public final String toString() {
        int n = this.zza;
        int n2 = this.zzb;
        int n3 = String.valueOf(n2).length();
        int n4 = this.zzc;
        int n5 = String.valueOf(n4).length();
        int n6 = this.zzd;
        int n7 = String.valueOf(n6).length();
        n3 = String.valueOf(n).length() + 50 + n3 + 10 + n5 + 12 + n7;
        StringBuilder stringBuilder = new StringBuilder(n3 + 1);
        stringBuilder.append("UserPreferredSleepWindow [startHour=");
        stringBuilder.append(n);
        stringBuilder.append(", startMinute=");
        stringBuilder.append(n2);
        stringBuilder.append(", endHour=");
        stringBuilder.append(n4);
        stringBuilder.append(", endMinute=");
        stringBuilder.append(n6);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Preconditions.checkNotNull((Object)parcel);
        n = this.zza;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel);
        SafeParcelWriter.writeInt((Parcel)parcel, (int)1, (int)n);
        SafeParcelWriter.writeInt((Parcel)parcel, (int)2, (int)this.zzb);
        SafeParcelWriter.writeInt((Parcel)parcel, (int)3, (int)this.zzc);
        Parcel parcel2 = parcel;
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)4, (int)this.zzd);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }
}

