/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.location.Location;
import android.os.Bundle;
import android.os.SystemClock;
import androidx.annotation.GuardedBy;
import androidx.core.location.LocationCompat;
import com.google.android.gms.internal.location.zzeo;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public final class zzak {
    private static final DecimalFormat zzb;
    private static final DecimalFormat zzc;
    @GuardedBy(value="sharedStringBuilder")
    private static final StringBuilder zzd;
    public static final /* synthetic */ int zza;

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public static StringBuilder zza(Location location, StringBuilder stringBuilder) {
        void var2_7;
        Bundle bundle;
        void var2_4;
        Bundle bundle2;
        stringBuilder.ensureCapacity(100);
        if (location == null) {
            stringBuilder.append((String)null);
            return stringBuilder;
        }
        stringBuilder.append("{");
        stringBuilder.append(location.getProvider());
        stringBuilder.append(", ");
        if (LocationCompat.isMock((Location)location)) {
            stringBuilder.append("mock, ");
        }
        stringBuilder.append(zzb.format(location.getLatitude()));
        stringBuilder.append(",");
        stringBuilder.append(zzb.format(location.getLongitude()));
        if (location.hasAccuracy()) {
            stringBuilder.append("\u00b1");
            stringBuilder.append(zzc.format(location.getAccuracy()));
            stringBuilder.append("m");
        }
        if (location.hasAltitude()) {
            stringBuilder.append(", alt=");
            stringBuilder.append(zzc.format(location.getAltitude()));
            if (LocationCompat.hasVerticalAccuracy((Location)location)) {
                stringBuilder.append("\u00b1");
                stringBuilder.append(zzc.format(LocationCompat.getVerticalAccuracyMeters((Location)location)));
            }
            stringBuilder.append("m");
        }
        if (location.hasSpeed()) {
            stringBuilder.append(", spd=");
            stringBuilder.append(zzc.format(location.getSpeed()));
            if (LocationCompat.hasSpeedAccuracy((Location)location)) {
                stringBuilder.append("\u00b1");
                stringBuilder.append(zzc.format(LocationCompat.getSpeedAccuracyMetersPerSecond((Location)location)));
            }
            stringBuilder.append("m/s");
        }
        if (location.hasBearing()) {
            stringBuilder.append(", brg=");
            stringBuilder.append(zzc.format(location.getBearing()));
            if (LocationCompat.hasBearingAccuracy((Location)location)) {
                stringBuilder.append("\u00b1");
                stringBuilder.append(zzc.format(LocationCompat.getBearingAccuracyDegrees((Location)location)));
            }
            stringBuilder.append("\u00b0");
        }
        if ((bundle2 = location.getExtras()) != null) {
            String string = bundle2.getString("floorLabel");
        } else {
            Object var2_9 = null;
        }
        if (var2_4 != null) {
            stringBuilder.append(", fl=");
            stringBuilder.append((String)var2_4);
        }
        if ((bundle = location.getExtras()) != null) {
            String string = bundle.getString("levelId");
        } else {
            Object var2_8 = null;
        }
        if (var2_7 != null) {
            stringBuilder.append(", lv=");
            stringBuilder.append((String)var2_7);
        }
        long l = System.currentTimeMillis() - SystemClock.elapsedRealtime();
        stringBuilder.append(", ert=");
        stringBuilder.append(zzeo.zza(LocationCompat.getElapsedRealtimeMillis((Location)location) + l));
        stringBuilder.append('}');
        return stringBuilder;
    }

    static {
        DecimalFormatSymbols decimalFormatSymbols = DecimalFormatSymbols.getInstance(Locale.ROOT);
        zzb = new DecimalFormat(".000000", decimalFormatSymbols);
        decimalFormatSymbols = DecimalFormatSymbols.getInstance(Locale.ROOT);
        zzc = new DecimalFormat(".##", decimalFormatSymbols);
        zzc.setRoundingMode(RoundingMode.DOWN);
        zzd = new StringBuilder();
    }
}

