/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelableSerializer;
import com.google.android.gms.location.zzao;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@SafeParcelable.Class(creator="SleepClassifyEventCreator")
public class SleepClassifyEvent
extends AbstractSafeParcelable {
    @NonNull
    public static final Parcelable.Creator<SleepClassifyEvent> CREATOR = new zzao();
    @SafeParcelable.Field(id=1, getter="getTimestampSec")
    private final int zza;
    @SafeParcelable.Field(id=2, getter="getConfidence")
    private final int zzb;
    @SafeParcelable.Field(id=3, getter="getMotion")
    private final int zzc;
    @SafeParcelable.Field(id=4, getter="getLight")
    private final int zzd;
    @SafeParcelable.Field(id=5, getter="getNoise")
    private final int zze;
    @SafeParcelable.Field(id=6, getter="getLightDiff")
    private final int zzf;
    @SafeParcelable.Field(id=7, getter="getNightOrDay")
    private final int zzg;
    @SafeParcelable.Field(id=8, getter="getConfidenceOverwrittenByAlarmClockTrigger")
    private final boolean zzh;
    @SafeParcelable.Field(id=9, getter="getPresenceConfidence")
    private final int zzi;

    @SafeParcelable.Constructor
    @ShowFirstParty
    public SleepClassifyEvent(@SafeParcelable.Param(id=1) int n, @SafeParcelable.Param(id=2) int n2, @SafeParcelable.Param(id=3) int n3, @SafeParcelable.Param(id=4) int n4, @SafeParcelable.Param(id=5) int n5, @SafeParcelable.Param(id=6) int n6, @SafeParcelable.Param(id=7) int n7, @SafeParcelable.Param(id=8) boolean bl, @SafeParcelable.Param(id=9) int n8) {
        this.zza = n;
        this.zzb = n2;
        this.zzc = n3;
        this.zzd = n4;
        this.zze = n5;
        this.zzf = n6;
        this.zzg = n7;
        this.zzh = bl;
        this.zzi = n8;
    }

    public long getTimestampMillis() {
        return (long)this.zza * 1000L;
    }

    public int getConfidence() {
        return this.zzb;
    }

    public int getMotion() {
        return this.zzc;
    }

    public int getLight() {
        return this.zzd;
    }

    @NonNull
    public String toString() {
        int n = this.zza;
        int n2 = this.zzb;
        int n3 = String.valueOf(n2).length();
        int n4 = this.zzc;
        int n5 = String.valueOf(n4).length();
        int n6 = this.zzd;
        int n7 = String.valueOf(n6).length();
        n3 = String.valueOf(n).length() + 6 + n3 + 8 + n5;
        StringBuilder stringBuilder = new StringBuilder(n3 + 7 + n7);
        stringBuilder.append(n);
        stringBuilder.append(" Conf:");
        stringBuilder.append(n2);
        stringBuilder.append(" Motion:");
        stringBuilder.append(n4);
        stringBuilder.append(" Light:");
        stringBuilder.append(n6);
        return stringBuilder.toString();
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel out, int n) {
        void var1_1;
        Preconditions.checkNotNull((Object)out);
        n = this.zza;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)var1_1);
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)1, (int)n);
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)2, (int)this.getConfidence());
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)3, (int)this.getMotion());
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)4, (int)this.getLight());
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)5, (int)this.zze);
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)6, (int)this.zzf);
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)7, (int)this.zzg);
        SafeParcelWriter.writeBoolean((Parcel)var1_1, (int)8, (boolean)this.zzh);
        void v1 = var1_1;
        SafeParcelWriter.writeInt((Parcel)v1, (int)9, (int)this.zzi);
        SafeParcelWriter.finishObjectHeader((Parcel)v1, (int)n2);
    }

    public boolean equals(@Nullable Object o) {
        SleepClassifyEvent sleepClassifyEvent;
        if (this == sleepClassifyEvent) {
            return true;
        }
        if (!(sleepClassifyEvent instanceof SleepClassifyEvent)) {
            return false;
        }
        sleepClassifyEvent = sleepClassifyEvent;
        return this.zza == sleepClassifyEvent.zza && this.zzb == sleepClassifyEvent.zzb;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.zza, this.zzb});
    }

    public static boolean hasEvents(@Nullable Intent intent) {
        Intent intent2;
        if (intent == null) {
            return false;
        }
        return intent2.hasExtra("com.google.android.location.internal.EXTRA_SLEEP_CLASSIFY_RESULT");
    }

    @NonNull
    public static List<SleepClassifyEvent> extractEvents(@NonNull Intent intent) {
        Intent intent2;
        Preconditions.checkNotNull((Object)intent);
        if (!SleepClassifyEvent.hasEvents(intent2)) {
            return Collections.emptyList();
        }
        ArrayList arrayList = (ArrayList)intent2.getSerializableExtra("com.google.android.location.internal.EXTRA_SLEEP_CLASSIFY_RESULT");
        if (arrayList == null) {
            return Collections.emptyList();
        }
        ArrayList<SleepClassifyEvent> arrayList2 = new ArrayList<SleepClassifyEvent>(arrayList.size());
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            byte[] byArray = (byte[])arrayList.get(i);
            Preconditions.checkNotNull((Object)byArray);
            arrayList2.add((SleepClassifyEvent)SafeParcelableSerializer.deserializeFromBytes((byte[])byArray, CREATOR));
        }
        return Collections.unmodifiableList(arrayList2);
    }
}

