/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.location.zze;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

@SafeParcelable.Reserved(value={1000})
@SafeParcelable.Class(creator="ActivityTransitionCreator")
public class ActivityTransition
extends AbstractSafeParcelable {
    public static final int ACTIVITY_TRANSITION_ENTER = 0;
    public static final int ACTIVITY_TRANSITION_EXIT = 1;
    @NonNull
    public static final Parcelable.Creator<ActivityTransition> CREATOR = new zze();
    @SafeParcelable.Field(id=1, getter="getActivityType")
    private final int zza;
    @SafeParcelable.Field(id=2, getter="getTransitionType")
    private final int zzb;

    @SafeParcelable.Constructor
    ActivityTransition(@SafeParcelable.Param(id=1) int n, @SafeParcelable.Param(id=2) int n2) {
        this.zza = n;
        this.zzb = n2;
    }

    public int getActivityType() {
        return this.zza;
    }

    public int getTransitionType() {
        return this.zzb;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.zza, this.zzb});
    }

    public boolean equals(@Nullable Object object) {
        ActivityTransition activityTransition;
        if (this == activityTransition) {
            return true;
        }
        if (!(activityTransition instanceof ActivityTransition)) {
            return false;
        }
        activityTransition = activityTransition;
        return this.zza == activityTransition.zza && this.zzb == activityTransition.zzb;
    }

    @NonNull
    public String toString() {
        int n = this.zza;
        int n2 = this.zzb;
        int n3 = String.valueOf(n2).length();
        n3 = String.valueOf(n).length() + 52 + n3;
        StringBuilder stringBuilder = new StringBuilder(n3 + 1);
        stringBuilder.append("ActivityTransition [mActivityType=");
        stringBuilder.append(n);
        stringBuilder.append(", mTransitionType=");
        stringBuilder.append(n2);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel dest, int n) {
        void var1_1;
        Preconditions.checkNotNull((Object)dest);
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)var1_1);
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)1, (int)this.getActivityType());
        void v1 = var1_1;
        SafeParcelWriter.writeInt((Parcel)v1, (int)2, (int)this.getTransitionType());
        SafeParcelWriter.finishObjectHeader((Parcel)v1, (int)n2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void zza(int n) {
        boolean bl = n >= 0 ? n <= 1 : false;
        int n2 = String.valueOf(n).length();
        StringBuilder stringBuilder = new StringBuilder(n2 + 30);
        stringBuilder.append("Transition type ");
        stringBuilder.append(n);
        stringBuilder.append(" is not valid.");
        Preconditions.checkArgument((boolean)bl, (Object)stringBuilder.toString());
    }

    public static class Builder {
        private int zza = -1;
        private int zzb = -1;

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setActivityType(int activityType) {
            void var1_1;
            this.zza = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setActivityTransition(int transition) {
            void var1_1;
            ActivityTransition.zza(transition);
            this.zzb = var1_1;
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        @NonNull
        public ActivityTransition build() {
            boolean bl = this.zza != -1;
            Preconditions.checkState((boolean)bl, (Object)"Activity type not set.");
            bl = this.zzb != -1;
            Preconditions.checkState((boolean)bl, (Object)"Activity transition type not set.");
            return new ActivityTransition(this.zza, this.zzb);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SupportedActivityTransition {
    }
}

