/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.content.Intent;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelableSerializer;
import com.google.android.gms.location.DetectedActivity;
import com.google.android.gms.location.zzd;
import java.lang.reflect.Array;
import java.util.Collections;
import java.util.List;

@SafeParcelable.Reserved(value={1000})
@SafeParcelable.Class(creator="ActivityRecognitionResultCreator")
public class ActivityRecognitionResult
extends AbstractSafeParcelable
implements ReflectedParcelable {
    @NonNull
    public static final Parcelable.Creator<ActivityRecognitionResult> CREATOR = new zzd();
    @SafeParcelable.Field(id=1)
    List zza;
    @SafeParcelable.Field(id=2)
    long zzb;
    @SafeParcelable.Field(id=3)
    long zzc;
    @SafeParcelable.Field(id=4)
    int zzd;
    @SafeParcelable.Field(id=5)
    @Nullable
    Bundle zze;

    /*
     * WARNING - void declaration
     */
    public ActivityRecognitionResult(@NonNull List<DetectedActivity> probableActivities, long time, long elapsedRealtimeMillis) {
        this((List)var1_1, (long)var2_2, (long)var4_3, 0, null);
        void var4_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    public ActivityRecognitionResult(@NonNull DetectedActivity mostProbableActivity, long time, long elapsedRealtimeMillis) {
        this(Collections.singletonList(var1_1), (long)var2_2, (long)var4_3, 0, null);
        void var4_3;
        void var2_2;
        void var1_1;
    }

    /*
     * Enabled aggressive block sorting
     */
    @ShowFirstParty
    @SafeParcelable.Constructor
    public ActivityRecognitionResult(@SafeParcelable.Param(id=1) @NonNull List list, @SafeParcelable.Param(id=2) long l, @SafeParcelable.Param(id=3) long l2, @SafeParcelable.Param(id=4) int n, @Nullable @SafeParcelable.Param(id=5) Bundle bundle) {
        boolean bl = list != null ? !list.isEmpty() : false;
        Preconditions.checkArgument((boolean)bl, (Object)"Must have at least 1 detected activity");
        bl = l > 0L ? l2 > 0L : false;
        Preconditions.checkArgument((boolean)bl, (Object)"Must set times");
        this.zza = list;
        this.zzb = l;
        this.zzc = l2;
        this.zzd = n;
        this.zze = bundle;
    }

    public static boolean hasResult(@Nullable Intent intent) {
        Object object;
        if (intent == null) {
            return false;
        }
        if (object.hasExtra("com.google.android.location.internal.EXTRA_ACTIVITY_RESULT")) {
            return true;
        }
        return (object = ActivityRecognitionResult.zza((Intent)object)) != null && !object.isEmpty();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Nullable
    public static ActivityRecognitionResult extractResult(@NonNull Intent intent) {
        void var1_2;
        Object object;
        if (!ActivityRecognitionResult.hasResult(intent)) {
            Object var1_1 = null;
        } else {
            Bundle bundle = object.getExtras();
            if (bundle == null) {
                Object var1_4 = null;
            } else {
                Object object2 = bundle.get("com.google.android.location.internal.EXTRA_ACTIVITY_RESULT");
                if (object2 instanceof byte[]) {
                    ActivityRecognitionResult activityRecognitionResult = (ActivityRecognitionResult)SafeParcelableSerializer.deserializeFromBytes((byte[])((byte[])object2), CREATOR);
                } else if (object2 instanceof ActivityRecognitionResult) {
                    ActivityRecognitionResult activityRecognitionResult = (ActivityRecognitionResult)((Object)object2);
                } else {
                    Object var1_8 = null;
                }
            }
        }
        if (var1_2 != null) {
            return var1_2;
        }
        if ((object = ActivityRecognitionResult.zza((Intent)object)) != null && !object.isEmpty()) {
            Object object3 = object;
            return (ActivityRecognitionResult)((Object)object3.get(object3.size() + -1));
        }
        return null;
    }

    @NonNull
    public DetectedActivity getMostProbableActivity() {
        return (DetectedActivity)((Object)this.zza.get(0));
    }

    /*
     * WARNING - void declaration
     */
    public int getActivityConfidence(int activityType) {
        for (DetectedActivity detectedActivity : ((ActivityRecognitionResult)((Object)this)).zza) {
            void var1_1;
            if (detectedActivity.getType() != var1_1) continue;
            return detectedActivity.getConfidence();
        }
        return 0;
    }

    @NonNull
    public List<DetectedActivity> getProbableActivities() {
        return this.zza;
    }

    public long getTime() {
        return this.zzb;
    }

    public long getElapsedRealtimeMillis() {
        return this.zzc;
    }

    @NonNull
    public String toString() {
        StringBuilder stringBuilder;
        String string = String.valueOf(this.zza);
        long l = this.zzb;
        long l2 = this.zzc;
        int n = String.valueOf(l).length();
        int n2 = String.valueOf(l2).length();
        n = String.valueOf(string).length() + 59 + n + 24 + n2;
        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder(n + 1);
        stringBuilder2.append("ActivityRecognitionResult [probableActivities=");
        stringBuilder2.append(string);
        stringBuilder.append(", timeMillis=");
        stringBuilder.append(l);
        stringBuilder.append(", elapsedRealtimeMillis=");
        stringBuilder.append(l2);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    @ShowFirstParty
    public final boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || ((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        object = (ActivityRecognitionResult)((Object)object);
        return this.zzb == ((ActivityRecognitionResult)((Object)object)).zzb && this.zzc == ((ActivityRecognitionResult)((Object)object)).zzc && this.zzd == ((ActivityRecognitionResult)((Object)object)).zzd && Objects.equal((Object)this.zza, (Object)((ActivityRecognitionResult)((Object)object)).zza) && ActivityRecognitionResult.zzb(this.zze, ((ActivityRecognitionResult)((Object)object)).zze);
    }

    @ShowFirstParty
    public final int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.zzb, this.zzc, this.zzd, this.zza, this.zze});
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel out, int n) {
        void var1_1;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)out);
        SafeParcelWriter.writeTypedList((Parcel)var1_1, (int)1, (List)this.zza, (boolean)false);
        SafeParcelWriter.writeLong((Parcel)var1_1, (int)2, (long)this.zzb);
        SafeParcelWriter.writeLong((Parcel)var1_1, (int)3, (long)this.zzc);
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)4, (int)this.zzd);
        void v1 = var1_1;
        SafeParcelWriter.writeBundle((Parcel)v1, (int)5, (Bundle)this.zze, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)v1, (int)n2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    public static List zza(@NonNull Intent intent) {
        if (intent == null || !intent.hasExtra("com.google.android.location.internal.EXTRA_ACTIVITY_RESULT_LIST")) {
            return null;
        }
        return SafeParcelableSerializer.deserializeIterableFromIntentExtra((Intent)intent, (String)"com.google.android.location.internal.EXTRA_ACTIVITY_RESULT_LIST", CREATOR);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean zzb(@Nullable Bundle bundle, @Nullable Bundle bundle2) {
        if (bundle == null) {
            return bundle2 == null;
        }
        if (bundle2 == null) {
            return false;
        }
        if (bundle.size() != bundle2.size()) {
            return false;
        }
        for (String string : bundle.keySet()) {
            if (!bundle2.containsKey(string)) {
                return false;
            }
            Object object = bundle.get(string);
            Object object2 = bundle2.get(string);
            if (object == null) {
                if (object2 == null) continue;
                return false;
            }
            if (object instanceof Bundle) {
                if (ActivityRecognitionResult.zzb(bundle.getBundle(string), bundle2.getBundle(string))) continue;
                return false;
            }
            if (object.getClass().isArray()) {
                if (object2 == null || !object2.getClass().isArray()) {
                    return false;
                }
                int n = Array.getLength(object);
                if (n != Array.getLength(object2)) return false;
                for (int i = 0; i < n; ++i) {
                    if (Objects.equal((Object)Array.get(object, i), (Object)Array.get(object2, i))) continue;
                    return false;
                }
                continue;
            }
            if (object.equals(object2)) continue;
            return false;
        }
        return true;
    }
}

