/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.location;

import android.app.PendingIntent;
import android.content.Context;
import android.location.Location;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.RemoteException;
import androidx.collection.SimpleArrayMap;
import com.google.android.gms.common.Feature;
import com.google.android.gms.common.api.internal.ConnectionCallbacks;
import com.google.android.gms.common.api.internal.IStatusCallback;
import com.google.android.gms.common.api.internal.ListenerHolder;
import com.google.android.gms.common.api.internal.ListenerHolders;
import com.google.android.gms.common.api.internal.OnConnectionFailedListener;
import com.google.android.gms.common.internal.ClientSettings;
import com.google.android.gms.common.internal.GmsClient;
import com.google.android.gms.common.internal.ICancelToken;
import com.google.android.gms.internal.location.zzdd;
import com.google.android.gms.internal.location.zzdg;
import com.google.android.gms.internal.location.zzdh;
import com.google.android.gms.internal.location.zzdi;
import com.google.android.gms.internal.location.zzdj;
import com.google.android.gms.internal.location.zzdk;
import com.google.android.gms.internal.location.zzdl;
import com.google.android.gms.internal.location.zzdn;
import com.google.android.gms.internal.location.zzdo;
import com.google.android.gms.internal.location.zzdq;
import com.google.android.gms.internal.location.zzdr;
import com.google.android.gms.internal.location.zzdv;
import com.google.android.gms.internal.location.zzdy;
import com.google.android.gms.internal.location.zzea;
import com.google.android.gms.internal.location.zzeb;
import com.google.android.gms.internal.location.zzec;
import com.google.android.gms.internal.location.zzed;
import com.google.android.gms.internal.location.zzee;
import com.google.android.gms.internal.location.zzeg;
import com.google.android.gms.internal.location.zzei;
import com.google.android.gms.internal.location.zzem;
import com.google.android.gms.internal.location.zzfc;
import com.google.android.gms.internal.location.zzh;
import com.google.android.gms.internal.location.zzj;
import com.google.android.gms.internal.location.zzu;
import com.google.android.gms.internal.location.zzv;
import com.google.android.gms.location.CurrentLocationRequest;
import com.google.android.gms.location.DeviceOrientationRequest;
import com.google.android.gms.location.GeofencingRequest;
import com.google.android.gms.location.LastLocationRequest;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.zzad;
import com.google.android.gms.location.zzo;
import com.google.android.gms.location.zzw;
import com.google.android.gms.location.zzz;
import com.google.android.gms.tasks.CancellationToken;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.OnTokenCanceledListener;
import com.google.android.gms.tasks.TaskCompletionSource;
import java.util.Objects;
import java.util.concurrent.Executor;

public final class zzdz
extends GmsClient {
    private final SimpleArrayMap zzf = new SimpleArrayMap();
    private final SimpleArrayMap zzg = new SimpleArrayMap();
    private final SimpleArrayMap zzh = new SimpleArrayMap();
    private final SimpleArrayMap zzi = new SimpleArrayMap();
    public static final /* synthetic */ int zze;

    public zzdz(Context context, Looper looper, ClientSettings clientSettings, ConnectionCallbacks connectionCallbacks, OnConnectionFailedListener onConnectionFailedListener) {
        super(context, looper, 23, clientSettings, connectionCallbacks, onConnectionFailedListener);
    }

    protected final String getStartServiceAction() {
        return "com.google.android.location.internal.GoogleLocationManagerService.START";
    }

    protected final String getServiceDescriptor() {
        return "com.google.android.gms.location.internal.IGoogleLocationManagerService";
    }

    public final Feature[] getApiFeatures() {
        return zzo.zzp;
    }

    public final int getMinApkVersion() {
        return 11717000;
    }

    public final boolean usesClientTelemetry() {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean zzG(Feature feature) {
        Feature[] featureArray = this.getAvailableFeatures();
        if (featureArray == null) return false;
        int n = 0;
        while (n < featureArray.length) {
            Feature feature2 = featureArray[n];
            if (feature.getName().equals(feature2.getName())) {
                Feature feature3 = feature2;
                if (feature3 == null) {
                    return false;
                }
                if (feature3.getVersion() < feature.getVersion()) return false;
                return true;
            }
            ++n;
        }
        return false;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void onConnectionSuspended(int n) {
        super.onConnectionSuspended(n);
        SimpleArrayMap simpleArrayMap = this.zzf;
        synchronized (simpleArrayMap) {
            this.zzf.clear();
        }
        simpleArrayMap = this.zzg;
        synchronized (simpleArrayMap) {
            this.zzg.clear();
        }
        simpleArrayMap = this.zzh;
        synchronized (simpleArrayMap) {
            this.zzh.clear();
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    public final void zzp(zzad zzad2, TaskCompletionSource taskCompletionSource) throws RemoteException {
        if (object.zzG(zzo.zzj)) {
            zzv zzv2 = (zzv)object.getService();
            Object object = new zzdl(taskCompletionSource);
            zzv2.zzo(zzad2, new zzee(5, null, (IBinder)object, null, null));
            return;
        }
        taskCompletionSource.setResult((Object)((zzv)object.getService()).zzp(object.getContext().getPackageName()));
    }

    public final void zzq(LastLocationRequest lastLocationRequest, TaskCompletionSource taskCompletionSource) throws RemoteException {
        if (this.zzG(zzo.zzj)) {
            ((zzv)this.getService()).zzq(lastLocationRequest, zzee.zzd(new zzdk(taskCompletionSource)));
            return;
        }
        if (this.zzG(zzo.zzf)) {
            ((zzv)this.getService()).zzr(lastLocationRequest, new zzdk(taskCompletionSource));
            return;
        }
        taskCompletionSource.setResult((Object)((zzv)this.getService()).zzs());
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void zzr(CurrentLocationRequest currentLocationRequest, CancellationToken cancellationToken, TaskCompletionSource taskCompletionSource) throws RemoteException {
        zzdz zzdz2;
        if (zzdz2.zzG(zzo.zzj)) {
            zzdz2 = ((zzv)zzdz2.getService()).zzt(currentLocationRequest, zzee.zzd(new zzdk(taskCompletionSource)));
            if (cancellationToken == null) return;
            cancellationToken.onCanceledRequested((OnTokenCanceledListener)new zzed((ICancelToken)zzdz2));
            return;
        }
        if (zzdz2.zzG(zzo.zze)) {
            zzdz2 = ((zzv)zzdz2.getService()).zzu(currentLocationRequest, new zzdk(taskCompletionSource));
            if (cancellationToken == null) return;
            cancellationToken.onCanceledRequested((OnTokenCanceledListener)new zzeb((ICancelToken)zzdz2));
            return;
        }
        ListenerHolder listenerHolder = ListenerHolders.createListenerHolder((Object)new zzdh(zzdz2, taskCompletionSource), (Executor)zzfc.zza(), (String)"GetCurrentLocation");
        ListenerHolder.ListenerKey listenerKey = Objects.requireNonNull(listenerHolder.getListenerKey());
        zzdz zzdz3 = zzdz2;
        zzdi zzdi2 = new zzdi(zzdz3, listenerHolder, taskCompletionSource);
        listenerHolder = new TaskCompletionSource();
        LocationRequest.Builder builder = new LocationRequest.Builder(currentLocationRequest.getPriority(), 0L);
        builder.setMinUpdateIntervalMillis(0L);
        builder.setDurationMillis(currentLocationRequest.getDurationMillis());
        builder.setGranularity(currentLocationRequest.getGranularity());
        builder.setMaxUpdateAgeMillis(currentLocationRequest.getMaxUpdateAgeMillis());
        builder.zzb(currentLocationRequest.zza());
        builder.zza(currentLocationRequest.zzb());
        builder.setWaitForAccurateLocation(true);
        builder.zzc(currentLocationRequest.zzc());
        zzdz3.zzt(zzdi2, builder.build(), (TaskCompletionSource)listenerHolder);
        listenerHolder.getTask().addOnCompleteListener((OnCompleteListener)new zzea(taskCompletionSource));
        if (cancellationToken == null) {
            return;
        }
        cancellationToken.onCanceledRequested((OnTokenCanceledListener)new zzec(zzdz2, listenerKey));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzs(zzdr object, LocationRequest object2, TaskCompletionSource object3) throws RemoteException {
        Object object4 = object.zza();
        Object object5 = Objects.requireNonNull(object4.getListenerKey());
        boolean bl = ((zzdz)((Object)object6)).zzG(zzo.zzj);
        SimpleArrayMap simpleArrayMap = ((zzdz)((Object)object6)).zzf;
        synchronized (simpleArrayMap) {
            Object object6;
            zzdy zzdy2 = (zzdy)((zzdz)((Object)object6)).zzf.get(object5);
            if (zzdy2 == null || bl) {
                object4 = new zzdy((zzdr)object);
                ((zzdz)((Object)object6)).zzf.put(object5, object4);
                object = zzdy2;
            } else {
                zzdy2.zzc((ListenerHolder)object4);
                object = null;
                object4 = zzdy2;
            }
            if (bl) {
                object6 = (zzv)object6.getService();
                object = zzee.zza((IInterface)object, (zzz)object4, object5.toIdString());
                object4 = new zzdj(null, (TaskCompletionSource)object3);
                object6.zzw((zzee)((Object)object), (LocationRequest)((Object)object2), (IStatusCallback)object4);
            } else {
                object6 = (zzv)object6.getService();
                object = zzeg.zza(null, object2);
                object2 = new zzdo((TaskCompletionSource)object3, (zzz)object4);
                object3 = object5.toIdString();
                object5 = new zzei(1, (zzeg)((Object)object), (IBinder)object4, null, null, (IBinder)object2, (String)object3);
                object6.zzv((zzei)((Object)object5));
            }
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzt(zzdr object, LocationRequest object2, TaskCompletionSource object3) throws RemoteException {
        Object object4 = object.zza();
        Object object5 = Objects.requireNonNull(object4.getListenerKey());
        boolean bl = ((zzdz)((Object)object6)).zzG(zzo.zzj);
        SimpleArrayMap simpleArrayMap = ((zzdz)((Object)object6)).zzg;
        synchronized (simpleArrayMap) {
            Object object6;
            zzdv zzdv2 = (zzdv)((zzdz)((Object)object6)).zzg.get(object5);
            if (zzdv2 == null || bl) {
                object4 = new zzdv((zzdr)object);
                ((zzdz)((Object)object6)).zzg.put(object5, object4);
                object = zzdv2;
            } else {
                zzdv2.zzc((ListenerHolder)object4);
                object = null;
                object4 = zzdv2;
            }
            if (bl) {
                object6 = (zzv)object6.getService();
                object = zzee.zzb((IInterface)object, (zzw)object4, object5.toIdString());
                object4 = new zzdj(null, (TaskCompletionSource)object3);
                object6.zzw((zzee)((Object)object), (LocationRequest)((Object)object2), (IStatusCallback)object4);
            } else {
                object6 = (zzv)object6.getService();
                object = zzeg.zza(null, object2);
                object2 = new zzdd((TaskCompletionSource)object3, (zzw)object4);
                object3 = object5.toIdString();
                object5 = new zzei(1, (zzeg)((Object)object), null, (IBinder)object4, null, (IBinder)object2, (String)object3);
                object6.zzv((zzei)((Object)object5));
            }
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    public final void zzu(PendingIntent pendingIntent, LocationRequest object, TaskCompletionSource taskCompletionSource) throws RemoteException {
        if (object2.zzG(zzo.zzj)) {
            ((zzv)object2.getService()).zzw(zzee.zzc(pendingIntent), (LocationRequest)((Object)object), (IStatusCallback)new zzdj(null, taskCompletionSource));
            return;
        }
        zzv zzv2 = (zzv)object2.getService();
        Object object2 = zzeg.zza(null, object);
        object = new zzdn(null, taskCompletionSource);
        PendingIntent pendingIntent2 = pendingIntent;
        int n = pendingIntent2.hashCode();
        int n2 = String.valueOf(n).length();
        StringBuilder stringBuilder = new StringBuilder(n2 + 14);
        stringBuilder.append("PendingIntent@");
        stringBuilder.append(n);
        zzv2.zzv(new zzei(1, (zzeg)((Object)object2), null, null, pendingIntent2, (IBinder)object, stringBuilder.toString()));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzv(ListenerHolder.ListenerKey object, boolean bl, TaskCompletionSource taskCompletionSource) throws RemoteException {
        SimpleArrayMap simpleArrayMap = ((zzdz)((Object)object2)).zzf;
        synchronized (simpleArrayMap) {
            object = (zzdy)((zzdz)((Object)object2)).zzf.remove(object);
            if (object == null) {
                taskCompletionSource.setResult((Object)Boolean.FALSE);
                return;
            }
            object.zzf();
            if (bl) {
                Object object2;
                bl = ((zzdz)((Object)object2)).zzG(zzo.zzj);
                if (bl) {
                    object2 = (zzv)object2.getService();
                    Object object3 = "ILocationListener@";
                    int n = System.identityHashCode(object);
                    int n2 = String.valueOf(n).length();
                    StringBuilder stringBuilder = new StringBuilder(n2 += 18);
                    stringBuilder.append((String)object3);
                    stringBuilder.append(n);
                    object = zzee.zza(null, (zzz)object, stringBuilder.toString());
                    object3 = Boolean.TRUE;
                    zzdj zzdj2 = new zzdj(object3, taskCompletionSource);
                    object2.zzx((zzee)((Object)object), (IStatusCallback)zzdj2);
                } else {
                    object2 = (zzv)object2.getService();
                    Object object4 = Boolean.TRUE;
                    zzdn zzdn2 = new zzdn(object4, taskCompletionSource);
                    object4 = new zzei(2, null, (IBinder)object, null, null, (IBinder)zzdn2, null);
                    object2.zzv((zzei)((Object)object4));
                }
            } else {
                taskCompletionSource.setResult((Object)Boolean.TRUE);
            }
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzw(ListenerHolder.ListenerKey object, boolean bl, TaskCompletionSource taskCompletionSource) throws RemoteException {
        SimpleArrayMap simpleArrayMap = ((zzdz)((Object)object2)).zzg;
        synchronized (simpleArrayMap) {
            object = (zzdv)((zzdz)((Object)object2)).zzg.remove(object);
            if (object == null) {
                taskCompletionSource.setResult((Object)Boolean.FALSE);
                return;
            }
            object.zzg();
            if (bl) {
                Object object2;
                bl = ((zzdz)((Object)object2)).zzG(zzo.zzj);
                if (bl) {
                    object2 = (zzv)object2.getService();
                    Object object3 = "ILocationCallback@";
                    int n = System.identityHashCode(object);
                    int n2 = String.valueOf(n).length();
                    StringBuilder stringBuilder = new StringBuilder(n2 += 18);
                    stringBuilder.append((String)object3);
                    stringBuilder.append(n);
                    object = zzee.zzb(null, (zzw)object, stringBuilder.toString());
                    object3 = Boolean.TRUE;
                    zzdj zzdj2 = new zzdj(object3, taskCompletionSource);
                    object2.zzx((zzee)((Object)object), (IStatusCallback)zzdj2);
                } else {
                    object2 = (zzv)object2.getService();
                    Object object4 = Boolean.TRUE;
                    zzdn zzdn2 = new zzdn(object4, taskCompletionSource);
                    object4 = new zzei(2, null, null, (IBinder)object, null, (IBinder)zzdn2, null);
                    object2.zzv((zzei)((Object)object4));
                }
            } else {
                taskCompletionSource.setResult((Object)Boolean.TRUE);
            }
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    public final void zzx(PendingIntent pendingIntent, TaskCompletionSource taskCompletionSource, Object object) throws RemoteException {
        if (object2.zzG(zzo.zzj)) {
            ((zzv)object2.getService()).zzx(zzee.zzc(pendingIntent), (IStatusCallback)new zzdj(null, taskCompletionSource));
            return;
        }
        zzv zzv2 = (zzv)object2.getService();
        Object object2 = new zzdn(null, taskCompletionSource);
        zzv2.zzv(new zzei(2, null, null, null, pendingIntent, (IBinder)object2, null));
    }

    public final void zzy(TaskCompletionSource taskCompletionSource) throws RemoteException {
        if (this.zzG(zzo.zzg)) {
            ((zzv)this.getService()).zzz(true, (IStatusCallback)new zzdj(null, taskCompletionSource));
            return;
        }
        ((zzv)this.getService()).zzy(true);
        taskCompletionSource.setResult(null);
    }

    public final void zzz(TaskCompletionSource taskCompletionSource) throws RemoteException {
        if (object.zzG(zzo.zzg)) {
            zzv zzv2 = (zzv)object.getService();
            Object object = true;
            zzv2.zzz(false, (IStatusCallback)new zzdj(object, taskCompletionSource));
            return;
        }
        ((zzv)object.getService()).zzy(false);
        taskCompletionSource.setResult((Object)true);
    }

    public final void zzA(Location location, TaskCompletionSource taskCompletionSource) throws RemoteException {
        if (this.zzG(zzo.zzh)) {
            ((zzv)this.getService()).zzB(location, (IStatusCallback)new zzdj(null, taskCompletionSource));
            return;
        }
        ((zzv)this.getService()).zzA(location);
        taskCompletionSource.setResult(null);
    }

    public final void zzB(TaskCompletionSource taskCompletionSource) throws RemoteException {
        ((zzv)this.getService()).zzC(new zzdn(null, taskCompletionSource));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzC(ListenerHolder object, DeviceOrientationRequest object2, TaskCompletionSource object3) throws RemoteException {
        Object object4 = Objects.requireNonNull(object.getListenerKey());
        SimpleArrayMap simpleArrayMap = ((zzdz)((Object)zzv2)).zzh;
        synchronized (simpleArrayMap) {
            zzdq zzdq2 = (zzdq)((zzdz)((Object)zzv2)).zzh.get(object4);
            if (zzdq2 == null) {
                zzdq2 = new zzdq((ListenerHolder)object);
                ((zzdz)((Object)zzv2)).zzh.put(object4, (Object)zzdq2);
                object = zzdq2;
            } else {
                zzdq2.zzc((ListenerHolder)object);
                object = zzdq2;
            }
            zzv zzv2 = (zzv)zzv2.getService();
            object4 = new zzh((DeviceOrientationRequest)((Object)object2), com.google.android.gms.internal.location.zzh.zza, null);
            object2 = new zzdn(null, (TaskCompletionSource)object3);
            object3 = new zzj(1, (zzh)((Object)object4), (IBinder)object, (IBinder)object2);
            zzv2.zzF((zzj)((Object)object3));
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzD(ListenerHolder.ListenerKey object, TaskCompletionSource object2) throws RemoteException {
        SimpleArrayMap simpleArrayMap = ((zzdz)((Object)zzv2)).zzh;
        synchronized (simpleArrayMap) {
            object = (zzdq)((zzdz)((Object)zzv2)).zzh.remove(object);
            if (object == null) {
                object2.setResult((Object)Boolean.FALSE);
                return;
            }
            ((zzdq)object).zze();
            zzv zzv2 = (zzv)zzv2.getService();
            Boolean bl = Boolean.TRUE;
            zzdn zzdn2 = new zzdn(bl, (TaskCompletionSource)object2);
            object2 = new zzj(2, null, (IBinder)object, (IBinder)zzdn2);
            zzv2.zzF((zzj)((Object)object2));
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    public final void zzE(GeofencingRequest geofencingRequest, PendingIntent pendingIntent, TaskCompletionSource taskCompletionSource) throws RemoteException {
        if (this.zzG(zzo.zzn)) {
            ((zzv)this.getService()).zze(geofencingRequest, pendingIntent, (IStatusCallback)new zzdj(null, taskCompletionSource));
            return;
        }
        ((zzv)this.getService()).zzd(geofencingRequest, pendingIntent, new zzdg(taskCompletionSource));
    }

    public final void zzF(zzem zzem2, TaskCompletionSource taskCompletionSource) throws RemoteException {
        if (this.zzG(zzo.zzn)) {
            ((zzv)this.getService()).zzg(zzem2, (IStatusCallback)new zzdj(null, taskCompletionSource));
            return;
        }
        ((zzv)this.getService()).zzf(zzem2, new zzdg(taskCompletionSource));
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final /* synthetic */ IInterface createServiceInterface(IBinder iBinder) {
        void var0_2;
        void var1_6;
        if (var1_6 == null) {
            return var0_2;
        }
        IInterface iInterface = var1_6.queryLocalInterface("com.google.android.gms.location.internal.IGoogleLocationManagerService");
        if (iInterface instanceof zzv) {
            zzv zzv2 = (zzv)iInterface;
            return var0_2;
        }
        zzu zzu2 = new zzu((IBinder)var1_6);
        return var0_2;
    }
}

