/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.zzz;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

@SafeParcelable.Reserved(value={4, 5, 1000})
@SafeParcelable.Class(creator="LocationSettingsRequestCreator")
public final class LocationSettingsRequest
extends AbstractSafeParcelable {
    @NonNull
    public static final Parcelable.Creator<LocationSettingsRequest> CREATOR;
    @SafeParcelable.Field(id=1, getter="getLocationRequests")
    private final List zza;
    @SafeParcelable.Field(id=2, getter="alwaysShow", defaultValue="false")
    private final boolean zzb;
    @SafeParcelable.Field(id=3, getter="needBle")
    private final boolean zzc;

    static {
        zzz zzz2;
        CREATOR = zzz2 = new zzz();
    }

    @SafeParcelable.Constructor
    LocationSettingsRequest(@SafeParcelable.Param(id=1) List list, @SafeParcelable.Param(id=2) boolean bl, @SafeParcelable.Param(id=3) boolean bl2) {
        this.zza = list;
        this.zzb = bl;
        this.zzc = bl2;
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel dest, int n) {
        void var1_1;
        n = SafeParcelWriter.beginObjectHeader((Parcel)dest);
        SafeParcelWriter.writeTypedList((Parcel)var1_1, (int)1, Collections.unmodifiableList(this.zza), (boolean)false);
        SafeParcelWriter.writeBoolean((Parcel)var1_1, (int)2, (boolean)this.zzb);
        SafeParcelWriter.writeBoolean((Parcel)var1_1, (int)3, (boolean)this.zzc);
        SafeParcelWriter.finishObjectHeader((Parcel)var1_1, (int)n);
    }

    public static final class Builder {
        private final ArrayList zza;
        private boolean zzb;
        private boolean zzc;

        @NonNull
        public Builder addAllLocationRequests(@NonNull Collection<LocationRequest> requests) {
            for (LocationRequest locationRequest : requests) {
                if (locationRequest == null) continue;
                this.zza.add(locationRequest);
            }
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder addLocationRequest(@NonNull LocationRequest request) {
            if (request != null) {
                void var1_1;
                this.zza.add(var1_1);
            }
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setAlwaysShow(boolean show) {
            void var1_1;
            this.zzb = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setNeedBle(boolean needBle) {
            void var1_1;
            this.zzc = var1_1;
            return this;
        }

        @NonNull
        public LocationSettingsRequest build() {
            LocationSettingsRequest locationSettingsRequest = new LocationSettingsRequest(this.zza, this.zzb, this.zzc);
            return locationSettingsRequest;
        }

        public Builder() {
            ArrayList arrayList;
            this.zza = arrayList = new ArrayList();
            this.zzb = false;
            this.zzc = false;
        }
    }
}

