/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.location.zzd;
import com.google.android.gms.internal.location.zzdj;
import com.google.android.gms.location.zzo;
import com.google.android.gms.location.zzv;
import org.checkerframework.dataflow.qual.Pure;

@SafeParcelable.Class(creator="LastLocationRequestCreator")
public final class LastLocationRequest
extends AbstractSafeParcelable {
    @NonNull
    public static final Parcelable.Creator<LastLocationRequest> CREATOR;
    @SafeParcelable.Field(id=1, getter="getMaxUpdateAgeMillis", defaultValueUnchecked="Long.MAX_VALUE")
    private final long zza;
    @SafeParcelable.Field(id=2, getter="getGranularity", defaultValueUnchecked="com.google.android.gms.location.Granularity.GRANULARITY_PERMISSION_LEVEL")
    private final int zzb;
    @SafeParcelable.Field(id=3, getter="isBypass", defaultValue="false")
    private final boolean zzc;
    @SafeParcelable.Field(id=4, getter="getModuleId")
    @Nullable
    private final String zzd;
    @SafeParcelable.Field(id=5, getter="getImpersonation")
    @Nullable
    private final zzd zze;

    @Pure
    public int getGranularity() {
        return this.zzb;
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.zza, this.zzb, this.zzc};
        return Objects.hashCode((Object[])objectArray);
    }

    @Pure
    public long getMaxUpdateAgeMillis() {
        return this.zza;
    }

    @NonNull
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("LastLocationRequest[");
        if (this.zza != Long.MAX_VALUE) {
            stringBuilder.append("maxAge=");
            zzdj.zzb(this.zza, stringBuilder);
        }
        if (this.zzb != 0) {
            stringBuilder.append(", ");
            stringBuilder.append(zzo.zzb(this.zzb));
        }
        if (this.zzc) {
            stringBuilder.append(", bypass");
        }
        if (this.zzd != null) {
            stringBuilder.append(", moduleId=");
            stringBuilder.append(this.zzd);
        }
        if (this.zze != null) {
            stringBuilder.append(", impersonation=");
            stringBuilder.append((Object)this.zze);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    static {
        zzv zzv2;
        CREATOR = zzv2 = new zzv();
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel parcel, int flags) {
        void var2_2;
        void var1_1;
        int n = SafeParcelWriter.beginObjectHeader((Parcel)parcel);
        SafeParcelWriter.writeLong((Parcel)var1_1, (int)1, (long)this.getMaxUpdateAgeMillis());
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)2, (int)this.getGranularity());
        SafeParcelWriter.writeBoolean((Parcel)var1_1, (int)3, (boolean)this.zzc);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)4, (String)this.zzd, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)5, (Parcelable)this.zze, (int)var2_2, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)var1_1, (int)n);
    }

    public boolean equals(@Nullable Object object) {
        LastLocationRequest lastLocationRequest;
        if (!(object instanceof LastLocationRequest)) {
            return false;
        }
        lastLocationRequest = lastLocationRequest;
        return this.zza == lastLocationRequest.zza && this.zzb == lastLocationRequest.zzb && this.zzc == lastLocationRequest.zzc && Objects.equal((Object)this.zzd, (Object)lastLocationRequest.zzd) && Objects.equal((Object)((Object)this.zze), (Object)((Object)lastLocationRequest.zze));
    }

    @Pure
    @Nullable
    public final zzd zza() {
        return this.zze;
    }

    @Deprecated
    @Pure
    @Nullable
    public final String zzb() {
        return this.zzd;
    }

    @SafeParcelable.Constructor
    LastLocationRequest(@SafeParcelable.Param(id=1) long l, @SafeParcelable.Param(id=2) int n, @SafeParcelable.Param(id=3) boolean bl, @SafeParcelable.Param(id=4) @Nullable String string, @SafeParcelable.Param(id=5) @Nullable zzd zzd2) {
        this.zza = l;
        this.zzb = n;
        this.zzc = bl;
        this.zzd = string;
        this.zze = zzd2;
    }

    @Pure
    public final boolean zzc() {
        return this.zzc;
    }

    public static final class Builder {
        private long zza;
        private int zzb;
        private boolean zzc;
        @Nullable
        private String zzd;
        @Nullable
        private zzd zze;

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setGranularity(int granularity) {
            void var1_1;
            zzo.zza(granularity);
            this.zzb = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        @NonNull
        public Builder setMaxUpdateAgeMillis(long maxUpdateAgeMillis) {
            void var1_1;
            boolean bl = maxUpdateAgeMillis > 0L;
            Preconditions.checkArgument((boolean)bl, (Object)"maxUpdateAgeMillis must be greater than 0");
            this.zza = var1_1;
            return this;
        }

        @NonNull
        public LastLocationRequest build() {
            LastLocationRequest lastLocationRequest = new LastLocationRequest(this.zza, this.zzb, this.zzc, this.zzd, this.zze);
            return lastLocationRequest;
        }

        public Builder() {
            this.zza = Long.MAX_VALUE;
            this.zzb = 0;
            this.zzc = false;
            this.zzd = null;
            this.zze = null;
        }

        /*
         * WARNING - void declaration
         */
        public Builder(@NonNull LastLocationRequest request) {
            void var1_1;
            this.zza = var1_1.getMaxUpdateAgeMillis();
            this.zzb = var1_1.getGranularity();
            this.zzc = var1_1.zzc();
            this.zzd = var1_1.zzb();
            this.zze = var1_1.zza();
        }
    }
}

