/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.location;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.Context;
import android.location.Location;
import android.os.Looper;
import androidx.annotation.Nullable;
import com.google.android.gms.common.Feature;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApi;
import com.google.android.gms.common.api.internal.ListenerHolder;
import com.google.android.gms.common.api.internal.ListenerHolders;
import com.google.android.gms.common.api.internal.RegistrationMethods;
import com.google.android.gms.common.api.internal.RemoteCall;
import com.google.android.gms.common.api.internal.TaskApiCall;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.location.zzav;
import com.google.android.gms.internal.location.zzaw;
import com.google.android.gms.internal.location.zzax;
import com.google.android.gms.internal.location.zzay;
import com.google.android.gms.internal.location.zzaz;
import com.google.android.gms.internal.location.zzba;
import com.google.android.gms.internal.location.zzbb;
import com.google.android.gms.internal.location.zzbc;
import com.google.android.gms.internal.location.zzbd;
import com.google.android.gms.internal.location.zzbe;
import com.google.android.gms.internal.location.zzbf;
import com.google.android.gms.internal.location.zzbg;
import com.google.android.gms.internal.location.zzbh;
import com.google.android.gms.internal.location.zzbi;
import com.google.android.gms.internal.location.zzbj;
import com.google.android.gms.internal.location.zzbk;
import com.google.android.gms.internal.location.zzbl;
import com.google.android.gms.internal.location.zzbm;
import com.google.android.gms.internal.location.zzbo;
import com.google.android.gms.location.CurrentLocationRequest;
import com.google.android.gms.location.FusedLocationProviderClient;
import com.google.android.gms.location.LastLocationRequest;
import com.google.android.gms.location.LocationAvailability;
import com.google.android.gms.location.LocationCallback;
import com.google.android.gms.location.LocationListener;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.zzm;
import com.google.android.gms.tasks.CancellationToken;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import java.util.concurrent.Executor;

public final class zzbp
extends GoogleApi
implements FusedLocationProviderClient {
    static final Api.ClientKey zza;
    public static final Api zzb;

    @Override
    public final Task<Void> flushLocations() {
        return this.doWrite(TaskApiCall.builder().run((RemoteCall)zzav.zza).setMethodKey(2422).build());
    }

    @Override
    public final Task<Location> getCurrentLocation(int n, @Nullable CancellationToken object) {
        CurrentLocationRequest.Builder builder = new CurrentLocationRequest.Builder();
        builder.setPriority(n);
        CurrentLocationRequest currentLocationRequest = builder.build();
        if (object != null) {
            Preconditions.checkArgument((boolean)(object.isCancellationRequested() ^ true), (Object)"cancellationToken may not be already canceled");
        }
        builder = TaskApiCall.builder();
        zzbh zzbh2 = new zzbh(currentLocationRequest, (CancellationToken)object);
        zzbp zzbp2 = zzbp2.doRead(builder.run(zzbh2).setMethodKey(2415).build());
        if (object != null) {
            currentLocationRequest = new TaskCompletionSource(object);
            object = new zzbi((TaskCompletionSource)currentLocationRequest);
            zzbp2.continueWith((Continuation)object);
            return currentLocationRequest.getTask();
        }
        return zzbp2;
    }

    @Override
    public final Task<Location> getCurrentLocation(CurrentLocationRequest currentLocationRequest, @Nullable CancellationToken object) {
        if (object != null) {
            Preconditions.checkArgument((boolean)(object.isCancellationRequested() ^ true), (Object)"cancellationToken may not be already canceled");
        }
        TaskApiCall.Builder builder = TaskApiCall.builder();
        zzbh zzbh2 = new zzbh(currentLocationRequest, (CancellationToken)object);
        zzbp zzbp2 = zzbp2.doRead(builder.run((RemoteCall)zzbh2).setMethodKey(2415).build());
        if (object != null) {
            currentLocationRequest = new TaskCompletionSource(object);
            object = new zzbi((TaskCompletionSource)currentLocationRequest);
            zzbp2.continueWith((Continuation)object);
            return currentLocationRequest.getTask();
        }
        return zzbp2;
    }

    @Override
    public final Task<Location> getLastLocation() {
        return this.doRead(TaskApiCall.builder().run((RemoteCall)zzbe.zza).setMethodKey(2414).build());
    }

    @Override
    public final Task<Location> getLastLocation(LastLocationRequest lastLocationRequest) {
        Feature[] featureArray = TaskApiCall.builder();
        zzbj zzbj2 = new zzbj(lastLocationRequest);
        lastLocationRequest = featureArray.run((RemoteCall)zzbj2);
        lastLocationRequest = lastLocationRequest.setMethodKey(2414);
        featureArray = new Feature[]{zzm.zzf};
        return this.doRead(lastLocationRequest.setFeatures(featureArray).build());
    }

    @Override
    public final Task<LocationAvailability> getLocationAvailability() {
        return this.doRead(TaskApiCall.builder().run((RemoteCall)zzba.zza).setMethodKey(2416).build());
    }

    @Override
    public final Task<Void> removeLocationUpdates(PendingIntent pendingIntent) {
        TaskApiCall.Builder builder = TaskApiCall.builder();
        zzbg zzbg2 = new zzbg(pendingIntent);
        return this.doWrite(builder.run((RemoteCall)zzbg2).setMethodKey(2418).build());
    }

    @Override
    public final Task<Void> removeLocationUpdates(LocationCallback locationCallback) {
        return this.doUnregisterEventListener(ListenerHolders.createListenerKey((Object)locationCallback, (String)LocationCallback.class.getSimpleName()), 2418).continueWith((Executor)zzbk.zza, (Continuation)zzbc.zza);
    }

    @Override
    public final Task<Void> removeLocationUpdates(LocationListener locationListener) {
        return this.doUnregisterEventListener(ListenerHolders.createListenerKey((Object)locationListener, (String)LocationListener.class.getSimpleName()), 2418).continueWith((Executor)zzbk.zza, (Continuation)zzbl.zza);
    }

    private final Task zza(LocationRequest locationRequest, ListenerHolder listenerHolder) {
        zzbo zzbo2 = new zzbo(this, listenerHolder, zzax.zza);
        zzay zzay2 = new zzay(zzbo2, locationRequest);
        return this.doRegisterEventListener(RegistrationMethods.builder().register((RemoteCall)zzay2).unregister((RemoteCall)zzbo2).withHolder(listenerHolder).setMethodKey(2436).build());
    }

    private final Task zzb(LocationRequest locationRequest, ListenerHolder listenerHolder) {
        zzbo zzbo2 = new zzbo(this, listenerHolder, zzbd.zza);
        zzbf zzbf2 = new zzbf(zzbo2, locationRequest);
        return this.doRegisterEventListener(RegistrationMethods.builder().register((RemoteCall)zzbf2).unregister((RemoteCall)zzbo2).withHolder(listenerHolder).setMethodKey(2435).build());
    }

    @Override
    public final Task<Void> requestLocationUpdates(LocationRequest locationRequest, PendingIntent pendingIntent) {
        TaskApiCall.Builder builder = TaskApiCall.builder();
        zzaz zzaz2 = new zzaz(pendingIntent, locationRequest);
        return this.doWrite(builder.run((RemoteCall)zzaz2).setMethodKey(2417).build());
    }

    @Override
    public final Task<Void> requestLocationUpdates(LocationRequest locationRequest, LocationCallback locationCallback, @Nullable Looper looper) {
        if (looper == null) {
            looper = Looper.myLooper();
            Preconditions.checkNotNull((Object)looper, (Object)"invalid null looper");
        }
        return this.zza(locationRequest, ListenerHolders.createListenerHolder((Object)locationCallback, (Looper)looper, (String)LocationCallback.class.getSimpleName()));
    }

    @Override
    public final Task<Void> requestLocationUpdates(LocationRequest locationRequest, LocationListener locationListener, @Nullable Looper looper) {
        if (looper == null) {
            looper = Looper.myLooper();
            Preconditions.checkNotNull((Object)looper, (Object)"invalid null looper");
        }
        return this.zzb(locationRequest, ListenerHolders.createListenerHolder((Object)locationListener, (Looper)looper, (String)LocationListener.class.getSimpleName()));
    }

    @Override
    public final Task<Void> requestLocationUpdates(LocationRequest locationRequest, Executor executor, LocationCallback locationCallback) {
        return this.zza(locationRequest, ListenerHolders.createListenerHolder((Object)locationCallback, (Executor)executor, (String)LocationCallback.class.getSimpleName()));
    }

    @Override
    public final Task<Void> requestLocationUpdates(LocationRequest locationRequest, Executor executor, LocationListener locationListener) {
        return this.zzb(locationRequest, ListenerHolders.createListenerHolder((Object)locationListener, (Executor)executor, (String)LocationListener.class.getSimpleName()));
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public final Task<Void> setMockLocation(Location location) {
        boolean bl = location != null;
        Preconditions.checkArgument((boolean)bl);
        TaskApiCall.Builder builder = TaskApiCall.builder();
        zzaw zzaw2 = new zzaw(location);
        return this.doWrite(builder.run((RemoteCall)zzaw2).setMethodKey(2421).build());
    }

    @Override
    public final Task<Void> setMockMode(boolean bl) {
        TaskApiCall.Builder builder = TaskApiCall.builder();
        zzbb zzbb2 = new zzbb(bl);
        return this.doWrite(builder.run((RemoteCall)zzbb2).setMethodKey(2420).build());
    }

    static {
        Api.ClientKey clientKey;
        zza = clientKey = new Api.ClientKey();
        zzbm zzbm2 = new zzbm();
        clientKey = new Api("LocationServices.API", (Api.AbstractClientBuilder)zzbm2, zza);
        zzb = clientKey;
    }

    public zzbp(Activity activity) {
        super(activity, zzb, (Api.ApiOptions)Api.ApiOptions.NO_OPTIONS, GoogleApi.Settings.DEFAULT_SETTINGS);
    }

    public zzbp(Context context) {
        super(context, zzb, (Api.ApiOptions)Api.ApiOptions.NO_OPTIONS, GoogleApi.Settings.DEFAULT_SETTINGS);
    }
}

