/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.location.ActivityTransition;
import com.google.android.gms.location.zzp;

@SafeParcelable.Reserved(value={1000})
@SafeParcelable.Class(creator="ActivityTransitionEventCreator")
public class ActivityTransitionEvent
extends AbstractSafeParcelable {
    @NonNull
    public static final Parcelable.Creator<ActivityTransitionEvent> CREATOR;
    @SafeParcelable.Field(id=1, getter="getActivityType")
    private final int zza;
    @SafeParcelable.Field(id=2, getter="getTransitionType")
    private final int zzb;
    @SafeParcelable.Field(id=3, getter="getElapsedRealTimeNanos")
    private final long zzc;

    public int getActivityType() {
        return this.zza;
    }

    public int getTransitionType() {
        return this.zzb;
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.zza, this.zzb, this.zzc};
        return Objects.hashCode((Object[])objectArray);
    }

    public long getElapsedRealTimeNanos() {
        return this.zzc;
    }

    @NonNull
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = ((ActivityTransitionEvent)((Object)object)).zza;
        StringBuilder stringBuilder2 = new StringBuilder(24);
        stringBuilder2.append("ActivityType ");
        stringBuilder2.append(n);
        stringBuilder.append(stringBuilder2.toString());
        stringBuilder.append(" ");
        n = ((ActivityTransitionEvent)((Object)object)).zzb;
        stringBuilder2 = new StringBuilder(26);
        stringBuilder2.append("TransitionType ");
        stringBuilder2.append(n);
        stringBuilder.append(stringBuilder2.toString());
        stringBuilder.append(" ");
        long l = ((ActivityTransitionEvent)((Object)object)).zzc;
        Object object = new StringBuilder(41);
        ((StringBuilder)object).append("ElapsedRealTimeNanos ");
        ((StringBuilder)object).append(l);
        stringBuilder.append(((StringBuilder)object).toString());
        return stringBuilder.toString();
    }

    static {
        zzp zzp2;
        CREATOR = zzp2 = new zzp();
    }

    /*
     * WARNING - void declaration
     */
    @SafeParcelable.Constructor
    public ActivityTransitionEvent(@SafeParcelable.Param(id=1) int activityType, @SafeParcelable.Param(id=2) int transitionType, @SafeParcelable.Param(id=3) long elapsedRealtimeNanos) {
        void var3_3;
        void var1_1;
        void var2_2;
        ActivityTransition.zza((int)var2_2);
        this.zza = var1_1;
        this.zzb = var2_2;
        this.zzc = var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel dest, int n) {
        void var1_1;
        Preconditions.checkNotNull((Object)dest);
        n = SafeParcelWriter.beginObjectHeader((Parcel)var1_1);
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)1, (int)this.getActivityType());
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)2, (int)this.getTransitionType());
        SafeParcelWriter.writeLong((Parcel)var1_1, (int)3, (long)this.getElapsedRealTimeNanos());
        SafeParcelWriter.finishObjectHeader((Parcel)var1_1, (int)n);
    }

    public boolean equals(@Nullable Object object) {
        ActivityTransitionEvent activityTransitionEvent;
        if (this == activityTransitionEvent) {
            return true;
        }
        if (!(activityTransitionEvent instanceof ActivityTransitionEvent)) {
            return false;
        }
        activityTransitionEvent = activityTransitionEvent;
        return this.zza == activityTransitionEvent.zza && this.zzb == activityTransitionEvent.zzb && this.zzc == activityTransitionEvent.zzc;
    }
}

