/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.location;

import android.app.PendingIntent;
import android.content.Context;
import android.location.Location;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.Feature;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.BaseImplementation;
import com.google.android.gms.common.api.internal.ConnectionCallbacks;
import com.google.android.gms.common.api.internal.IStatusCallback;
import com.google.android.gms.common.api.internal.ListenerHolder;
import com.google.android.gms.common.api.internal.ListenerHolders;
import com.google.android.gms.common.api.internal.OnConnectionFailedListener;
import com.google.android.gms.common.internal.ClientSettings;
import com.google.android.gms.common.internal.GmsClient;
import com.google.android.gms.common.internal.ICancelToken;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.location.zzai;
import com.google.android.gms.internal.location.zzal;
import com.google.android.gms.internal.location.zzam;
import com.google.android.gms.internal.location.zzao;
import com.google.android.gms.internal.location.zzar;
import com.google.android.gms.internal.location.zzas;
import com.google.android.gms.internal.location.zzat;
import com.google.android.gms.internal.location.zzau;
import com.google.android.gms.internal.location.zzav;
import com.google.android.gms.internal.location.zzay;
import com.google.android.gms.internal.location.zzaz;
import com.google.android.gms.internal.location.zzba;
import com.google.android.gms.internal.location.zzbc;
import com.google.android.gms.internal.location.zzbd;
import com.google.android.gms.internal.location.zzbf;
import com.google.android.gms.internal.location.zzbh;
import com.google.android.gms.internal.location.zzbn;
import com.google.android.gms.internal.location.zzj;
import com.google.android.gms.location.CurrentLocationRequest;
import com.google.android.gms.location.GeofencingRequest;
import com.google.android.gms.location.LastLocationRequest;
import com.google.android.gms.location.LocationAvailability;
import com.google.android.gms.location.LocationCallback;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationSettingsRequest;
import com.google.android.gms.location.zzbi;
import com.google.android.gms.location.zzbl;
import com.google.android.gms.location.zzy;
import com.google.android.gms.tasks.CancellationToken;
import com.google.android.gms.tasks.OnTokenCanceledListener;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

public final class zzbe
extends GmsClient {
    private final Map zzf;
    private final Map zzg;
    private final Map zzh;
    private final String zzi;
    private boolean zzj;
    public static final /* synthetic */ int zze;

    public final int getMinApkVersion() {
        return 11717000;
    }

    protected final Bundle getGetServiceRequestExtraArgs() {
        Bundle bundle = new Bundle();
        bundle.putString("client_name", this.zzi);
        return bundle;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final /* synthetic */ IInterface createServiceInterface(IBinder iBinder) {
        void var0_2;
        void var1_6;
        if (var1_6 == null) {
            return var0_2;
        }
        IInterface iInterface = var1_6.queryLocalInterface("com.google.android.gms.location.internal.IGoogleLocationManagerService");
        if (iInterface instanceof zzam) {
            zzam zzam2 = (zzam)iInterface;
            return var0_2;
        }
        zzal zzal2 = new zzal((IBinder)var1_6);
        return var0_2;
    }

    public final LocationAvailability zzp() throws RemoteException {
        return ((zzam)this.getService()).zzf(this.getContext().getPackageName());
    }

    protected final String getServiceDescriptor() {
        return "com.google.android.gms.location.internal.IGoogleLocationManagerService";
    }

    protected final String getStartServiceAction() {
        return "com.google.android.location.internal.GoogleLocationManagerService.START";
    }

    public zzbe(Context object, Looper looper, ClientSettings clientSettings, ConnectionCallbacks connectionCallbacks, OnConnectionFailedListener onConnectionFailedListener, String string) {
        super(object, looper, 23, clientSettings, connectionCallbacks, onConnectionFailedListener);
        super();
        this.zzf = object;
        super();
        this.zzg = object;
        super();
        this.zzh = object;
        this.zzi = string;
    }

    public final void zzq(GeofencingRequest geofencingRequest, PendingIntent pendingIntent, BaseImplementation.ResultHolder resultHolder) throws RemoteException {
        Preconditions.checkNotNull((Object)((Object)geofencingRequest), (Object)"geofencingRequest can't be null.");
        Preconditions.checkNotNull((Object)pendingIntent, (Object)"PendingIntent must be specified.");
        Preconditions.checkNotNull((Object)resultHolder, (Object)"ResultHolder not provided.");
        zzba zzba2 = new zzba(resultHolder);
        ((zzam)this.getService()).zzg(geofencingRequest, pendingIntent, zzba2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void zzr(LocationSettingsRequest locationSettingsRequest, BaseImplementation.ResultHolder resultHolder, String string) throws RemoteException {
        boolean bl = locationSettingsRequest != null;
        Preconditions.checkArgument((boolean)bl, (Object)"locationSettingsRequest can't be null nor empty.");
        bl = resultHolder != null;
        Preconditions.checkArgument((boolean)bl, (Object)"listener can't be null.");
        zzbd zzbd2 = new zzbd(resultHolder);
        ((zzam)this.getService()).zzh(locationSettingsRequest, zzbd2, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public final void disconnect() {
        // MONITORENTER : this
        boolean bl = this.isConnected();
        if (bl) {
            boolean bl2;
            boolean bl3;
            boolean bl4;
            Map map = this.zzf;
            // MONITORENTER : map
            Iterator iterator = this.zzf.values().iterator();
            while (bl4 = iterator.hasNext()) {
                Object object = iterator.next();
                object = (zzbc)object;
                ((zzam)this.getService()).zzz(zzbh.zzb(object, null));
            }
            this.zzf.clear();
            // MONITOREXIT : map
            map = this.zzg;
            // MONITORENTER : map
            iterator = this.zzg.values().iterator();
            while (bl3 = iterator.hasNext()) {
                Object object = iterator.next();
                object = (zzay)object;
                ((zzam)this.getService()).zzz(zzbh.zza(object, null));
            }
            this.zzg.clear();
            // MONITOREXIT : map
            map = this.zzh;
            // MONITORENTER : map
            iterator = this.zzh.values().iterator();
            while (bl2 = iterator.hasNext()) {
                zzaz zzaz2 = (zzaz)iterator.next();
                zzam zzam2 = (zzam)this.getService();
                zzj zzj2 = new zzj(2, null, (IBinder)zzaz2, null);
                zzam2.zzy(zzj2);
            }
            this.zzh.clear();
            // MONITOREXIT : map
            try {
                boolean bl5 = this.zzj;
                if (bl5) {
                    zzat zzat2 = new zzat(this);
                    this.zzF(false, (IStatusCallback)zzat2);
                }
            }
            catch (Exception exception) {
                Log.e((String)"LocationClientImpl", (String)"Client disconnected before listeners could be cleaned up", (Throwable)exception);
            }
        }
        super.disconnect();
        // MONITOREXIT : this
    }

    public final void zzs(zzai zzai2) throws RemoteException {
        ((zzam)this.getService()).zzi(zzai2);
    }

    public final void zzt(CurrentLocationRequest object, CancellationToken object2, zzao zzao2) throws RemoteException {
        if (zzbe2.zzG(zzy.zze)) {
            zzbe zzbe2 = ((zzam)zzbe2.getService()).zze((CurrentLocationRequest)((Object)object), zzao2);
            if (object2 != null) {
                object = new zzar((ICancelToken)zzbe2);
                object2.onCanceledRequested((OnTokenCanceledListener)object);
                return;
            }
            return;
        }
        AtomicReference<zzau> atomicReference = new AtomicReference<zzau>();
        zzas zzas2 = new zzas(zzbe2, atomicReference);
        zzau zzau2 = new zzau(zzbe2, zzao2, zzas2);
        zzau2 = ListenerHolders.createListenerHolder((Object)zzau2, (Looper)zzbn.zza(Looper.getMainLooper()), (String)LocationCallback.class.getSimpleName());
        atomicReference.set(zzau2);
        if (object2 != null) {
            object2.onCanceledRequested((OnTokenCanceledListener)zzas2);
        }
        object2 = LocationRequest.create();
        ((LocationRequest)((Object)object2)).setPriority(((CurrentLocationRequest)((Object)object)).getPriority());
        ((LocationRequest)((Object)object2)).setInterval(0L);
        ((LocationRequest)((Object)object2)).setFastestInterval(0L);
        ((LocationRequest)((Object)object2)).setExpirationDuration(((CurrentLocationRequest)((Object)object)).getDurationMillis());
        object2 = zzbf.zzc(null, (LocationRequest)((Object)object2));
        ((zzbf)((Object)object2)).zzj = true;
        ((zzbf)((Object)object2)).zze(((CurrentLocationRequest)((Object)object)).getMaxUpdateAgeMillis());
        object = new zzav(zzbe2, zzao2);
        zzbe2.zzB((zzbf)((Object)object2), (ListenerHolder)zzau2, (zzai)object);
    }

    public final void zzu(LastLocationRequest lastLocationRequest, zzao zzao2) throws RemoteException {
        if (this.zzG(zzy.zzf)) {
            ((zzam)this.getService()).zzj(lastLocationRequest, zzao2);
            return;
        }
        zzao2.zzb(Status.RESULT_SUCCESS, ((zzam)this.getService()).zzd());
    }

    public final void zzv(PendingIntent pendingIntent) throws RemoteException {
        Preconditions.checkNotNull((Object)pendingIntent);
        ((zzam)this.getService()).zzl(pendingIntent);
    }

    public final void zzw(PendingIntent pendingIntent, BaseImplementation.ResultHolder resultHolder) throws RemoteException {
        Preconditions.checkNotNull((Object)pendingIntent, (Object)"PendingIntent must be specified.");
        Preconditions.checkNotNull((Object)resultHolder, (Object)"ResultHolder not provided.");
        zzba zzba2 = new zzba(resultHolder);
        ((zzam)this.getService()).zzn(pendingIntent, zzba2, this.getContext().getPackageName());
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public final void zzx(List stringArray, BaseImplementation.ResultHolder resultHolder) throws RemoteException {
        void var3_4;
        if (stringArray != null) {
            if (stringArray.size() > 0) {
                boolean bl = true;
            } else {
                boolean bl = false;
            }
        } else {
            boolean bl = false;
        }
        Preconditions.checkArgument((boolean)var3_4, (Object)"geofenceRequestIds can't be null nor empty.");
        Preconditions.checkNotNull((Object)resultHolder, (Object)"ResultHolder not provided.");
        String[] stringArray2 = new String[]{};
        stringArray = stringArray.toArray(stringArray2);
        zzba zzba2 = new zzba(resultHolder);
        ((zzam)this.getService()).zzo(stringArray, zzba2, this.getContext().getPackageName());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzy(ListenerHolder.ListenerKey object, zzai zzai2) throws RemoteException {
        Preconditions.checkNotNull((Object)object, (Object)"Invalid null listener key");
        Map map = this.zzg;
        synchronized (map) {
            object = (zzay)this.zzg.remove(object);
            if (object == null) return;
            ((zzay)object).zzc();
            ((zzam)this.getService()).zzz(zzbh.zza((zzbi)object, zzai2));
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzz(ListenerHolder.ListenerKey object, zzai zzai2) throws RemoteException {
        Preconditions.checkNotNull((Object)object, (Object)"Invalid null listener key");
        Map map = this.zzf;
        synchronized (map) {
            object = (zzbc)this.zzf.remove(object);
            if (object == null) return;
            ((zzbc)object).zzc();
            ((zzam)this.getService()).zzz(zzbh.zzb((zzbl)object, zzai2));
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    public final void zzA(PendingIntent pendingIntent, zzai zzai2) throws RemoteException {
        Object object = object.getService();
        object = (zzam)object;
        zzbh zzbh2 = new zzbh(2, null, null, null, pendingIntent, (IBinder)zzai2, null);
        object.zzz(zzbh2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzB(zzbf zzbf2, ListenerHolder object, zzai zzai2) throws RemoteException {
        Object object2 = object.getListenerKey();
        if (object2 == null) {
            Object object3 = new RuntimeException();
            Log.e((String)"LocationClientImpl", (String)"requested location updates on dead listener", (Throwable)object3);
            return;
        }
        object3.getContext();
        synchronized (object3) {
            Object object4;
            Object object5 = object3.zzg;
            synchronized (object5) {
                object4 = (zzay)object3.zzg.get(object2);
                if (object4 == null) {
                    object4 = new zzay((ListenerHolder)object);
                    object3.zzg.put(object2, object4);
                    object = object4;
                } else {
                    object = object4;
                }
            }
            object5 = (zzam)object3.getService();
            object2 = object2.toIdString();
            object4 = new zzbh(1, zzbf2, null, (IBinder)object, null, (IBinder)zzai2, (String)object2);
            object5.zzz((zzbh)((Object)object4));
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzC(zzbf zzbf2, ListenerHolder object, zzai zzai2) throws RemoteException {
        Object object2 = object.getListenerKey();
        if (object2 == null) {
            Object object3 = new RuntimeException();
            Log.e((String)"LocationClientImpl", (String)"requested location updates on dead listener", (Throwable)object3);
            return;
        }
        object3.getContext();
        synchronized (object3) {
            Object object4;
            Object object5 = object3.zzf;
            synchronized (object5) {
                object4 = (zzbc)object3.zzf.get(object2);
                if (object4 == null) {
                    object4 = new zzbc((ListenerHolder)object);
                    object3.zzf.put(object2, object4);
                    object = object4;
                } else {
                    object = object4;
                }
            }
            object5 = (zzam)object3.getService();
            object2 = object2.toIdString();
            object4 = new zzbh(1, zzbf2, (IBinder)object, null, null, (IBinder)zzai2, (String)object2);
            object5.zzz((zzbh)((Object)object4));
            return;
        }
    }

    public final void zzD(zzbf zzbf2, PendingIntent pendingIntent, zzai zzai2) throws RemoteException {
        object.getContext();
        Object object = object.getService();
        object = (zzam)object;
        int n = pendingIntent.hashCode();
        StringBuilder stringBuilder = new StringBuilder(25);
        stringBuilder.append("PendingIntent@");
        stringBuilder.append(n);
        zzbh zzbh2 = new zzbh(1, zzbf2, null, null, pendingIntent, (IBinder)zzai2, stringBuilder.toString());
        object.zzz(zzbh2);
    }

    public final void zzE(Location location, IStatusCallback iStatusCallback) throws RemoteException {
        if (this.zzG(zzy.zzh)) {
            ((zzam)this.getService()).zzv(location, iStatusCallback);
            return;
        }
        ((zzam)this.getService()).zzu(location);
        iStatusCallback.onResult(Status.RESULT_SUCCESS);
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void zzF(boolean bl, IStatusCallback iStatusCallback) throws RemoteException {
        if (this.zzG(zzy.zzg)) {
            ((zzam)this.getService()).zzx(bl, iStatusCallback);
        } else {
            ((zzam)this.getService()).zzw(bl);
            iStatusCallback.onResult(Status.RESULT_SUCCESS);
        }
        this.zzj = bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean zzG(Feature feature) {
        Feature[] featureArray = this.getAvailableFeatures();
        if (featureArray == null) {
            return false;
        }
        int n = featureArray.length;
        int n2 = 0;
        while (n2 < n) {
            Feature feature2 = featureArray[n2];
            if (feature.getName().equals(feature2.getName())) {
                Feature feature3 = feature2;
                if (feature3 == null) {
                    return false;
                }
                if (feature3.getVersion() < feature.getVersion()) return false;
                return true;
            }
            ++n2;
        }
        return false;
    }

    public final boolean usesClientTelemetry() {
        return true;
    }

    public final Feature[] getApiFeatures() {
        return zzy.zzj;
    }
}

