/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.zzbj;
import com.google.android.gms.location.zzbl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

@SafeParcelable.Reserved(value={1000})
@SafeParcelable.Class(creator="LocationSettingsRequestCreator")
public final class LocationSettingsRequest
extends AbstractSafeParcelable {
    @RecentlyNonNull
    public static final Parcelable.Creator<LocationSettingsRequest> CREATOR;
    @SafeParcelable.Field(id=1, getter="getLocationRequests")
    private final List<LocationRequest> zza;
    @SafeParcelable.Field(id=2, getter="alwaysShow", defaultValue="false")
    private final boolean zzb;
    @SafeParcelable.Field(id=3, getter="needBle")
    private final boolean zzc;
    @Nullable
    @SafeParcelable.Field(id=5, getter="getConfiguration")
    private zzbj zzd;

    public void writeToParcel(@RecentlyNonNull Parcel parcel, int n) {
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel);
        SafeParcelWriter.writeTypedList((Parcel)parcel, (int)1, Collections.unmodifiableList(this.zza), (boolean)false);
        SafeParcelWriter.writeBoolean((Parcel)parcel, (int)2, (boolean)this.zzb);
        SafeParcelWriter.writeBoolean((Parcel)parcel, (int)3, (boolean)this.zzc);
        SafeParcelWriter.writeParcelable((Parcel)parcel, (int)5, (Parcelable)this.zzd, (int)n, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel, (int)n2);
    }

    static {
        zzbl zzbl2;
        CREATOR = zzbl2 = new zzbl();
    }

    @SafeParcelable.Constructor
    LocationSettingsRequest(@SafeParcelable.Param(id=1) List<LocationRequest> list, @SafeParcelable.Param(id=2) boolean bl, @SafeParcelable.Param(id=3) boolean bl2, @Nullable @SafeParcelable.Param(id=5) zzbj zzbj2) {
        this.zza = list;
        this.zzb = bl;
        this.zzc = bl2;
        this.zzd = zzbj2;
    }

    public static final class Builder {
        private final ArrayList<LocationRequest> zza;
        private boolean zzb;
        private boolean zzc;

        public Builder() {
            ArrayList arrayList = new ArrayList();
            this.zza = arrayList;
            this.zzb = false;
            this.zzc = false;
        }

        @RecentlyNonNull
        public Builder addLocationRequest(@RecentlyNonNull LocationRequest locationRequest) {
            if (locationRequest != null) {
                this.zza.add(locationRequest);
            }
            return this;
        }

        @RecentlyNonNull
        public Builder addAllLocationRequests(@RecentlyNonNull Collection<LocationRequest> object) {
            object = object.iterator();
            while (object.hasNext()) {
                LocationRequest locationRequest = (LocationRequest)((Object)object.next());
                if (locationRequest == null) continue;
                this.zza.add(locationRequest);
            }
            return this;
        }

        @RecentlyNonNull
        public Builder setAlwaysShow(boolean bl) {
            this.zzb = bl;
            return this;
        }

        @RecentlyNonNull
        public Builder setNeedBle(boolean bl) {
            this.zzc = bl;
            return this;
        }

        @RecentlyNonNull
        public LocationSettingsRequest build() {
            LocationSettingsRequest locationSettingsRequest = new LocationSettingsRequest(this.zza, this.zzb, this.zzc, null);
            return locationSettingsRequest;
        }
    }
}

