/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.app.Activity;
import android.content.Context;
import androidx.annotation.RecentlyNonNull;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.location.zzaf;
import com.google.android.gms.internal.location.zzaz;
import com.google.android.gms.internal.location.zzbi;
import com.google.android.gms.internal.location.zzz;
import com.google.android.gms.location.FusedLocationProviderApi;
import com.google.android.gms.location.FusedLocationProviderClient;
import com.google.android.gms.location.GeofencingApi;
import com.google.android.gms.location.GeofencingClient;
import com.google.android.gms.location.SettingsApi;
import com.google.android.gms.location.SettingsClient;
import com.google.android.gms.location.zzbh;

public class LocationServices {
    @RecentlyNonNull
    public static final Api<Api.ApiOptions.NoOptions> API;
    @Deprecated
    @RecentlyNonNull
    public static final FusedLocationProviderApi FusedLocationApi;
    @Deprecated
    @RecentlyNonNull
    public static final GeofencingApi GeofencingApi;
    @Deprecated
    @RecentlyNonNull
    public static final SettingsApi SettingsApi;
    private static final Api.ClientKey<zzaz> zza;
    private static final Api.AbstractClientBuilder<zzaz, Api.ApiOptions.NoOptions> zzb;

    private LocationServices() {
    }

    @RecentlyNonNull
    public static GeofencingClient getGeofencingClient(@RecentlyNonNull Activity activity) {
        GeofencingClient geofencingClient = new GeofencingClient(activity);
        return geofencingClient;
    }

    @RecentlyNonNull
    public static GeofencingClient getGeofencingClient(@RecentlyNonNull Context context) {
        GeofencingClient geofencingClient = new GeofencingClient(context);
        return geofencingClient;
    }

    @RecentlyNonNull
    public static SettingsClient getSettingsClient(@RecentlyNonNull Activity activity) {
        SettingsClient settingsClient = new SettingsClient(activity);
        return settingsClient;
    }

    @RecentlyNonNull
    public static SettingsClient getSettingsClient(@RecentlyNonNull Context context) {
        SettingsClient settingsClient = new SettingsClient(context);
        return settingsClient;
    }

    @RecentlyNonNull
    public static FusedLocationProviderClient getFusedLocationProviderClient(@RecentlyNonNull Activity activity) {
        FusedLocationProviderClient fusedLocationProviderClient = new FusedLocationProviderClient(activity);
        return fusedLocationProviderClient;
    }

    @RecentlyNonNull
    public static FusedLocationProviderClient getFusedLocationProviderClient(@RecentlyNonNull Context context) {
        FusedLocationProviderClient fusedLocationProviderClient = new FusedLocationProviderClient(context);
        return fusedLocationProviderClient;
    }

    static {
        Object object;
        zza = object = new Api.ClientKey();
        zzb = object = new zzbh();
        API = object = new Api("LocationServices.API", zzb, zza);
        object = new zzz();
        FusedLocationApi = object;
        object = new zzaf();
        GeofencingApi = object;
        object = new zzbi();
        SettingsApi = object;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static zzaz zza(GoogleApiClient googleApiClient) {
        boolean bl = googleApiClient != null;
        Preconditions.checkArgument((boolean)bl, (Object)"GoogleApiClient parameter is required.");
        zzaz zzaz2 = (zzaz)googleApiClient.getClient(zza);
        boolean bl2 = zzaz2 != null;
        Preconditions.checkState((boolean)bl2, (Object)"GoogleApiClient is not configured to use the LocationServices.API Api. Pass thisinto GoogleApiClient.Builder#addApi() to use this feature.");
        return zzaz2;
    }
}

