/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.content.Intent;
import android.location.Location;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.RecentlyNonNull;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.location.zzbg;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

@SafeParcelable.Reserved(value={1000})
@SafeParcelable.Class(creator="LocationResultCreator")
public final class LocationResult
extends AbstractSafeParcelable
implements ReflectedParcelable {
    @RecentlyNonNull
    public static final Parcelable.Creator<LocationResult> CREATOR;
    static final List<Location> zza;
    @SafeParcelable.Field(id=1, getter="getLocations", defaultValueUnchecked="LocationResult.DEFAULT_LOCATIONS")
    private final List<Location> zzb;

    @RecentlyNonNull
    public static LocationResult create(@RecentlyNonNull List<Location> list) {
        if (list == null) {
            list = zza;
        }
        LocationResult locationResult = new LocationResult(list);
        return locationResult;
    }

    @SafeParcelable.Constructor
    LocationResult(@SafeParcelable.Param(id=1) List<Location> list) {
        this.zzb = list;
    }

    @RecentlyNonNull
    public Location getLastLocation() {
        int n = this.zzb.size();
        if (n == 0) {
            return null;
        }
        return this.zzb.get(n + -1);
    }

    @RecentlyNonNull
    public List<Location> getLocations() {
        return this.zzb;
    }

    public void writeToParcel(@RecentlyNonNull Parcel parcel, int n) {
        n = SafeParcelWriter.beginObjectHeader((Parcel)parcel);
        SafeParcelWriter.writeTypedList((Parcel)parcel, (int)1, this.getLocations(), (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel, (int)n);
    }

    public int hashCode() {
        Iterator<Location> iterator = this.zzb.iterator();
        int n = 17;
        while (iterator.hasNext()) {
            long l = iterator.next().getTime();
            n = n * 31 + (int)(l ^ l >>> 32);
        }
        return n;
    }

    public boolean equals(@RecentlyNonNull Object iterator) {
        if (iterator instanceof LocationResult) {
            iterator = (LocationResult)((Object)iterator);
            if (((LocationResult)((Object)iterator)).zzb.size() != ((LocationResult)((Object)iterator2)).zzb.size()) {
                return false;
            }
            iterator = ((LocationResult)((Object)iterator)).zzb.iterator();
            Iterator<Location> iterator2 = ((LocationResult)((Object)iterator2)).zzb.iterator();
            while (iterator.hasNext()) {
                Object object = iterator2.next();
                object = (Location)object;
                Location location = iterator.next();
                if (object.getTime() == location.getTime()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @RecentlyNonNull
    public String toString() {
        Object object = String.valueOf(object.zzb);
        String string = String.valueOf(object);
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder(n + 27);
        stringBuilder.append("LocationResult[locations: ");
        stringBuilder.append((String)object);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static boolean hasResult(@RecentlyNonNull Intent intent) {
        if (intent == null) {
            return false;
        }
        return intent.hasExtra("com.google.android.gms.location.EXTRA_LOCATION_RESULT");
    }

    @RecentlyNonNull
    public static LocationResult extractResult(@RecentlyNonNull Intent intent) {
        if (!LocationResult.hasResult(intent)) {
            return null;
        }
        return (LocationResult)intent.getParcelableExtra("com.google.android.gms.location.EXTRA_LOCATION_RESULT");
    }

    static {
        zzbg zzbg2;
        zza = Collections.emptyList();
        CREATOR = zzbg2 = new zzbg();
    }
}

