/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.Context;
import android.location.Location;
import android.os.Looper;
import android.os.RemoteException;
import androidx.annotation.RecentlyNonNull;
import androidx.annotation.RequiresPermission;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.common.Feature;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApi;
import com.google.android.gms.common.api.internal.ApiExceptionMapper;
import com.google.android.gms.common.api.internal.ListenerHolder;
import com.google.android.gms.common.api.internal.ListenerHolders;
import com.google.android.gms.common.api.internal.RegistrationMethods;
import com.google.android.gms.common.api.internal.RemoteCall;
import com.google.android.gms.common.api.internal.StatusExceptionMapper;
import com.google.android.gms.common.api.internal.TaskApiCall;
import com.google.android.gms.common.api.internal.TaskUtil;
import com.google.android.gms.internal.location.zzaz;
import com.google.android.gms.internal.location.zzba;
import com.google.android.gms.internal.location.zzbj;
import com.google.android.gms.location.LocationAvailability;
import com.google.android.gms.location.LocationCallback;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationServices;
import com.google.android.gms.location.zzaa;
import com.google.android.gms.location.zzab;
import com.google.android.gms.location.zzac;
import com.google.android.gms.location.zzad;
import com.google.android.gms.location.zzae;
import com.google.android.gms.location.zzaf;
import com.google.android.gms.location.zzag;
import com.google.android.gms.location.zzah;
import com.google.android.gms.location.zzai;
import com.google.android.gms.location.zzaj;
import com.google.android.gms.location.zzak;
import com.google.android.gms.location.zzam;
import com.google.android.gms.location.zzan;
import com.google.android.gms.location.zzao;
import com.google.android.gms.location.zzap;
import com.google.android.gms.location.zzu;
import com.google.android.gms.location.zzv;
import com.google.android.gms.location.zzw;
import com.google.android.gms.location.zzx;
import com.google.android.gms.location.zzy;
import com.google.android.gms.location.zzz;
import com.google.android.gms.tasks.CancellationToken;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.OnTokenCanceledListener;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;

public class FusedLocationProviderClient
extends GoogleApi<Api.ApiOptions.NoOptions> {
    @RecentlyNonNull
    public static final String KEY_MOCK_LOCATION = "mockLocation";
    @RecentlyNonNull
    public static final String KEY_VERTICAL_ACCURACY = "verticalAccuracy";

    @VisibleForTesting(otherwise=3)
    public FusedLocationProviderClient(@RecentlyNonNull Context context) {
        Api<Api.ApiOptions.NoOptions> api = LocationServices.API;
        Api.ApiOptions.NoOptions noOptions = Api.ApiOptions.NO_OPTIONS;
        ApiExceptionMapper apiExceptionMapper = new ApiExceptionMapper();
        super(context, api, (Api.ApiOptions)noOptions, (StatusExceptionMapper)apiExceptionMapper);
    }

    @VisibleForTesting(otherwise=3)
    public FusedLocationProviderClient(@RecentlyNonNull Activity activity) {
        Api<Api.ApiOptions.NoOptions> api = LocationServices.API;
        Api.ApiOptions.NoOptions noOptions = Api.ApiOptions.NO_OPTIONS;
        ApiExceptionMapper apiExceptionMapper = new ApiExceptionMapper();
        super(activity, api, (Api.ApiOptions)noOptions, (StatusExceptionMapper)apiExceptionMapper);
    }

    @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    @RecentlyNonNull
    public Task<Location> getLastLocation() {
        TaskApiCall.Builder builder = TaskApiCall.builder();
        zzv zzv2 = new zzv(this);
        return this.doRead(builder.run((RemoteCall)zzv2).setMethodKey(2414).build());
    }

    @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    @RecentlyNonNull
    public Task<Location> getCurrentLocation(int n, @RecentlyNonNull CancellationToken object) {
        Feature[] featureArray = LocationRequest.create();
        featureArray.setPriority(n);
        featureArray.setInterval(0L);
        featureArray.setFastestInterval(0L);
        featureArray.setExpirationDuration(30000L);
        zzba zzba2 = zzba.zza(null, (LocationRequest)featureArray);
        zzba2.zzd(true);
        zzba2.zzb(10000L);
        featureArray = new zzab(fusedLocationProviderClient, (CancellationToken)object, zzba2);
        zzba2 = TaskApiCall.builder();
        zzba2 = zzba2.run((RemoteCall)featureArray);
        featureArray = new Feature[]{zzu.zzd};
        FusedLocationProviderClient fusedLocationProviderClient = fusedLocationProviderClient.doRead(zzba2.setFeatures(featureArray).setMethodKey(2415).build());
        if (object != null) {
            zzba2 = new TaskCompletionSource(object);
            object = new zzac((TaskCompletionSource)zzba2);
            fusedLocationProviderClient.continueWithTask((Continuation)object);
            return zzba2.getTask();
        }
        return fusedLocationProviderClient;
    }

    @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    @RecentlyNonNull
    public Task<LocationAvailability> getLocationAvailability() {
        return this.doRead(TaskApiCall.builder().run(zzad.zza).setMethodKey(2416).build());
    }

    @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    @RecentlyNonNull
    public Task<Void> requestLocationUpdates(@RecentlyNonNull LocationRequest locationRequest, @RecentlyNonNull LocationCallback locationCallback, @RecentlyNonNull Looper looper) {
        return this.zze(zzba.zza(null, locationRequest), locationCallback, looper, null, 2436);
    }

    @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    @RecentlyNonNull
    public Task<Void> requestLocationUpdates(@RecentlyNonNull LocationRequest abstractSafeParcelable, @RecentlyNonNull PendingIntent pendingIntent) {
        abstractSafeParcelable = zzba.zza(null, (LocationRequest)abstractSafeParcelable);
        TaskApiCall.Builder builder = TaskApiCall.builder();
        zzaf zzaf2 = new zzaf(this, (zzba)abstractSafeParcelable, pendingIntent);
        return this.doWrite(builder.run((RemoteCall)zzaf2).setMethodKey(2417).build());
    }

    @RecentlyNonNull
    public Task<Void> removeLocationUpdates(@RecentlyNonNull LocationCallback locationCallback) {
        return TaskUtil.toVoidTaskThatFailsOnFalse((Task)this.doUnregisterEventListener(ListenerHolders.createListenerKey((Object)locationCallback, (String)LocationCallback.class.getSimpleName())));
    }

    @RecentlyNonNull
    public Task<Void> removeLocationUpdates(@RecentlyNonNull PendingIntent pendingIntent) {
        TaskApiCall.Builder builder = TaskApiCall.builder();
        zzag zzag2 = new zzag(pendingIntent);
        return this.doWrite(builder.run((RemoteCall)zzag2).setMethodKey(2418).build());
    }

    @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    @RecentlyNonNull
    public Task<Void> setMockMode(boolean bl) {
        TaskApiCall.Builder builder = TaskApiCall.builder();
        zzah zzah2 = new zzah(bl);
        return this.doWrite(builder.run((RemoteCall)zzah2).setMethodKey(2420).build());
    }

    @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    @RecentlyNonNull
    public Task<Void> setMockLocation(@RecentlyNonNull Location location) {
        TaskApiCall.Builder builder = TaskApiCall.builder();
        zzai zzai2 = new zzai(location);
        return this.doWrite(builder.run((RemoteCall)zzai2).setMethodKey(2421).build());
    }

    @RecentlyNonNull
    public Task<Void> flushLocations() {
        return this.doWrite(TaskApiCall.builder().run(zzw.zza).setMethodKey(2422).build());
    }

    private final Task<Void> zze(zzba zzba2, LocationCallback locationCallback, Looper looper, zzan zzan2, int n) {
        looper = ListenerHolders.createListenerHolder((Object)locationCallback, (Looper)zzbj.zza(looper), (String)LocationCallback.class.getSimpleName());
        zzak zzak2 = new zzak(this, (ListenerHolder)looper);
        zzae zzae2 = new zzae(this, zzak2, locationCallback, zzan2, zzba2, (ListenerHolder)looper);
        return this.doRegisterEventListener(RegistrationMethods.builder().register((RemoteCall)zzae2).unregister((RemoteCall)zzak2).withHolder((ListenerHolder)looper).setMethodKey(n).build());
    }

    final /* synthetic */ void zza(zzba zzba2, PendingIntent pendingIntent, zzaz zzaz2, TaskCompletionSource taskCompletionSource) throws RemoteException {
        zzao zzao2 = new zzao((TaskCompletionSource<Void>)taskCompletionSource);
        zzba2.zzc(this.getContextAttributionTag());
        zzaz2.zzD(zzba2, pendingIntent, zzao2);
    }

    final /* synthetic */ void zzb(zzap zzap2, LocationCallback locationCallback, zzan zzan2, zzba zzba2, ListenerHolder listenerHolder, zzaz zzaz2, TaskCompletionSource taskCompletionSource) throws RemoteException {
        zzx zzx2 = new zzx(this, zzap2, locationCallback, zzan2);
        zzam zzam2 = new zzam((TaskCompletionSource<Void>)taskCompletionSource, zzx2);
        zzba2.zzc(this.getContextAttributionTag());
        zzaz2.zzB(zzba2, (ListenerHolder<LocationCallback>)listenerHolder, zzam2);
    }

    final /* synthetic */ void zzc(CancellationToken object, zzba zzba2, zzaz object2, TaskCompletionSource taskCompletionSource) throws RemoteException {
        Object object3;
        object2 = new zzaj((FusedLocationProviderClient)task, taskCompletionSource);
        if (object != null) {
            object3 = new zzy((FusedLocationProviderClient)task, (LocationCallback)object2);
            object.onCanceledRequested((OnTokenCanceledListener)object3);
        }
        object = Looper.getMainLooper();
        object3 = new zzz(taskCompletionSource);
        Task<Void> task = task.zze(zzba2, (LocationCallback)object2, (Looper)object, (zzan)object3, 2437);
        object = new zzaa(taskCompletionSource);
        task.continueWithTask((Continuation)object);
    }

    final /* synthetic */ void zzd(zzaz zzaz2, TaskCompletionSource taskCompletionSource) throws RemoteException {
        taskCompletionSource.setResult((Object)zzaz2.zzz(this.getContextAttributionTag()));
    }
}

