/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.location.ActivityTransition;
import com.google.android.gms.location.zzm;

@SafeParcelable.Reserved(value={1000})
@SafeParcelable.Class(creator="ActivityTransitionEventCreator")
public class ActivityTransitionEvent
extends AbstractSafeParcelable {
    @RecentlyNonNull
    public static final Parcelable.Creator<ActivityTransitionEvent> CREATOR;
    @SafeParcelable.Field(id=1, getter="getActivityType")
    private final int zza;
    @SafeParcelable.Field(id=2, getter="getTransitionType")
    private final int zzb;
    @SafeParcelable.Field(id=3, getter="getElapsedRealTimeNanos")
    private final long zzc;

    @SafeParcelable.Constructor
    public ActivityTransitionEvent(@SafeParcelable.Param(id=1) int n, @SafeParcelable.Param(id=2) int n2, @SafeParcelable.Param(id=3) long l) {
        ActivityTransition.zza(n2);
        this.zza = n;
        this.zzb = n2;
        this.zzc = l;
    }

    public int getActivityType() {
        return this.zza;
    }

    public int getTransitionType() {
        return this.zzb;
    }

    public long getElapsedRealTimeNanos() {
        return this.zzc;
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.zza, this.zzb, this.zzc};
        return Objects.hashCode((Object[])objectArray);
    }

    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ActivityTransitionEvent)) {
            return false;
        }
        object = (ActivityTransitionEvent)((Object)object);
        return this.zza == ((ActivityTransitionEvent)((Object)object)).zza && this.zzb == ((ActivityTransitionEvent)((Object)object)).zzb && this.zzc == ((ActivityTransitionEvent)((Object)object)).zzc;
    }

    @RecentlyNonNull
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = ((ActivityTransitionEvent)((Object)object)).zza;
        StringBuilder stringBuilder2 = new StringBuilder(24);
        stringBuilder2.append("ActivityType ");
        stringBuilder2.append(n);
        stringBuilder.append(stringBuilder2.toString());
        stringBuilder.append(" ");
        n = ((ActivityTransitionEvent)((Object)object)).zzb;
        stringBuilder2 = new StringBuilder(26);
        stringBuilder2.append("TransitionType ");
        stringBuilder2.append(n);
        stringBuilder.append(stringBuilder2.toString());
        stringBuilder.append(" ");
        long l = ((ActivityTransitionEvent)((Object)object)).zzc;
        Object object = new StringBuilder(41);
        ((StringBuilder)object).append("ElapsedRealTimeNanos ");
        ((StringBuilder)object).append(l);
        stringBuilder.append(((StringBuilder)object).toString());
        return stringBuilder.toString();
    }

    public void writeToParcel(@RecentlyNonNull Parcel parcel, int n) {
        Preconditions.checkNotNull((Object)parcel);
        n = SafeParcelWriter.beginObjectHeader((Parcel)parcel);
        SafeParcelWriter.writeInt((Parcel)parcel, (int)1, (int)this.getActivityType());
        SafeParcelWriter.writeInt((Parcel)parcel, (int)2, (int)this.getTransitionType());
        SafeParcelWriter.writeLong((Parcel)parcel, (int)3, (long)this.getElapsedRealTimeNanos());
        SafeParcelWriter.finishObjectHeader((Parcel)parcel, (int)n);
    }

    static {
        zzm zzm2;
        CREATOR = zzm2 = new zzm();
    }
}

