/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.location;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.location.zzbf;
import com.google.android.gms.location.Geofence;
import java.util.Locale;

@SafeParcelable.Reserved(value={1000})
@SafeParcelable.Class(creator="ParcelableGeofenceCreator")
@VisibleForTesting
public final class zzbe
extends AbstractSafeParcelable
implements Geofence {
    @SafeParcelable.Field(id=1, getter="getRequestId")
    private final String zza;
    @SafeParcelable.Field(id=2, getter="getExpirationTime")
    private final long zzb;
    @SafeParcelable.Field(id=3, getter="getType")
    private final short zzc;
    @SafeParcelable.Field(id=4, getter="getLatitude")
    private final double zzd;
    @SafeParcelable.Field(id=5, getter="getLongitude")
    private final double zze;
    @SafeParcelable.Field(id=6, getter="getRadius")
    private final float zzf;
    @SafeParcelable.Field(id=7, getter="getTransitionTypes")
    private final int zzg;
    @SafeParcelable.Field(id=8, getter="getNotificationResponsiveness", defaultValue="0")
    private final int zzh;
    @SafeParcelable.Field(id=9, getter="getLoiteringDelay", defaultValue="-1")
    private final int zzi;
    public static final Parcelable.Creator<zzbe> CREATOR;

    /*
     * Enabled aggressive block sorting
     */
    @SafeParcelable.Constructor
    public zzbe(@SafeParcelable.Param(id=1) String charSequence, @SafeParcelable.Param(id=7) int n, @SafeParcelable.Param(id=3) short s, @SafeParcelable.Param(id=4) double d, @SafeParcelable.Param(id=5) double d2, @SafeParcelable.Param(id=6) float f, @SafeParcelable.Param(id=2) long l, @SafeParcelable.Param(id=8) int n2, @SafeParcelable.Param(id=9) int n3) {
        Object object;
        if (charSequence == null || ((String)charSequence).length() > 100) {
            object = String.valueOf(charSequence);
            charSequence = "requestId is null or too long: ";
            object = ((String)object).length() != 0 ? ((String)charSequence).concat((String)object) : new String((String)charSequence);
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException((String)object);
            throw illegalArgumentException;
        }
        if (f <= 0.0f) {
            super(31);
            ((StringBuilder)charSequence).append("invalid radius: ");
            ((StringBuilder)charSequence).append(f);
            object = new IllegalArgumentException(((StringBuilder)charSequence).toString());
            throw object;
        }
        if (d > 90.0 || d < -90.0) {
            super(42);
            ((StringBuilder)charSequence).append("invalid latitude: ");
            ((StringBuilder)charSequence).append(d);
            object = new IllegalArgumentException(((StringBuilder)charSequence).toString());
            throw object;
        }
        if (d2 > 180.0 || d2 < -180.0) {
            super(43);
            ((StringBuilder)charSequence).append("invalid longitude: ");
            ((StringBuilder)charSequence).append(d2);
            object = new IllegalArgumentException(((StringBuilder)charSequence).toString());
            throw object;
        }
        int n4 = n & 7;
        if (n4 == 0) {
            super(46);
            ((StringBuilder)charSequence).append("No supported transition specified: ");
            ((StringBuilder)charSequence).append(n);
            object = new IllegalArgumentException(((StringBuilder)charSequence).toString());
            throw object;
        }
        ((zzbe)object).zzc = s;
        ((zzbe)object).zza = charSequence;
        ((zzbe)object).zzd = d;
        ((zzbe)object).zze = d2;
        ((zzbe)object).zzf = f;
        ((zzbe)object).zzb = l;
        ((zzbe)object).zzg = n4;
        ((zzbe)object).zzh = n2;
        ((zzbe)object).zzi = n3;
    }

    @Override
    public final String getRequestId() {
        return this.zza;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        n = SafeParcelWriter.beginObjectHeader((Parcel)parcel);
        SafeParcelWriter.writeString((Parcel)parcel, (int)1, (String)this.zza, (boolean)false);
        SafeParcelWriter.writeLong((Parcel)parcel, (int)2, (long)this.zzb);
        SafeParcelWriter.writeShort((Parcel)parcel, (int)3, (short)this.zzc);
        SafeParcelWriter.writeDouble((Parcel)parcel, (int)4, (double)this.zzd);
        SafeParcelWriter.writeDouble((Parcel)parcel, (int)5, (double)this.zze);
        SafeParcelWriter.writeFloat((Parcel)parcel, (int)6, (float)this.zzf);
        SafeParcelWriter.writeInt((Parcel)parcel, (int)7, (int)this.zzg);
        SafeParcelWriter.writeInt((Parcel)parcel, (int)8, (int)this.zzh);
        SafeParcelWriter.writeInt((Parcel)parcel, (int)9, (int)this.zzi);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel, (int)n);
    }

    /*
     * Enabled aggressive block sorting
     */
    public final String toString() {
        String string;
        Locale locale = Locale.US;
        Object[] objectArray = new Object[9];
        switch (this.zzc) {
            default: {
                string = "UNKNOWN";
                break;
            }
            case 1: {
                string = "CIRCLE";
                break;
            }
            case -1: {
                string = "INVALID";
            }
        }
        objectArray[0] = string;
        objectArray[1] = this.zza.replaceAll("\\p{C}", "?");
        objectArray[2] = this.zzg;
        objectArray[3] = this.zzd;
        objectArray[4] = this.zze;
        objectArray[5] = Float.valueOf(this.zzf);
        objectArray[6] = this.zzh / 1000;
        objectArray[7] = this.zzi;
        objectArray[8] = this.zzb;
        return String.format(locale, "Geofence[%s id:%s transitions:%d %.6f, %.6f %.0fm, resp=%ds, dwell=%dms, @%d]", objectArray);
    }

    public final int hashCode() {
        long l = Double.doubleToLongBits(this.zzd);
        long l2 = Double.doubleToLongBits(this.zze);
        return (((((int)(l ^ l >>> 32) + 31) * 31 + (int)(l2 ^ l2 >>> 32)) * 31 + Float.floatToIntBits(this.zzf)) * 31 + this.zzc) * 31 + this.zzg;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof zzbe) {
            object = (zzbe)object;
            return this.zzf == ((zzbe)object).zzf && this.zzd == ((zzbe)object).zzd && this.zze == ((zzbe)object).zze && this.zzc == ((zzbe)object).zzc;
        }
        return false;
    }

    static {
        zzbf zzbf2;
        CREATOR = zzbf2 = new zzbf();
    }
}

