/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.location.zzau;
import com.google.android.gms.location.zzbd;
import java.util.Arrays;

@SafeParcelable.Reserved(value={1000})
@SafeParcelable.Class(creator="LocationAvailabilityCreator")
public final class LocationAvailability
extends AbstractSafeParcelable
implements ReflectedParcelable {
    @Deprecated
    @SafeParcelable.Field(id=1, defaultValueUnchecked="LocationAvailability.STATUS_UNKNOWN")
    private int zza;
    @Deprecated
    @SafeParcelable.Field(id=2, defaultValueUnchecked="LocationAvailability.STATUS_UNKNOWN")
    private int zzb;
    @SafeParcelable.Field(id=3, defaultValueUnchecked="0")
    private long zzc;
    @SafeParcelable.Field(id=4, defaultValueUnchecked="LocationAvailability.STATUS_UNSUCCESSFUL")
    private int zzd;
    @SafeParcelable.Field(id=5)
    private zzbd[] zze;
    public static final Parcelable.Creator<LocationAvailability> CREATOR = new zzau();

    @SafeParcelable.Constructor
    LocationAvailability(@SafeParcelable.Param(id=4) int n, @SafeParcelable.Param(id=1) int n2, @SafeParcelable.Param(id=2) int n3, @SafeParcelable.Param(id=3) long l, @SafeParcelable.Param(id=5) zzbd[] zzbdArray) {
        this.zzd = n;
        this.zza = n2;
        this.zzb = n3;
        this.zzc = l;
        this.zze = zzbdArray;
    }

    public final boolean isLocationAvailable() {
        return this.zzd < 1000;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        LocationAvailability locationAvailability = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)1, (int)locationAvailability.zza);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)2, (int)locationAvailability.zzb);
        SafeParcelWriter.writeLong((Parcel)parcel2, (int)3, (long)locationAvailability.zzc);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)4, (int)locationAvailability.zzd);
        SafeParcelWriter.writeTypedArray((Parcel)parcel2, (int)5, (Parcelable[])locationAvailability.zze, (int)n, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    public final int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.zzd, this.zza, this.zzb, this.zzc, this.zze});
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || ((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        LocationAvailability locationAvailability = (LocationAvailability)((Object)object);
        return this.zza == locationAvailability.zza && this.zzb == locationAvailability.zzb && this.zzc == locationAvailability.zzc && this.zzd == locationAvailability.zzd && Arrays.equals((Object[])this.zze, (Object[])locationAvailability.zze);
    }

    public final String toString() {
        boolean bl = this.isLocationAvailable();
        return new StringBuilder(48).append("LocationAvailability[isLocationAvailable: ").append(bl).append("]").toString();
    }

    public static boolean hasLocationAvailability(Intent intent) {
        if (intent == null) {
            return false;
        }
        return intent.hasExtra("com.google.android.gms.location.EXTRA_LOCATION_AVAILABILITY");
    }

    @Nullable
    public static LocationAvailability extractLocationAvailability(Intent intent) {
        if (!LocationAvailability.hasLocationAvailability(intent)) {
            return null;
        }
        try {
            return (LocationAvailability)intent.getExtras().getParcelable("com.google.android.gms.location.EXTRA_LOCATION_AVAILABILITY");
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }
}

