/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresPermission;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.ApiException;
import com.google.android.gms.common.api.GoogleApi;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.BaseImplementation;
import com.google.android.gms.common.api.internal.RemoteCall;
import com.google.android.gms.common.api.internal.TaskApiCall;
import com.google.android.gms.common.api.internal.TaskUtil;
import com.google.android.gms.location.ActivityTransitionRequest;
import com.google.android.gms.location.LocationServices;
import com.google.android.gms.location.zzb;
import com.google.android.gms.location.zzc;
import com.google.android.gms.location.zzd;
import com.google.android.gms.location.zze;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;

public class ActivityRecognitionClient
extends GoogleApi<Api.ApiOptions.NoOptions> {
    public ActivityRecognitionClient(@NonNull Context context) {
        super(context, LocationServices.API, null, GoogleApi.Settings.DEFAULT_SETTINGS);
    }

    public ActivityRecognitionClient(@NonNull Activity activity) {
        super(activity, LocationServices.API, null, GoogleApi.Settings.DEFAULT_SETTINGS);
    }

    @RequiresPermission(value="com.google.android.gms.permission.ACTIVITY_RECOGNITION")
    public Task<Void> requestActivityUpdates(long l, PendingIntent pendingIntent) {
        return this.doWrite(TaskApiCall.builder().run((RemoteCall)new zzb(l, pendingIntent)).build());
    }

    @RequiresPermission(value="com.google.android.gms.permission.ACTIVITY_RECOGNITION")
    public Task<Void> removeActivityUpdates(PendingIntent pendingIntent) {
        return this.doWrite(TaskApiCall.builder().run((RemoteCall)new zzd(pendingIntent)).build());
    }

    @RequiresPermission(value="com.google.android.gms.permission.ACTIVITY_RECOGNITION")
    public Task<Void> requestActivityTransitionUpdates(ActivityTransitionRequest activityTransitionRequest, PendingIntent pendingIntent) {
        return this.doWrite(TaskApiCall.builder().run((RemoteCall)new zzc(activityTransitionRequest, pendingIntent)).build());
    }

    @RequiresPermission(value="com.google.android.gms.permission.ACTIVITY_RECOGNITION")
    public Task<Void> removeActivityTransitionUpdates(PendingIntent pendingIntent) {
        return this.doWrite(TaskApiCall.builder().run((RemoteCall)new zze(pendingIntent)).build());
    }

    private static final class zza
    implements BaseImplementation.ResultHolder<Status> {
        private final TaskCompletionSource<Void> zza;

        public zza(TaskCompletionSource<Void> taskCompletionSource) {
            this.zza = taskCompletionSource;
        }

        public final void setFailedResult(Status status) {
            this.zza.setException((Exception)new ApiException(status));
        }

        public final /* synthetic */ void setResult(Object object) {
            Status status = (Status)object;
            zza zza2 = this;
            TaskUtil.setResultOrApiException((Status)status, null, zza2.zza);
        }
    }
}

