/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.location;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.location.zzbf;
import com.google.android.gms.location.Geofence;
import java.util.Locale;

@SafeParcelable.Reserved(value={1000})
@SafeParcelable.Class(creator="ParcelableGeofenceCreator")
@VisibleForTesting
public final class zzbg
extends AbstractSafeParcelable
implements Geofence {
    @SafeParcelable.Field(id=1, getter="getRequestId")
    private final String zza;
    @SafeParcelable.Field(id=2, getter="getExpirationTime")
    private final long zzb;
    @SafeParcelable.Field(id=3, getter="getType")
    private final short zzc;
    @SafeParcelable.Field(id=4, getter="getLatitude")
    private final double zzd;
    @SafeParcelable.Field(id=5, getter="getLongitude")
    private final double zze;
    @SafeParcelable.Field(id=6, getter="getRadius")
    private final float zzf;
    @SafeParcelable.Field(id=7, getter="getTransitionTypes")
    private final int zzg;
    @SafeParcelable.Field(id=8, getter="getNotificationResponsiveness", defaultValue="0")
    private final int zzh;
    @SafeParcelable.Field(id=9, getter="getLoiteringDelay", defaultValue="-1")
    private final int zzi;
    public static final Parcelable.Creator<zzbg> CREATOR = new zzbf();

    @SafeParcelable.Constructor
    public zzbg(@SafeParcelable.Param(id=1) String string, @SafeParcelable.Param(id=7) int n, @SafeParcelable.Param(id=3) short s, @SafeParcelable.Param(id=4) double d, @SafeParcelable.Param(id=5) double d2, @SafeParcelable.Param(id=6) float f, @SafeParcelable.Param(id=2) long l, @SafeParcelable.Param(id=8) int n2, @SafeParcelable.Param(id=9) int n3) {
        float f2;
        String string2 = string;
        if (string2 == null || string2.length() > 100) {
            String string3 = String.valueOf(string2);
            throw new IllegalArgumentException(string3.length() != 0 ? "requestId is null or too long: ".concat(string3) : new String("requestId is null or too long: "));
        }
        float f3 = f;
        if (f2 <= 0.0f) {
            throw new IllegalArgumentException(new StringBuilder(31).append("invalid radius: ").append(f3).toString());
        }
        double d3 = d2;
        double d4 = d;
        if (d4 > 90.0 || d4 < -90.0) {
            throw new IllegalArgumentException(new StringBuilder(42).append("invalid latitude: ").append(d4).toString());
        }
        if (d3 > 180.0 || d3 < -180.0) {
            throw new IllegalArgumentException(new StringBuilder(43).append("invalid longitude: ").append(d3).toString());
        }
        int n4 = n;
        int n5 = n4 & 7;
        if (n5 == 0) {
            throw new IllegalArgumentException(new StringBuilder(46).append("No supported transition specified: ").append(n4).toString());
        }
        n = n5;
        this.zzc = s;
        this.zza = string;
        this.zzd = d;
        this.zze = d2;
        this.zzf = f;
        this.zzb = l;
        this.zzg = n;
        this.zzh = n2;
        this.zzi = n3;
    }

    @Override
    public final String getRequestId() {
        return this.zza;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        zzbg zzbg2 = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)1, (String)zzbg2.getRequestId(), (boolean)false);
        SafeParcelWriter.writeLong((Parcel)parcel2, (int)2, (long)zzbg2.zzb);
        SafeParcelWriter.writeShort((Parcel)parcel2, (int)3, (short)zzbg2.zzc);
        SafeParcelWriter.writeDouble((Parcel)parcel2, (int)4, (double)zzbg2.zzd);
        SafeParcelWriter.writeDouble((Parcel)parcel2, (int)5, (double)zzbg2.zze);
        SafeParcelWriter.writeFloat((Parcel)parcel2, (int)6, (float)zzbg2.zzf);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)7, (int)zzbg2.zzg);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)8, (int)zzbg2.zzh);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)9, (int)zzbg2.zzi);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    public static zzbg zza(byte[] byArray) {
        Parcel parcel = Parcel.obtain();
        parcel.unmarshall(byArray, 0, byArray.length);
        parcel.setDataPosition(0);
        zzbg zzbg2 = (zzbg)CREATOR.createFromParcel(parcel);
        parcel.recycle();
        return zzbg2;
    }

    public final String toString() {
        String string;
        Object[] objectArray = new Object[9];
        switch (this.zzc) {
            case 1: {
                string = "CIRCLE";
                break;
            }
            default: {
                string = null;
            }
        }
        objectArray[0] = string;
        objectArray[1] = this.zza.replaceAll("\\p{C}", "?");
        objectArray[2] = this.zzg;
        objectArray[3] = this.zzd;
        objectArray[4] = this.zze;
        objectArray[5] = Float.valueOf(this.zzf);
        objectArray[6] = this.zzh / 1000;
        objectArray[7] = this.zzi;
        objectArray[8] = this.zzb;
        return String.format(Locale.US, "Geofence[%s id:%s transitions:%d %.6f, %.6f %.0fm, resp=%ds, dwell=%dms, @%d]", objectArray);
    }

    public final int hashCode() {
        long l = Double.doubleToLongBits(this.zzd);
        int n = 31 + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.zze);
        return (((n * 31 + (int)(l ^ l >>> 32)) * 31 + Float.floatToIntBits(this.zzf)) * 31 + this.zzc) * 31 + this.zzg;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof zzbg)) {
            return false;
        }
        zzbg zzbg2 = (zzbg)object;
        if (this.zzf != zzbg2.zzf) {
            return false;
        }
        if (this.zzd != zzbg2.zzd) {
            return false;
        }
        if (this.zze != zzbg2.zze) {
            return false;
        }
        return this.zzc == zzbg2.zzc;
    }
}

