/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.location;

import android.app.PendingIntent;
import android.content.Context;
import android.location.Location;
import android.os.Looper;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.BaseImplementation;
import com.google.android.gms.common.api.internal.IStatusCallback;
import com.google.android.gms.common.api.internal.ListenerHolder;
import com.google.android.gms.common.api.internal.StatusCallback;
import com.google.android.gms.common.internal.ClientSettings;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.ArrayUtils;
import com.google.android.gms.internal.location.zzai;
import com.google.android.gms.internal.location.zzaj;
import com.google.android.gms.internal.location.zzal;
import com.google.android.gms.internal.location.zzap;
import com.google.android.gms.internal.location.zzax;
import com.google.android.gms.internal.location.zzaz;
import com.google.android.gms.internal.location.zzba;
import com.google.android.gms.internal.location.zzbc;
import com.google.android.gms.internal.location.zzh;
import com.google.android.gms.location.ActivityTransitionRequest;
import com.google.android.gms.location.GeofencingRequest;
import com.google.android.gms.location.LocationAvailability;
import com.google.android.gms.location.LocationCallback;
import com.google.android.gms.location.LocationListener;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationSettingsRequest;
import com.google.android.gms.location.LocationSettingsResult;
import com.google.android.gms.location.zzbe;
import com.google.android.gms.location.zzp;
import java.util.List;
import javax.annotation.Nullable;

public final class zzay
extends zzh {
    private final zzap zze;

    public zzay(Context context, Looper looper, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, String string) {
        this(context, looper, connectionCallbacks, onConnectionFailedListener, string, ClientSettings.createDefault((Context)context));
    }

    public zzay(Context context, Looper looper, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, String string, @Nullable ClientSettings clientSettings) {
        super(context, looper, connectionCallbacks, onConnectionFailedListener, string, clientSettings);
        this.zze = new zzap(context, this.zzd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void disconnect() {
        zzap zzap2 = this.zze;
        synchronized (zzap2) {
            if (this.isConnected()) {
                try {
                    this.zze.zzc();
                    this.zze.zzd();
                }
                catch (Exception exception) {
                    Log.e((String)"LocationClientImpl", (String)"Client disconnected before listeners could be cleaned up", (Throwable)exception);
                }
            }
            super.disconnect();
            return;
        }
    }

    public final void zza(long l, PendingIntent pendingIntent) throws RemoteException {
        this.checkConnected();
        Preconditions.checkNotNull((Object)pendingIntent);
        Preconditions.checkArgument((l >= 0L ? 1 : 0) != 0, (Object)"detectionIntervalMillis must be >= 0");
        ((zzal)this.getService()).zza(l, true, pendingIntent);
    }

    public final void zza(ActivityTransitionRequest activityTransitionRequest, PendingIntent pendingIntent, BaseImplementation.ResultHolder<Status> resultHolder) throws RemoteException {
        this.checkConnected();
        Preconditions.checkNotNull(resultHolder, (Object)"ResultHolder not provided.");
        StatusCallback statusCallback = new StatusCallback(resultHolder);
        ((zzal)this.getService()).zza(activityTransitionRequest, pendingIntent, (IStatusCallback)statusCallback);
    }

    public final void zza(PendingIntent pendingIntent, BaseImplementation.ResultHolder<Status> resultHolder) throws RemoteException {
        this.checkConnected();
        Preconditions.checkNotNull(resultHolder, (Object)"ResultHolder not provided.");
        StatusCallback statusCallback = new StatusCallback(resultHolder);
        ((zzal)this.getService()).zza(pendingIntent, (IStatusCallback)statusCallback);
    }

    public final void zza(PendingIntent pendingIntent) throws RemoteException {
        this.checkConnected();
        Preconditions.checkNotNull((Object)pendingIntent);
        ((zzal)this.getService()).zza(pendingIntent);
    }

    public final void zza(GeofencingRequest geofencingRequest, PendingIntent pendingIntent, BaseImplementation.ResultHolder<Status> resultHolder) throws RemoteException {
        this.checkConnected();
        Preconditions.checkNotNull((Object)((Object)geofencingRequest), (Object)"geofencingRequest can't be null.");
        Preconditions.checkNotNull((Object)pendingIntent, (Object)"PendingIntent must be specified.");
        Preconditions.checkNotNull(resultHolder, (Object)"ResultHolder not provided.");
        zzax zzax2 = new zzax(resultHolder);
        ((zzal)this.getService()).zza(geofencingRequest, pendingIntent, zzax2);
    }

    public final void zza(zzbe zzbe2, BaseImplementation.ResultHolder<Status> resultHolder) throws RemoteException {
        this.checkConnected();
        Preconditions.checkNotNull((Object)((Object)zzbe2), (Object)"removeGeofencingRequest can't be null.");
        Preconditions.checkNotNull(resultHolder, (Object)"ResultHolder not provided.");
        zzba zzba2 = new zzba(resultHolder);
        ((zzal)this.getService()).zza(zzbe2, zzba2);
    }

    public final void zzb(PendingIntent pendingIntent, BaseImplementation.ResultHolder<Status> resultHolder) throws RemoteException {
        this.checkConnected();
        Preconditions.checkNotNull((Object)pendingIntent, (Object)"PendingIntent must be specified.");
        Preconditions.checkNotNull(resultHolder, (Object)"ResultHolder not provided.");
        zzba zzba2 = new zzba(resultHolder);
        ((zzal)this.getService()).zza(pendingIntent, (zzaj)zzba2, this.getContext().getPackageName());
    }

    public final void zza(List<String> list, BaseImplementation.ResultHolder<Status> resultHolder) throws RemoteException {
        this.checkConnected();
        Preconditions.checkArgument((list != null && list.size() > 0 ? 1 : 0) != 0, (Object)"geofenceRequestIds can't be null nor empty.");
        Preconditions.checkNotNull(resultHolder, (Object)"ResultHolder not provided.");
        String[] stringArray = list.toArray(new String[0]);
        zzba zzba2 = new zzba(resultHolder);
        ((zzal)this.getService()).zza(stringArray, (zzaj)zzba2, this.getContext().getPackageName());
    }

    public final Location zza(String string) throws RemoteException {
        if (ArrayUtils.contains((Object[])this.getAvailableFeatures(), (Object)zzp.zza)) {
            return this.zze.zza(string);
        }
        return this.zze.zza();
    }

    public final LocationAvailability zza() throws RemoteException {
        return this.zze.zzb();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(zzbc zzbc2, ListenerHolder<LocationCallback> listenerHolder, zzai zzai2) throws RemoteException {
        zzap zzap2 = this.zze;
        synchronized (zzap2) {
            this.zze.zza(zzbc2, listenerHolder, zzai2);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(LocationRequest locationRequest, ListenerHolder<LocationListener> listenerHolder, zzai zzai2) throws RemoteException {
        zzap zzap2 = this.zze;
        synchronized (zzap2) {
            this.zze.zza(locationRequest, listenerHolder, zzai2);
            return;
        }
    }

    public final void zza(zzbc zzbc2, PendingIntent pendingIntent, zzai zzai2) throws RemoteException {
        this.zze.zza(zzbc2, pendingIntent, zzai2);
    }

    public final void zza(LocationRequest locationRequest, PendingIntent pendingIntent, zzai zzai2) throws RemoteException {
        this.zze.zza(locationRequest, pendingIntent, zzai2);
    }

    public final void zza(ListenerHolder.ListenerKey<LocationListener> listenerKey, zzai zzai2) throws RemoteException {
        this.zze.zza(listenerKey, zzai2);
    }

    public final void zza(PendingIntent pendingIntent, zzai zzai2) throws RemoteException {
        this.zze.zza(pendingIntent, zzai2);
    }

    public final void zzb(ListenerHolder.ListenerKey<LocationCallback> listenerKey, zzai zzai2) throws RemoteException {
        this.zze.zzb(listenerKey, zzai2);
    }

    public final void zza(boolean bl) throws RemoteException {
        this.zze.zza(bl);
    }

    public final void zza(Location location) throws RemoteException {
        this.zze.zza(location);
    }

    public final void zza(zzai zzai2) throws RemoteException {
        this.zze.zza(zzai2);
    }

    public final void zza(LocationSettingsRequest locationSettingsRequest, BaseImplementation.ResultHolder<LocationSettingsResult> resultHolder, @Nullable String string) throws RemoteException {
        this.checkConnected();
        Preconditions.checkArgument((locationSettingsRequest != null ? 1 : 0) != 0, (Object)"locationSettingsRequest can't be null nor empty.");
        Preconditions.checkArgument((resultHolder != null ? 1 : 0) != 0, (Object)"listener can't be null.");
        zzaz zzaz2 = new zzaz(resultHolder);
        ((zzal)this.getService()).zza(locationSettingsRequest, zzaz2, string);
    }
}

