/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.location.zzh;
import com.google.android.gms.location.zzi;
import java.util.Comparator;

@SafeParcelable.Reserved(value={1000})
@SafeParcelable.Class(creator="DetectedActivityCreator")
public class DetectedActivity
extends AbstractSafeParcelable {
    private static final Comparator<DetectedActivity> zzo = new zzh();
    public static final int IN_VEHICLE = 0;
    public static final int ON_BICYCLE = 1;
    public static final int ON_FOOT = 2;
    public static final int STILL = 3;
    public static final int UNKNOWN = 4;
    public static final int TILTING = 5;
    public static final int WALKING = 7;
    public static final int RUNNING = 8;
    private static final int[] zzp = new int[]{9, 10};
    private static final int[] zzq = new int[]{0, 1, 2, 4, 5, 6, 7, 8, 10, 11, 12, 13, 14, 16, 17, 18, 19};
    private static final int[] zzr = new int[]{0, 1, 2, 3, 7, 8, 16, 17};
    public static final Parcelable.Creator<DetectedActivity> CREATOR = new zzi();
    @SafeParcelable.Field(id=1)
    private int zzi;
    @SafeParcelable.Field(id=2)
    private int zzs;

    public static void zzb(int n) {
        int n2 = n;
        boolean bl = false;
        int[] nArray = zzr;
        int n3 = zzr.length;
        for (int i = 0; i < n3; ++i) {
            if (nArray[i] != n2) continue;
            bl = true;
        }
        if (!bl) {
            Log.w((String)"DetectedActivity", (String)new StringBuilder(81).append(n).append(" is not a valid DetectedActivity supported by Activity Transition API.").toString());
        }
    }

    public int getType() {
        int n = this.zzi;
        if (n > 19 || n < 0) {
            return 4;
        }
        return n;
    }

    public int getConfidence() {
        return this.zzs;
    }

    @SafeParcelable.Constructor
    public DetectedActivity(@SafeParcelable.Param(id=1) int n, @SafeParcelable.Param(id=2) int n2) {
        this.zzi = n;
        this.zzs = n2;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        DetectedActivity detectedActivity = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)1, (int)detectedActivity.zzi);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)2, (int)detectedActivity.zzs);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || ((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        DetectedActivity detectedActivity = (DetectedActivity)((Object)object);
        return this.zzi == detectedActivity.zzi && this.zzs == detectedActivity.zzs;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.zzi, this.zzs});
    }

    public String toString() {
        String string;
        int n = this.getType();
        switch (n) {
            case 0: {
                string = "IN_VEHICLE";
                break;
            }
            case 1: {
                string = "ON_BICYCLE";
                break;
            }
            case 2: {
                string = "ON_FOOT";
                break;
            }
            case 3: {
                string = "STILL";
                break;
            }
            case 4: {
                string = "UNKNOWN";
                break;
            }
            case 5: {
                string = "TILTING";
                break;
            }
            case 7: {
                string = "WALKING";
                break;
            }
            case 8: {
                string = "RUNNING";
                break;
            }
            case 16: {
                string = "IN_ROAD_VEHICLE";
                break;
            }
            case 17: {
                string = "IN_RAIL_VEHICLE";
                break;
            }
            case 18: {
                string = "IN_TWO_WHEELER_VEHICLE";
                break;
            }
            case 19: {
                string = "IN_FOUR_WHEELER_VEHICLE";
                break;
            }
            default: {
                string = Integer.toString(n);
            }
        }
        String string2 = string;
        int n2 = this.zzs;
        return new StringBuilder(48 + String.valueOf(string2).length()).append("DetectedActivity [type=").append(string2).append(", confidence=").append(n2).append("]").toString();
    }
}

