/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.location;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.location.zzbi;
import com.google.android.gms.location.Geofence;
import java.util.Locale;

@SafeParcelable.Reserved(value={1000})
@SafeParcelable.Class(creator="ParcelableGeofenceCreator")
@VisibleForTesting
public final class zzbh
extends AbstractSafeParcelable
implements Geofence {
    @SafeParcelable.Field(id=1, getter="getRequestId")
    private final String zzad;
    @SafeParcelable.Field(id=2, getter="getExpirationTime")
    private final long zzdo;
    @SafeParcelable.Field(id=3, getter="getType")
    private final short zzag;
    @SafeParcelable.Field(id=4, getter="getLatitude")
    private final double zzah;
    @SafeParcelable.Field(id=5, getter="getLongitude")
    private final double zzai;
    @SafeParcelable.Field(id=6, getter="getRadius")
    private final float zzaj;
    @SafeParcelable.Field(id=7, getter="getTransitionTypes")
    private final int zzae;
    @SafeParcelable.Field(id=8, getter="getNotificationResponsiveness", defaultValue="0")
    private final int zzak;
    @SafeParcelable.Field(id=9, getter="getLoiteringDelay", defaultValue="-1")
    private final int zzal;
    public static final Parcelable.Creator<zzbh> CREATOR = new zzbi();

    @SafeParcelable.Constructor
    public zzbh(@SafeParcelable.Param(id=1) String string, @SafeParcelable.Param(id=7) int n, @SafeParcelable.Param(id=3) short s, @SafeParcelable.Param(id=4) double d, @SafeParcelable.Param(id=5) double d2, @SafeParcelable.Param(id=6) float f, @SafeParcelable.Param(id=2) long l, @SafeParcelable.Param(id=8) int n2, @SafeParcelable.Param(id=9) int n3) {
        float f2;
        String string2 = string;
        if (string2 == null || string2.length() > 100) {
            String string3 = String.valueOf(string2);
            throw new IllegalArgumentException(string3.length() != 0 ? "requestId is null or too long: ".concat(string3) : new String("requestId is null or too long: "));
        }
        float f3 = f;
        if (f2 <= 0.0f) {
            throw new IllegalArgumentException(new StringBuilder(31).append("invalid radius: ").append(f3).toString());
        }
        double d3 = d2;
        double d4 = d;
        if (d4 > 90.0 || d4 < -90.0) {
            throw new IllegalArgumentException(new StringBuilder(42).append("invalid latitude: ").append(d4).toString());
        }
        if (d3 > 180.0 || d3 < -180.0) {
            throw new IllegalArgumentException(new StringBuilder(43).append("invalid longitude: ").append(d3).toString());
        }
        int n4 = n;
        int n5 = n4 & 7;
        if (n5 == 0) {
            throw new IllegalArgumentException(new StringBuilder(46).append("No supported transition specified: ").append(n4).toString());
        }
        n = n5;
        this.zzag = s;
        this.zzad = string;
        this.zzah = d;
        this.zzai = d2;
        this.zzaj = f;
        this.zzdo = l;
        this.zzae = n;
        this.zzak = n2;
        this.zzal = n3;
    }

    @Override
    public final String getRequestId() {
        return this.zzad;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        zzbh zzbh2 = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)1, (String)zzbh2.getRequestId(), (boolean)false);
        SafeParcelWriter.writeLong((Parcel)parcel2, (int)2, (long)zzbh2.zzdo);
        SafeParcelWriter.writeShort((Parcel)parcel2, (int)3, (short)zzbh2.zzag);
        SafeParcelWriter.writeDouble((Parcel)parcel2, (int)4, (double)zzbh2.zzah);
        SafeParcelWriter.writeDouble((Parcel)parcel2, (int)5, (double)zzbh2.zzai);
        SafeParcelWriter.writeFloat((Parcel)parcel2, (int)6, (float)zzbh2.zzaj);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)7, (int)zzbh2.zzae);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)8, (int)zzbh2.zzak);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)9, (int)zzbh2.zzal);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    public static zzbh zza(byte[] byArray) {
        Parcel parcel = Parcel.obtain();
        parcel.unmarshall(byArray, 0, byArray.length);
        parcel.setDataPosition(0);
        zzbh zzbh2 = (zzbh)CREATOR.createFromParcel(parcel);
        parcel.recycle();
        return zzbh2;
    }

    public final String toString() {
        String string;
        Object[] objectArray = new Object[9];
        switch (this.zzag) {
            case 1: {
                string = "CIRCLE";
                break;
            }
            default: {
                string = null;
            }
        }
        objectArray[0] = string;
        objectArray[1] = this.zzad.replaceAll("\\p{C}", "?");
        objectArray[2] = this.zzae;
        objectArray[3] = this.zzah;
        objectArray[4] = this.zzai;
        objectArray[5] = Float.valueOf(this.zzaj);
        objectArray[6] = this.zzak / 1000;
        objectArray[7] = this.zzal;
        objectArray[8] = this.zzdo;
        return String.format(Locale.US, "Geofence[%s id:%s transitions:%d %.6f, %.6f %.0fm, resp=%ds, dwell=%dms, @%d]", objectArray);
    }

    public final int hashCode() {
        long l = Double.doubleToLongBits(this.zzah);
        int n = 31 + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.zzai);
        n = n * 31 + (int)(l ^ l >>> 32);
        n = n * 31 + Float.floatToIntBits(this.zzaj);
        n = n * 31 + this.zzag;
        return n * 31 + this.zzae;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof zzbh)) {
            return false;
        }
        zzbh zzbh2 = (zzbh)object;
        if (this.zzaj != zzbh2.zzaj) {
            return false;
        }
        if (this.zzah != zzbh2.zzah) {
            return false;
        }
        if (this.zzai != zzbh2.zzai) {
            return false;
        }
        return this.zzag == zzbh2.zzag;
    }
}

