/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.content.Intent;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelableSerializer;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.location.DetectedActivity;
import com.google.android.gms.location.zzb;
import java.util.Collections;
import java.util.List;

@SafeParcelable.Reserved(value={1000})
@SafeParcelable.Class(creator="ActivityRecognitionResultCreator")
public class ActivityRecognitionResult
extends AbstractSafeParcelable
implements ReflectedParcelable {
    public static final Parcelable.Creator<ActivityRecognitionResult> CREATOR = new zzb();
    @SafeParcelable.Field(id=1)
    private List<DetectedActivity> zze;
    @SafeParcelable.Field(id=2)
    private long zzf;
    @SafeParcelable.Field(id=3)
    private long zzg;
    @SafeParcelable.Field(id=4)
    private int zzh;
    @SafeParcelable.Field(id=5)
    private Bundle extras;

    public ActivityRecognitionResult(List<DetectedActivity> list, long l, long l2) {
        this(list, l, l2, 0, null);
    }

    @VisibleForTesting
    public ActivityRecognitionResult(DetectedActivity detectedActivity, long l, long l2) {
        this(detectedActivity, l, l2, 0, null);
    }

    private ActivityRecognitionResult(DetectedActivity detectedActivity, long l, long l2, int n, Bundle bundle) {
        this(Collections.singletonList(detectedActivity), l, l2, 0, null);
    }

    public static boolean hasResult(Intent intent) {
        if (intent == null) {
            return false;
        }
        Intent intent2 = intent;
        if (intent2 == null ? false : intent2.hasExtra("com.google.android.location.internal.EXTRA_ACTIVITY_RESULT")) {
            return true;
        }
        List<ActivityRecognitionResult> list = ActivityRecognitionResult.zza(intent);
        return list != null && !list.isEmpty();
    }

    /*
     * Unable to fully structure code
     */
    public static ActivityRecognitionResult extractResult(Intent var0) {
        var3_1 = var0;
        if (!ActivityRecognitionResult.hasResult(var3_1)) ** GOTO lbl-1000
        var4_2 = var3_1.getExtras().get("com.google.android.location.internal.EXTRA_ACTIVITY_RESULT");
        if (var4_2 instanceof byte[]) {
            v0 = (ActivityRecognitionResult)SafeParcelableSerializer.deserializeFromBytes((byte[])((byte[])var4_2), ActivityRecognitionResult.CREATOR);
        } else if (var4_2 instanceof ActivityRecognitionResult) {
            v0 = (ActivityRecognitionResult)var4_2;
        } else lbl-1000:
        // 2 sources

        {
            v0 = var1_3 = null;
        }
        if (v0 != null) {
            return var1_3;
        }
        var2_4 = ActivityRecognitionResult.zza(var0);
        if (var2_4 == null || var2_4.isEmpty()) {
            return null;
        }
        return var2_4.get(var2_4.size() - 1);
    }

    @Nullable
    private static List<ActivityRecognitionResult> zza(Intent intent) {
        Intent intent2 = intent;
        if (!(intent2 == null ? false : intent2.hasExtra("com.google.android.location.internal.EXTRA_ACTIVITY_RESULT_LIST"))) {
            return null;
        }
        return SafeParcelableSerializer.deserializeIterableFromIntentExtra((Intent)intent, (String)"com.google.android.location.internal.EXTRA_ACTIVITY_RESULT_LIST", CREATOR);
    }

    public DetectedActivity getMostProbableActivity() {
        return this.zze.get(0);
    }

    public int getActivityConfidence(int n) {
        for (DetectedActivity detectedActivity : this.zze) {
            if (detectedActivity.getType() != n) continue;
            return detectedActivity.getConfidence();
        }
        return 0;
    }

    public List<DetectedActivity> getProbableActivities() {
        return this.zze;
    }

    public long getTime() {
        return this.zzf;
    }

    public long getElapsedRealtimeMillis() {
        return this.zzg;
    }

    public String toString() {
        String string = String.valueOf(this.zze);
        long l = this.zzf;
        long l2 = this.zzg;
        return new StringBuilder(124 + String.valueOf(string).length()).append("ActivityRecognitionResult [probableActivities=").append(string).append(", timeMillis=").append(l).append(", elapsedRealtimeMillis=").append(l2).append("]").toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || ((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        ActivityRecognitionResult activityRecognitionResult = (ActivityRecognitionResult)((Object)object);
        return this.zzf == activityRecognitionResult.zzf && this.zzg == activityRecognitionResult.zzg && this.zzh == activityRecognitionResult.zzh && Objects.equal(this.zze, activityRecognitionResult.zze) && ActivityRecognitionResult.zza(this.extras, activityRecognitionResult.extras);
    }

    private static boolean zza(Bundle bundle, Bundle bundle2) {
        if (bundle == null && bundle2 == null) {
            return true;
        }
        if (bundle == null && bundle2 != null || bundle != null && bundle2 == null) {
            return false;
        }
        if (bundle.size() != bundle2.size()) {
            return false;
        }
        for (String string : bundle.keySet()) {
            if (!bundle2.containsKey(string)) {
                return false;
            }
            if (!(bundle.get(string) == null ? bundle2.get(string) != null : (bundle.get(string) instanceof Bundle ? !ActivityRecognitionResult.zza(bundle.getBundle(string), bundle2.getBundle(string)) : !bundle.get(string).equals(bundle2.get(string))))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.zzf, this.zzg, this.zzh, this.zze, this.extras});
    }

    @SafeParcelable.Constructor
    public ActivityRecognitionResult(@SafeParcelable.Param(id=1) List<DetectedActivity> list, @SafeParcelable.Param(id=2) long l, @SafeParcelable.Param(id=3) long l2, @SafeParcelable.Param(id=4) int n, @SafeParcelable.Param(id=5) Bundle bundle) {
        Preconditions.checkArgument((list != null && list.size() > 0 ? 1 : 0) != 0, (Object)"Must have at least 1 detected activity");
        Preconditions.checkArgument((l > 0L && l2 > 0L ? 1 : 0) != 0, (Object)"Must set times");
        this.zze = list;
        this.zzf = l;
        this.zzg = l2;
        this.zzh = n;
        this.extras = bundle;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        ActivityRecognitionResult activityRecognitionResult = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeTypedList((Parcel)parcel2, (int)1, activityRecognitionResult.zze, (boolean)false);
        SafeParcelWriter.writeLong((Parcel)parcel2, (int)2, (long)activityRecognitionResult.zzf);
        SafeParcelWriter.writeLong((Parcel)parcel2, (int)3, (long)activityRecognitionResult.zzg);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)4, (int)activityRecognitionResult.zzh);
        SafeParcelWriter.writeBundle((Parcel)parcel2, (int)5, (Bundle)activityRecognitionResult.extras, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }
}

