/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.iid;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Log;
import androidx.annotation.GuardedBy;
import androidx.annotation.Nullable;
import androidx.collection.ArrayMap;
import androidx.core.content.ContextCompat;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.iid.InstanceIDListenerService;
import com.google.android.gms.iid.zzn;
import com.google.android.gms.iid.zzo;
import com.google.android.gms.iid.zzp;
import java.io.File;
import java.io.IOException;
import java.util.Map;

public final class zzak {
    private SharedPreferences zzde;
    private Context zzl;
    private final zzn zzdf;
    @GuardedBy(value="this")
    private final Map<String, zzo> zzdg;

    public zzak(Context context) {
        this(context, new zzn());
    }

    @VisibleForTesting
    private zzak(Context context, zzn zzn2) {
        block4: {
            this.zzdg = new ArrayMap();
            this.zzl = context;
            this.zzde = context.getSharedPreferences("com.google.android.gms.appid", 0);
            this.zzdf = zzn2;
            String string = "com.google.android.gms.appid-no-backup";
            zzak zzak2 = this;
            File file = ContextCompat.getNoBackupFilesDir((Context)zzak2.zzl);
            File file2 = new File(file, string);
            if (!file2.exists()) {
                try {
                    if (file2.createNewFile() && !zzak2.isEmpty()) {
                        Log.i((String)"InstanceID/Store", (String)"App restored, clearing state");
                        InstanceIDListenerService.zzd(zzak2.zzl, zzak2);
                    }
                    return;
                }
                catch (IOException iOException) {
                    if (!Log.isLoggable((String)"InstanceID/Store", (int)3)) break block4;
                    String string2 = String.valueOf(iOException.getMessage());
                    Log.d((String)"InstanceID/Store", (String)(string2.length() != 0 ? "Error creating file in no backup dir: ".concat(string2) : new String("Error creating file in no backup dir: ")));
                }
            }
        }
    }

    public final boolean isEmpty() {
        return this.zzde.getAll().isEmpty();
    }

    private static String zzd(String string, String string2, String string3) {
        return new StringBuilder(4 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string).append("|T|").append(string2).append("|").append(string3).toString();
    }

    private static String zze(String string, String string2, String string3) {
        return new StringBuilder(14 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string).append("|T-timestamp|").append(string2).append("|").append(string3).toString();
    }

    @Nullable
    final synchronized String get(String string) {
        return this.zzde.getString(string, null);
    }

    public final synchronized void zzi(String string) {
        SharedPreferences.Editor editor = this.zzde.edit();
        for (String string2 : this.zzde.getAll().keySet()) {
            if (!string2.startsWith(string)) continue;
            editor.remove(string2);
        }
        editor.commit();
    }

    public final synchronized void zzz() {
        this.zzdg.clear();
        zzn.zzi(this.zzl);
        this.zzde.edit().clear().commit();
    }

    @Nullable
    public final synchronized String zzf(String string, String string2, String string3) {
        String string4 = zzak.zzd(string, string2, string3);
        return this.zzde.getString(string4, null);
    }

    final synchronized long zzg(String string, String string2, String string3) {
        String string4 = zzak.zze(string, string2, string3);
        return this.zzde.getLong(string4, -1L);
    }

    public final synchronized void zzd(String string, String string2, String string3, String string4, String string5) {
        String string6 = zzak.zzd(string, string2, string3);
        String string7 = zzak.zze(string, string2, string3);
        SharedPreferences.Editor editor = this.zzde.edit();
        editor.putString(string6, string4);
        editor.putLong(string7, System.currentTimeMillis());
        editor.putString("appVersion", string5);
        editor.commit();
    }

    public final synchronized void zzh(String string, String string2, String string3) {
        SharedPreferences.Editor editor = this.zzde.edit();
        editor.remove(zzak.zzd(string, string2, string3));
        editor.remove(zzak.zze(string, string2, string3));
        editor.commit();
    }

    public final synchronized zzo zzj(String string) {
        zzo zzo2 = this.zzdg.get(string);
        if (zzo2 != null) {
            return zzo2;
        }
        try {
            zzo2 = this.zzdf.zze(this.zzl, string);
        }
        catch (zzp zzp2) {
            Log.w((String)"InstanceID/Store", (String)"Stored data is corrupt, generating new identity");
            InstanceIDListenerService.zzd(this.zzl, this);
            zzo2 = this.zzdf.zzf(this.zzl, string);
        }
        this.zzdg.put(string, zzo2);
        return zzo2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void zzk(String string) {
        zzak zzak2 = this;
        synchronized (zzak2) {
            this.zzdg.remove(string);
        }
        zzn.zzg(this.zzl, string);
        this.zzi(String.valueOf(string).concat("|"));
    }

    static String zzh(String string, String string2) {
        return new StringBuilder(3 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("|S|").append(string2).toString();
    }
}

