/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.iid;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.support.annotation.GuardedBy;
import android.support.annotation.VisibleForTesting;
import android.util.Log;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.common.util.concurrent.NamedThreadFactory;
import com.google.android.gms.iid.zzg;
import com.google.android.gms.iid.zzi;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;

public final class zzk
implements ServiceConnection {
    private final Context zzl;
    private final Intent zzbp;
    private final ScheduledExecutorService zzbq;
    private final Queue<zzg> zzbr = new ArrayDeque<zzg>();
    private zzi zzbs;
    @GuardedBy(value="this")
    private boolean zzbt = false;

    public zzk(Context context, String string) {
        this(context, string, new ScheduledThreadPoolExecutor(0, (ThreadFactory)new NamedThreadFactory("EnhancedIntentService")));
    }

    @VisibleForTesting
    private zzk(Context context, String string, ScheduledExecutorService scheduledExecutorService) {
        this.zzl = context.getApplicationContext();
        this.zzbp = new Intent(string).setPackage(this.zzl.getPackageName());
        this.zzbq = scheduledExecutorService;
    }

    public final synchronized void zzd(Intent intent, BroadcastReceiver.PendingResult pendingResult) {
        if (Log.isLoggable((String)"EnhancedIntentService", (int)3)) {
            Log.d((String)"EnhancedIntentService", (String)"new intent queued in the bind-strategy delivery");
        }
        this.zzbr.add(new zzg(intent, pendingResult, this.zzbq));
        this.zzm();
    }

    private final synchronized void zzm() {
        if (Log.isLoggable((String)"EnhancedIntentService", (int)3)) {
            Log.d((String)"EnhancedIntentService", (String)"flush queue called");
        }
        while (!this.zzbr.isEmpty()) {
            if (Log.isLoggable((String)"EnhancedIntentService", (int)3)) {
                Log.d((String)"EnhancedIntentService", (String)"found intent to be delivered");
            }
            if (this.zzbs != null && this.zzbs.isBinderAlive()) {
                if (Log.isLoggable((String)"EnhancedIntentService", (int)3)) {
                    Log.d((String)"EnhancedIntentService", (String)"binder is alive, sending the intent.");
                }
                zzg zzg2 = this.zzbr.poll();
                this.zzbs.zzd(zzg2);
                continue;
            }
            zzk zzk2 = this;
            if (Log.isLoggable((String)"EnhancedIntentService", (int)3)) {
                boolean bl = !zzk2.zzbt;
                Log.d((String)"EnhancedIntentService", (String)new StringBuilder(39).append("binder is dead. start connection? ").append(bl).toString());
            }
            if (!zzk2.zzbt) {
                zzk2.zzbt = true;
                try {
                    if (ConnectionTracker.getInstance().bindService(zzk2.zzl, zzk2.zzbp, (ServiceConnection)zzk2, 65)) {
                        return;
                    }
                    Log.e((String)"EnhancedIntentService", (String)"binding to the service failed");
                }
                catch (SecurityException securityException) {
                    Log.e((String)"EnhancedIntentService", (String)"Exception while binding the service", (Throwable)securityException);
                }
                zzk2.zzbt = false;
                zzk2.zzn();
            }
            return;
        }
    }

    @GuardedBy(value="this")
    private final void zzn() {
        while (!this.zzbr.isEmpty()) {
            this.zzbr.poll().finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onServiceConnected(ComponentName componentName, IBinder iBinder) {
        zzk zzk2 = this;
        synchronized (zzk2) {
            this.zzbt = false;
            this.zzbs = (zzi)iBinder;
            if (Log.isLoggable((String)"EnhancedIntentService", (int)3)) {
                String string = String.valueOf(componentName);
                Log.d((String)"EnhancedIntentService", (String)new StringBuilder(20 + String.valueOf(string).length()).append("onServiceConnected: ").append(string).toString());
            }
            if (iBinder == null) {
                Log.e((String)"EnhancedIntentService", (String)"Null service connection");
                this.zzn();
            } else {
                this.zzm();
            }
            return;
        }
    }

    public final void onServiceDisconnected(ComponentName componentName) {
        if (Log.isLoggable((String)"EnhancedIntentService", (int)3)) {
            String string = String.valueOf(componentName);
            Log.d((String)"EnhancedIntentService", (String)new StringBuilder(23 + String.valueOf(string).length()).append("onServiceDisconnected: ").append(string).toString());
        }
        this.zzm();
    }
}

