/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.accounts.Account;
import android.app.Activity;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.IntentSender;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcelable;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.internal.zzh;
import com.google.android.gms.common.internal.zzl;
import com.google.android.gms.identity.intents.UserAddressRequest;
import com.google.android.gms.internal.zzve;
import com.google.android.gms.internal.zzvf;

public class zzvd
extends zzl<zzvf> {
    private Activity mActivity;
    private zza afF;
    private final String fs;
    private final int mTheme;

    public zzvd(Activity activity, Looper looper, zzh zzh2, int n, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        super((Context)activity, looper, 12, zzh2, connectionCallbacks, onConnectionFailedListener);
        this.fs = zzh2.getAccountName();
        this.mActivity = activity;
        this.mTheme = n;
    }

    public boolean zzaty() {
        return true;
    }

    protected String zzix() {
        return "com.google.android.gms.identity.service.BIND";
    }

    protected String zziy() {
        return "com.google.android.gms.identity.intents.internal.IAddressService";
    }

    protected zzvf zzgt(IBinder iBinder) {
        return zzvf.zza.zzgv(iBinder);
    }

    public void disconnect() {
        super.disconnect();
        if (this.afF != null) {
            this.afF.setActivity(null);
            this.afF = null;
        }
    }

    protected zzvf zzbom() throws DeadObjectException {
        return (zzvf)super.zzatx();
    }

    protected void zzbon() {
        super.zzatw();
    }

    public void zza(UserAddressRequest userAddressRequest, int n) {
        this.zzbon();
        this.afF = new zza(n, this.mActivity);
        try {
            Bundle bundle = new Bundle();
            String string = this.getContext().getPackageName();
            bundle.putString("com.google.android.gms.identity.intents.EXTRA_CALLING_PACKAGE_NAME", string);
            if (!TextUtils.isEmpty((CharSequence)this.fs)) {
                bundle.putParcelable("com.google.android.gms.identity.intents.EXTRA_ACCOUNT", (Parcelable)new Account(this.fs, "com.google"));
            }
            bundle.putInt("com.google.android.gms.identity.intents.EXTRA_THEME", this.mTheme);
            this.zzbom().zza(this.afF, userAddressRequest, bundle);
        }
        catch (RemoteException remoteException) {
            Log.e((String)"AddressClientImpl", (String)"Exception requesting user address", (Throwable)remoteException);
            Bundle bundle = new Bundle();
            bundle.putInt("com.google.android.gms.identity.intents.EXTRA_ERROR_CODE", 555);
            this.afF.zzj(1, bundle);
        }
    }

    protected /* synthetic */ IInterface zzh(IBinder iBinder) {
        return this.zzgt(iBinder);
    }

    public static final class zza
    extends zzve.zza {
        private final int vV;
        private Activity mActivity;

        public zza(int n, Activity activity) {
            this.vV = n;
            this.mActivity = activity;
        }

        @Override
        public void zzj(int n, Bundle bundle) {
            ConnectionResult connectionResult;
            if (n == 1) {
                Intent intent = new Intent();
                intent.putExtras(bundle);
                PendingIntent pendingIntent = this.mActivity.createPendingResult(this.vV, intent, 0x40000000);
                if (pendingIntent == null) {
                    return;
                }
                try {
                    pendingIntent.send(1);
                }
                catch (PendingIntent.CanceledException canceledException) {
                    Log.w((String)"AddressClientImpl", (String)"Exception settng pending result", (Throwable)canceledException);
                }
                return;
            }
            PendingIntent pendingIntent = null;
            if (bundle != null) {
                pendingIntent = (PendingIntent)bundle.getParcelable("com.google.android.gms.identity.intents.EXTRA_PENDING_INTENT");
            }
            if ((connectionResult = new ConnectionResult(n, pendingIntent)).hasResolution()) {
                try {
                    connectionResult.startResolutionForResult(this.mActivity, this.vV);
                }
                catch (IntentSender.SendIntentException sendIntentException) {
                    Log.w((String)"AddressClientImpl", (String)"Exception starting pending intent", (Throwable)sendIntentException);
                }
            } else {
                try {
                    PendingIntent pendingIntent2 = this.mActivity.createPendingResult(this.vV, new Intent(), 0x40000000);
                    if (pendingIntent2 != null) {
                        pendingIntent2.send(1);
                    }
                }
                catch (PendingIntent.CanceledException canceledException) {
                    Log.w((String)"AddressClientImpl", (String)"Exception setting pending result", (Throwable)canceledException);
                }
            }
        }

        private void setActivity(Activity activity) {
            this.mActivity = activity;
        }
    }
}

