/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.accounts.Account;
import android.app.Activity;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.IntentSender;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcelable;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.internal.zzg;
import com.google.android.gms.common.internal.zzk;
import com.google.android.gms.identity.intents.UserAddressRequest;
import com.google.android.gms.internal.zzsl;
import com.google.android.gms.internal.zzsm;

public class zzsk
extends zzk<zzsm> {
    private Activity mActivity;
    private zza zzaTM;
    private final String zzaaR;
    private final int mTheme;

    public zzsk(Activity activity, Looper looper, zzg zzg2, int n, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        super((Context)activity, looper, 12, zzg2, connectionCallbacks, onConnectionFailedListener);
        this.zzaaR = zzg2.getAccountName();
        this.mActivity = activity;
        this.mTheme = n;
    }

    public boolean zztn() {
        return true;
    }

    protected String zzhT() {
        return "com.google.android.gms.identity.service.BIND";
    }

    protected String zzhU() {
        return "com.google.android.gms.identity.intents.internal.IAddressService";
    }

    protected zzsm zzci(IBinder iBinder) {
        return zzsm.zza.zzck(iBinder);
    }

    public void disconnect() {
        super.disconnect();
        if (this.zzaTM != null) {
            this.zzaTM.setActivity(null);
            this.zzaTM = null;
        }
    }

    protected zzsm zzCa() throws DeadObjectException {
        return (zzsm)super.zztm();
    }

    protected void zzCb() {
        super.zztl();
    }

    public void zza(UserAddressRequest userAddressRequest, int n) {
        this.zzCb();
        this.zzaTM = new zza(n, this.mActivity);
        try {
            Bundle bundle = new Bundle();
            String string = this.getContext().getPackageName();
            bundle.putString("com.google.android.gms.identity.intents.EXTRA_CALLING_PACKAGE_NAME", string);
            if (!TextUtils.isEmpty((CharSequence)this.zzaaR)) {
                bundle.putParcelable("com.google.android.gms.identity.intents.EXTRA_ACCOUNT", (Parcelable)new Account(this.zzaaR, "com.google"));
            }
            bundle.putInt("com.google.android.gms.identity.intents.EXTRA_THEME", this.mTheme);
            this.zzCa().zza(this.zzaTM, userAddressRequest, bundle);
        }
        catch (RemoteException remoteException) {
            Log.e((String)"AddressClientImpl", (String)"Exception requesting user address", (Throwable)remoteException);
            Bundle bundle = new Bundle();
            bundle.putInt("com.google.android.gms.identity.intents.EXTRA_ERROR_CODE", 555);
            this.zzaTM.zzj(1, bundle);
        }
    }

    protected /* synthetic */ IInterface zzab(IBinder iBinder) {
        return this.zzci(iBinder);
    }

    public static final class zza
    extends zzsl.zza {
        private final int zzalt;
        private Activity mActivity;

        public zza(int n, Activity activity) {
            this.zzalt = n;
            this.mActivity = activity;
        }

        @Override
        public void zzj(int n, Bundle bundle) {
            ConnectionResult connectionResult;
            if (n == 1) {
                Intent intent = new Intent();
                intent.putExtras(bundle);
                PendingIntent pendingIntent = this.mActivity.createPendingResult(this.zzalt, intent, 0x40000000);
                if (pendingIntent == null) {
                    return;
                }
                try {
                    pendingIntent.send(1);
                }
                catch (PendingIntent.CanceledException canceledException) {
                    Log.w((String)"AddressClientImpl", (String)"Exception settng pending result", (Throwable)canceledException);
                }
                return;
            }
            PendingIntent pendingIntent = null;
            if (bundle != null) {
                pendingIntent = (PendingIntent)bundle.getParcelable("com.google.android.gms.identity.intents.EXTRA_PENDING_INTENT");
            }
            if ((connectionResult = new ConnectionResult(n, pendingIntent)).hasResolution()) {
                try {
                    connectionResult.startResolutionForResult(this.mActivity, this.zzalt);
                }
                catch (IntentSender.SendIntentException sendIntentException) {
                    Log.w((String)"AddressClientImpl", (String)"Exception starting pending intent", (Throwable)sendIntentException);
                }
            } else {
                try {
                    PendingIntent pendingIntent2 = this.mActivity.createPendingResult(this.zzalt, new Intent(), 0x40000000);
                    if (pendingIntent2 != null) {
                        pendingIntent2.send(1);
                    }
                }
                catch (PendingIntent.CanceledException canceledException) {
                    Log.w((String)"AddressClientImpl", (String)"Exception setting pending result", (Throwable)canceledException);
                }
            }
        }

        private void setActivity(Activity activity) {
            this.mActivity = activity;
        }
    }
}

