/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.identity;

import android.accounts.Account;
import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.Looper;
import android.os.Parcelable;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.Nullable;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.internal.ClientSettings;
import com.google.android.gms.common.internal.GmsClient;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.identity.intents.UserAddressRequest;
import com.google.android.gms.internal.identity.zzd;
import com.google.android.gms.internal.identity.zzg;
import com.google.android.gms.internal.identity.zzh;

public final class zze
extends GmsClient<zzh> {
    private final Activity zze;
    @Nullable
    private zzd zzf;
    @Nullable
    private final String zzg;
    private final int zzh;

    public final int getMinApkVersion() {
        return 12451000;
    }

    protected final String getServiceDescriptor() {
        return "com.google.android.gms.identity.intents.internal.IAddressService";
    }

    protected final String getStartServiceAction() {
        return "com.google.android.gms.identity.service.BIND";
    }

    public zze(Activity activity, Looper looper, ClientSettings clientSettings, int n, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        super((Context)activity, looper, 12, clientSettings, connectionCallbacks, onConnectionFailedListener);
        this.zzg = clientSettings.getAccountName();
        this.zze = activity;
        this.zzh = n;
    }

    public final void disconnect() {
        super.disconnect();
        zzd zzd2 = this.zzf;
        if (zzd2 != null) {
            zzd.zzb(zzd2, null);
            this.zzf = null;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzp(UserAddressRequest userAddressRequest, int n) {
        zzd zzd2;
        super.checkConnected();
        this.zzf = zzd2 = new zzd(n, this.zze);
        try {
            Bundle bundle = new Bundle();
            bundle.putString("com.google.android.gms.identity.intents.EXTRA_CALLING_PACKAGE_NAME", this.getContext().getPackageName());
            boolean bl = TextUtils.isEmpty((CharSequence)this.zzg);
            if (!bl) {
                Account account = new Account(this.zzg, "com.google");
                bundle.putParcelable("com.google.android.gms.identity.intents.EXTRA_ACCOUNT", (Parcelable)account);
            }
            bundle.putInt("com.google.android.gms.identity.intents.EXTRA_THEME", this.zzh);
            zzh zzh2 = (zzh)super.getService();
            zzh2.zzc((zzg)Preconditions.checkNotNull((Object)this.zzf), userAddressRequest, bundle);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e((String)"AddressClientImpl", (String)"Exception requesting user address", (Throwable)remoteException);
            Bundle bundle = new Bundle();
            bundle.putInt("com.google.android.gms.identity.intents.EXTRA_ERROR_CODE", 555);
            ((zzd)Preconditions.checkNotNull((Object)this.zzf)).zzc(1, bundle);
            return;
        }
    }

    public final boolean requiresAccount() {
        return true;
    }
}

