/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.gcm;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.WorkerThread;
import androidx.collection.ArrayMap;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.CollectionUtils;
import com.google.android.gms.gcm.GcmTaskService;
import com.google.android.gms.gcm.GoogleCloudMessaging;
import com.google.android.gms.gcm.Task;
import com.google.android.gms.gcm.zzm;
import com.google.android.gms.gcm.zzn;
import com.google.android.gms.gcm.zzo;
import com.google.android.gms.gcm.zzp;
import com.google.android.gms.internal.gcm.zzq;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.GuardedBy;

public class GcmNetworkManager {
    public static final int RESULT_SUCCESS = 0;
    public static final int RESULT_RESCHEDULE = 1;
    public static final int RESULT_FAILURE = 2;
    @GuardedBy(value="GcmNetworkManager.class")
    private static GcmNetworkManager zzh;
    private final Context zzi;
    @GuardedBy(value="this")
    private final Map<String, Map<String, Boolean>> zzj = new ArrayMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GcmNetworkManager getInstance(Context context) {
        Class<GcmNetworkManager> clazz = GcmNetworkManager.class;
        synchronized (GcmNetworkManager.class) {
            if (zzh == null) {
                zzh = new GcmNetworkManager(context.getApplicationContext());
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return zzh;
        }
    }

    private GcmNetworkManager(Context context) {
        this.zzi = context;
    }

    @NonNull
    private final zzn zze() {
        if (GoogleCloudMessaging.zzf(this.zzi) < 5000000) {
            Log.e((String)"GcmNetworkManager", (String)"Google Play services is not available, dropping all GcmNetworkManager requests");
            return new zzo();
        }
        return new zzm(this.zzi);
    }

    @WorkerThread
    public synchronized void schedule(Task task) {
        zzp zzp2;
        block4: {
            String string2 = String.valueOf("nts:client:schedule:");
            String string3 = String.valueOf(task.getTag());
            zzp2 = new zzp(string3.length() != 0 ? string2.concat(string3) : new String(string2));
            Throwable throwable = null;
            try {
                Map<String, Boolean> map;
                this.zze(task.getServiceName());
                if (!this.zze().zzd(task) || (map = this.zzj.get(task.getServiceName())) == null || !map.containsKey(task.getTag())) break block4;
                map.put(task.getTag(), true);
            }
            catch (Throwable throwable2) {
                try {
                    Throwable throwable3 = throwable2;
                    throwable = throwable2;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    GcmNetworkManager.zzd(throwable, zzp2);
                    throw throwable4;
                }
            }
        }
        GcmNetworkManager.zzd(null, zzp2);
        return;
    }

    @WorkerThread
    public void cancelTask(String string2, Class<? extends GcmTaskService> clazz) {
        Class<? extends GcmTaskService> clazz2 = clazz;
        String string3 = string2;
        GcmNetworkManager gcmNetworkManager = this;
        ComponentName componentName = new ComponentName(gcmNetworkManager.zzi, clazz2);
        String string4 = string3;
        GcmNetworkManager gcmNetworkManager2 = gcmNetworkManager;
        String string5 = String.valueOf("nts:client:cancel:");
        String string6 = String.valueOf(string4);
        zzp zzp2 = new zzp(string6.length() != 0 ? string5.concat(string6) : new String(string5));
        Throwable throwable = null;
        try {
            GcmNetworkManager.zzd(string4);
            gcmNetworkManager2.zze(componentName.getClassName());
            gcmNetworkManager2.zze().zzd(componentName, string4);
        }
        catch (Throwable throwable2) {
            try {
                Throwable throwable3 = throwable2;
                throwable = throwable2;
                throw throwable3;
            }
            catch (Throwable throwable4) {
                GcmNetworkManager.zzd(throwable, zzp2);
                throw throwable4;
            }
        }
        GcmNetworkManager.zzd(null, zzp2);
        return;
    }

    @WorkerThread
    public void cancelAllTasks(Class<? extends GcmTaskService> clazz) {
        Class<? extends GcmTaskService> clazz2 = clazz;
        GcmNetworkManager gcmNetworkManager = this;
        ComponentName componentName = new ComponentName(gcmNetworkManager.zzi, clazz2);
        GcmNetworkManager gcmNetworkManager2 = gcmNetworkManager;
        zzp zzp2 = new zzp("nts:client:cancelAll");
        Throwable throwable = null;
        try {
            gcmNetworkManager2.zze(componentName.getClassName());
            gcmNetworkManager2.zze().zzd(componentName);
        }
        catch (Throwable throwable2) {
            try {
                Throwable throwable3 = throwable2;
                throwable = throwable2;
                throw throwable3;
            }
            catch (Throwable throwable4) {
                GcmNetworkManager.zzd(throwable, zzp2);
                throw throwable4;
            }
        }
        GcmNetworkManager.zzd(null, zzp2);
        return;
    }

    static void zzd(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("Must provide a valid tag.");
        }
        if (100 < string2.length()) {
            throw new IllegalArgumentException("Tag is larger than max permissible tag length (100)");
        }
    }

    private final boolean zze(String string2) {
        List list;
        List list2;
        Preconditions.checkNotNull((Object)string2, (Object)"GcmTaskService must not be null.");
        String string3 = string2;
        GcmNetworkManager gcmNetworkManager = this;
        PackageManager packageManager = gcmNetworkManager.zzi.getPackageManager();
        if (packageManager == null) {
            list2 = Collections.emptyList();
        } else {
            String string4 = string3;
            GcmNetworkManager gcmNetworkManager2 = gcmNetworkManager;
            list2 = list = packageManager.queryIntentServices(string4 != null ? new Intent("com.google.android.gms.gcm.ACTION_TASK_READY").setClassName(gcmNetworkManager2.zzi, string4) : new Intent("com.google.android.gms.gcm.ACTION_TASK_READY").setPackage(gcmNetworkManager2.zzi.getPackageName()), 0);
        }
        if (CollectionUtils.isEmpty(list2)) {
            Log.e((String)"GcmNetworkManager", (String)String.valueOf(string2).concat(" is not available. This may cause the task to be lost."));
            return true;
        }
        for (ResolveInfo resolveInfo : list) {
            if (resolveInfo.serviceInfo == null || !resolveInfo.serviceInfo.enabled) continue;
            return true;
        }
        throw new IllegalArgumentException(new StringBuilder(118 + String.valueOf(string2).length()).append("The GcmTaskService class you provided ").append(string2).append(" does not seem to support receiving com.google.android.gms.gcm.ACTION_TASK_READY").toString());
    }

    final synchronized boolean zzd(String string2, String string3) {
        ArrayMap arrayMap = this.zzj.get(string3);
        if (arrayMap == null) {
            arrayMap = new ArrayMap();
            this.zzj.put(string3, (Map<String, Boolean>)arrayMap);
        }
        return arrayMap.put(string2, false) == null;
    }

    final synchronized void zze(String string2, String string3) {
        Map<String, Boolean> map = this.zzj.get(string3);
        if (map != null && map.remove(string2) != null && map.isEmpty()) {
            this.zzj.remove(string3);
        }
    }

    final synchronized boolean zzf(String string2, String string3) {
        Map<String, Boolean> map = this.zzj.get(string3);
        if (map != null) {
            Boolean bl = map.get(string2);
            if (bl == null) {
                return false;
            }
            return bl;
        }
        return false;
    }

    final synchronized boolean zzf(String string2) {
        return this.zzj.containsKey(string2);
    }

    private static /* synthetic */ void zzd(Throwable throwable, zzp zzp2) {
        if (throwable != null) {
            try {
                zzp2.close();
                return;
            }
            catch (Throwable throwable2) {
                zzq.zzd((Throwable)throwable, (Throwable)throwable2);
                return;
            }
        }
        zzp2.close();
    }
}

