/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.video;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.games.video.zzb;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

@SafeParcelable.Reserved(value={1000})
@SafeParcelable.Class(creator="VideoConfigurationCreator")
public final class VideoConfiguration
extends AbstractSafeParcelable {
    @NonNull
    public static final Parcelable.Creator<VideoConfiguration> CREATOR;
    public static final int QUALITY_LEVEL_FULLHD = 3;
    public static final int QUALITY_LEVEL_XHD = 2;
    public static final int QUALITY_LEVEL_HD = 1;
    public static final int QUALITY_LEVEL_SD = 0;
    public static final int QUALITY_LEVEL_UNKNOWN = -1;
    public static final int NUM_QUALITY_LEVEL = 4;
    public static final int CAPTURE_MODE_UNKNOWN = -1;
    public static final int CAPTURE_MODE_FILE = 0;
    public static final int CAPTURE_MODE_STREAM = 1;
    public static final int NUM_CAPTURE_MODE = 2;
    @SafeParcelable.Field(id=1, getter="getQualityLevel")
    private final int zza;
    @SafeParcelable.Field(id=2, getter="getCaptureMode")
    private final int zzb;
    @SafeParcelable.Field(id=7, getter="shouldShowToastAfterRecording")
    private final boolean zzc;
    @SafeParcelable.Field(id=8, getter="getCameraEnabled")
    private final boolean zzd;
    @SafeParcelable.Field(id=9, getter="getMicEnabled")
    private final boolean zze;

    public int getCaptureMode() {
        return this.zzb;
    }

    public int getQualityLevel() {
        return this.zza;
    }

    static {
        zzb zzb2;
        CREATOR = zzb2 = new zzb();
    }

    @SafeParcelable.Constructor
    public VideoConfiguration(@SafeParcelable.Param(id=1) int n, @SafeParcelable.Param(id=2) int n2, @SafeParcelable.Param(id=7) boolean bl, @SafeParcelable.Param(id=8) boolean bl2, @SafeParcelable.Param(id=9) boolean bl3) {
        Preconditions.checkArgument((boolean)VideoConfiguration.isValidQualityLevel(n, false));
        Preconditions.checkArgument((boolean)VideoConfiguration.isValidCaptureMode(n2, false));
        this.zza = n;
        this.zzb = n2;
        this.zzc = bl;
        this.zzd = bl2;
        this.zze = bl3;
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel out, int n) {
        void var1_1;
        n = SafeParcelWriter.beginObjectHeader((Parcel)out);
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)1, (int)this.getQualityLevel());
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)2, (int)this.getCaptureMode());
        SafeParcelWriter.writeBoolean((Parcel)var1_1, (int)7, (boolean)this.zzc);
        SafeParcelWriter.writeBoolean((Parcel)var1_1, (int)8, (boolean)this.getCameraEnabled());
        SafeParcelWriter.writeBoolean((Parcel)var1_1, (int)9, (boolean)this.getMicEnabled());
        SafeParcelWriter.finishObjectHeader((Parcel)var1_1, (int)n);
    }

    public boolean getCameraEnabled() {
        return this.zzd;
    }

    public boolean getMicEnabled() {
        return this.zze;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isValidCaptureMode(int captureMode, boolean allowUnknown) {
        void var1_1;
        switch (captureMode) {
            default: {
                return false;
            }
            case 0: 
            case 1: {
                return true;
            }
            case -1: 
        }
        return (boolean)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isValidQualityLevel(int qualityLevel, boolean allowUnknown) {
        void var1_1;
        switch (qualityLevel) {
            default: {
                return false;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return true;
            }
            case -1: 
        }
        return (boolean)var1_1;
    }

    public static final class Builder {
        private int zza;
        private int zzb;
        private boolean zzc;
        private boolean zzd;
        private boolean zze;

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setCameraEnabled(boolean cameraEnabled) {
            void var1_1;
            this.zzd = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setCaptureMode(int captureMode) {
            void var1_1;
            this.zzb = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setMicEnabled(boolean micEnabled) {
            void var1_1;
            this.zze = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setQualityLevel(int qualityLevel) {
            void var1_1;
            this.zza = var1_1;
            return this;
        }

        @NonNull
        public VideoConfiguration build() {
            VideoConfiguration videoConfiguration = new VideoConfiguration(this.zza, this.zzb, this.zzc, this.zzd, this.zze);
            return videoConfiguration;
        }

        /*
         * WARNING - void declaration
         */
        public Builder(int qualityLevel, int captureMode) {
            void var2_2;
            void var1_1;
            this.zza = var1_1;
            this.zzb = var2_2;
            this.zzd = true;
            this.zze = true;
            this.zzc = true;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ValidCaptureModes {
    }
}

