/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.video;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.games.internal.zzc;
import com.google.android.gms.games.video.VideoConfiguration;
import com.google.android.gms.games.video.zza;

@SafeParcelable.Reserved(value={1000})
@SafeParcelable.Class(creator="VideoCapabilitiesCreator")
public final class VideoCapabilities
extends zzc {
    @NonNull
    public static final Parcelable.Creator<VideoCapabilities> CREATOR;
    @SafeParcelable.Field(id=1, getter="isCameraSupported")
    private final boolean zza;
    @SafeParcelable.Field(id=2, getter="isMicSupported")
    private final boolean zzb;
    @SafeParcelable.Field(id=3, getter="isWriteStorageSupported")
    private final boolean zzc;
    @SafeParcelable.Field(id=4, getter="getSupportedCaptureModes")
    private final boolean[] zzd;
    @SafeParcelable.Field(id=5, getter="getSupportedQualityLevels")
    private final boolean[] zze;

    public int hashCode() {
        Object[] objectArray = new Object[]{this.getSupportedCaptureModes(), this.getSupportedQualityLevels(), this.isCameraSupported(), this.isMicSupported(), this.isWriteStorageSupported()};
        return Objects.hashCode((Object[])objectArray);
    }

    @NonNull
    public String toString() {
        return Objects.toStringHelper((Object)((Object)this)).add("SupportedCaptureModes", (Object)this.getSupportedCaptureModes()).add("SupportedQualityLevels", (Object)this.getSupportedQualityLevels()).add("CameraSupported", (Object)this.isCameraSupported()).add("MicSupported", (Object)this.isMicSupported()).add("StorageWriteSupported", (Object)this.isWriteStorageSupported()).toString();
    }

    static {
        zza zza2;
        CREATOR = zza2 = new zza();
    }

    @SafeParcelable.Constructor
    public VideoCapabilities(@SafeParcelable.Param(id=1) boolean bl, @SafeParcelable.Param(id=2) boolean bl2, @SafeParcelable.Param(id=3) boolean bl3, @SafeParcelable.Param(id=4) @NonNull boolean[] blArray, @SafeParcelable.Param(id=5) @NonNull boolean[] blArray2) {
        this.zza = bl;
        this.zzb = bl2;
        this.zzc = bl3;
        this.zzd = blArray;
        this.zze = blArray2;
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel out, int n) {
        void var1_1;
        n = SafeParcelWriter.beginObjectHeader((Parcel)out);
        SafeParcelWriter.writeBoolean((Parcel)var1_1, (int)1, (boolean)this.isCameraSupported());
        SafeParcelWriter.writeBoolean((Parcel)var1_1, (int)2, (boolean)this.isMicSupported());
        SafeParcelWriter.writeBoolean((Parcel)var1_1, (int)3, (boolean)this.isWriteStorageSupported());
        SafeParcelWriter.writeBooleanArray((Parcel)var1_1, (int)4, (boolean[])this.getSupportedCaptureModes(), (boolean)false);
        SafeParcelWriter.writeBooleanArray((Parcel)var1_1, (int)5, (boolean[])this.getSupportedQualityLevels(), (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)var1_1, (int)n);
    }

    public boolean equals(@Nullable Object obj) {
        VideoCapabilities videoCapabilities;
        if (!(obj instanceof VideoCapabilities)) {
            return false;
        }
        if (this == videoCapabilities) {
            return true;
        }
        return Objects.equal((Object)(videoCapabilities = (VideoCapabilities)videoCapabilities).getSupportedCaptureModes(), (Object)this.getSupportedCaptureModes()) && Objects.equal((Object)videoCapabilities.getSupportedQualityLevels(), (Object)this.getSupportedQualityLevels()) && Objects.equal((Object)videoCapabilities.isCameraSupported(), (Object)this.isCameraSupported()) && Objects.equal((Object)videoCapabilities.isMicSupported(), (Object)this.isMicSupported()) && Objects.equal((Object)videoCapabilities.isWriteStorageSupported(), (Object)this.isWriteStorageSupported());
    }

    public boolean isCameraSupported() {
        return this.zza;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isFullySupported(int captureMode, int qualityLevel) {
        void var2_2;
        void var1_1;
        return this.zza && this.zzb && this.zzc && this.supportsCaptureMode((int)var1_1) && this.supportsQualityLevel((int)var2_2);
    }

    public boolean isMicSupported() {
        return this.zzb;
    }

    public boolean isWriteStorageSupported() {
        return this.zzc;
    }

    /*
     * WARNING - void declaration
     */
    public boolean supportsCaptureMode(int captureMode) {
        void var1_1;
        Preconditions.checkState((boolean)VideoConfiguration.isValidCaptureMode(captureMode, false));
        return this.zzd[var1_1];
    }

    /*
     * WARNING - void declaration
     */
    public boolean supportsQualityLevel(int qualityLevel) {
        void var1_1;
        Preconditions.checkState((boolean)VideoConfiguration.isValidQualityLevel(qualityLevel, false));
        return this.zze[var1_1];
    }

    @NonNull
    public boolean[] getSupportedCaptureModes() {
        return this.zzd;
    }

    @NonNull
    public boolean[] getSupportedQualityLevels() {
        return this.zze;
    }
}

