/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.video;

import android.os.Bundle;
import androidx.annotation.NonNull;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.games.video.VideoConfiguration;

public final class CaptureState {
    private final boolean zza;
    private final int zzb;
    private final int zzc;
    private final boolean zzd;
    private final boolean zze;

    public int getCaptureMode() {
        return this.zzb;
    }

    public int getCaptureQuality() {
        return this.zzc;
    }

    @NonNull
    public String toString() {
        return Objects.toStringHelper((Object)this).add("IsCapturing", (Object)this.zza).add("CaptureMode", (Object)this.zzb).add("CaptureQuality", (Object)this.zzc).add("IsOverlayVisible", (Object)this.zzd).add("IsPaused", (Object)this.zze).toString();
    }

    private CaptureState(boolean bl, int n, int n2, boolean bl2, boolean bl3) {
        Preconditions.checkArgument((boolean)VideoConfiguration.isValidCaptureMode(n, true));
        Preconditions.checkArgument((boolean)VideoConfiguration.isValidQualityLevel(n2, true));
        this.zza = bl;
        this.zzb = n;
        this.zzc = n2;
        this.zzd = bl2;
        this.zze = bl3;
    }

    public boolean isCapturing() {
        return this.zza;
    }

    public boolean isOverlayVisible() {
        return this.zzd;
    }

    public boolean isPaused() {
        return this.zze;
    }

    @NonNull
    public static CaptureState zza(@NonNull Bundle bundle) {
        if (bundle == null || bundle.get("IsCapturing") == null) {
            return null;
        }
        CaptureState captureState = new CaptureState(bundle.getBoolean("IsCapturing", false), bundle.getInt("CaptureMode", -1), bundle.getInt("CaptureQuality", -1), bundle.getBoolean("IsOverlayVisible", false), bundle.getBoolean("IsPaused", false));
        return captureState;
    }
}

