/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.stats;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.apps.common.proguard.UsedByReflection;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.games.internal.zzc;
import com.google.android.gms.games.stats.PlayerStats;
import com.google.android.gms.games.stats.zza;

@SafeParcelable.Reserved(value={1000})
@SafeParcelable.Class(creator="PlayerStatsEntityCreator")
@UsedByReflection(value="GamesGmsClientImpl.java")
public class PlayerStatsEntity
extends zzc
implements PlayerStats {
    @NonNull
    public static final Parcelable.Creator<PlayerStatsEntity> CREATOR;
    @SafeParcelable.Field(id=1, getter="getAverageSessionLength")
    private final float zza;
    @SafeParcelable.Field(id=2, getter="getChurnProbability")
    private final float zzb;
    @SafeParcelable.Field(id=3, getter="getDaysSinceLastPlayed")
    private final int zzc;
    @SafeParcelable.Field(id=4, getter="getNumberOfPurchases")
    private final int zzd;
    @SafeParcelable.Field(id=5, getter="getNumberOfSessions")
    private final int zze;
    @SafeParcelable.Field(id=6, getter="getSessionPercentile")
    private final float zzf;
    @SafeParcelable.Field(id=7, getter="getSpendPercentile")
    private final float zzg;
    @SafeParcelable.Field(id=8, getter="getRawValues")
    private final Bundle zzh;
    @SafeParcelable.Field(id=9, getter="getSpendProbability")
    private final float zzi;
    @SafeParcelable.Field(id=10, getter="getHighSpenderProbability")
    private final float zzj;
    @SafeParcelable.Field(id=11, getter="getTotalSpendNext28Days")
    private final float zzk;

    @Override
    public final float getAverageSessionLength() {
        return this.zza;
    }

    @Override
    public final float getChurnProbability() {
        return this.zzb;
    }

    @Override
    public final float getHighSpenderProbability() {
        return this.zzj;
    }

    @Override
    public final float getSessionPercentile() {
        return this.zzf;
    }

    @Override
    public final float getSpendPercentile() {
        return this.zzg;
    }

    @Override
    public final float getSpendProbability() {
        return this.zzi;
    }

    @Override
    public final float getTotalSpendNext28Days() {
        return this.zzk;
    }

    @Override
    public final int getDaysSinceLastPlayed() {
        return this.zzc;
    }

    @Override
    public final int getNumberOfPurchases() {
        return this.zzd;
    }

    @Override
    public final int getNumberOfSessions() {
        return this.zze;
    }

    public final int hashCode() {
        return PlayerStatsEntity.zzb(this);
    }

    @NonNull
    public final String toString() {
        return PlayerStatsEntity.zzc(this);
    }

    static {
        zza zza2;
        CREATOR = zza2 = new zza();
    }

    public PlayerStatsEntity(@NonNull PlayerStats playerStats) {
        this.zza = playerStats.getAverageSessionLength();
        this.zzb = playerStats.getChurnProbability();
        this.zzc = playerStats.getDaysSinceLastPlayed();
        this.zzd = playerStats.getNumberOfPurchases();
        this.zze = playerStats.getNumberOfSessions();
        this.zzf = playerStats.getSessionPercentile();
        this.zzg = playerStats.getSpendPercentile();
        this.zzi = playerStats.getSpendProbability();
        this.zzj = playerStats.getHighSpenderProbability();
        this.zzk = playerStats.getTotalSpendNext28Days();
        this.zzh = playerStats.zza();
    }

    @SafeParcelable.Constructor
    PlayerStatsEntity(@SafeParcelable.Param(id=1) float f, @SafeParcelable.Param(id=2) float f2, @SafeParcelable.Param(id=3) int n, @SafeParcelable.Param(id=4) int n2, @SafeParcelable.Param(id=5) int n3, @SafeParcelable.Param(id=6) float f3, @SafeParcelable.Param(id=7) float f4, @SafeParcelable.Param(id=8) Bundle bundle, @SafeParcelable.Param(id=9) float f5, @SafeParcelable.Param(id=10) float f6, @SafeParcelable.Param(id=11) float f7) {
        this.zza = f;
        this.zzb = f2;
        this.zzc = n;
        this.zzd = n2;
        this.zze = n3;
        this.zzf = f3;
        this.zzg = f4;
        this.zzh = bundle;
        this.zzi = f5;
        this.zzj = f6;
        this.zzk = f7;
    }

    public final void writeToParcel(@NonNull Parcel parcel, int n) {
        com.google.android.gms.games.stats.zza.zza(this, parcel, n);
    }

    public final boolean equals(@Nullable Object object) {
        return PlayerStatsEntity.zzd(this, object);
    }

    public final boolean isDataValid() {
        return true;
    }

    static int zzb(PlayerStats playerStats) {
        Object[] objectArray = new Object[]{Float.valueOf(playerStats.getAverageSessionLength()), Float.valueOf(playerStats.getChurnProbability()), playerStats.getDaysSinceLastPlayed(), playerStats.getNumberOfPurchases(), playerStats.getNumberOfSessions(), Float.valueOf(playerStats.getSessionPercentile()), Float.valueOf(playerStats.getSpendPercentile()), Float.valueOf(playerStats.getSpendProbability()), Float.valueOf(playerStats.getHighSpenderProbability()), Float.valueOf(playerStats.getTotalSpendNext28Days())};
        return Objects.hashCode((Object[])objectArray);
    }

    @Override
    @NonNull
    public final Bundle zza() {
        return this.zzh;
    }

    static String zzc(PlayerStats playerStats) {
        return Objects.toStringHelper((Object)playerStats).add("AverageSessionLength", (Object)Float.valueOf(playerStats.getAverageSessionLength())).add("ChurnProbability", (Object)Float.valueOf(playerStats.getChurnProbability())).add("DaysSinceLastPlayed", (Object)playerStats.getDaysSinceLastPlayed()).add("NumberOfPurchases", (Object)playerStats.getNumberOfPurchases()).add("NumberOfSessions", (Object)playerStats.getNumberOfSessions()).add("SessionPercentile", (Object)Float.valueOf(playerStats.getSessionPercentile())).add("SpendPercentile", (Object)Float.valueOf(playerStats.getSpendPercentile())).add("SpendProbability", (Object)Float.valueOf(playerStats.getSpendProbability())).add("HighSpenderProbability", (Object)Float.valueOf(playerStats.getHighSpenderProbability())).add("TotalSpendNext28Days", (Object)Float.valueOf(playerStats.getTotalSpendNext28Days())).toString();
    }

    static boolean zzd(PlayerStats playerStats, Object object) {
        if (!(object instanceof PlayerStats)) {
            return false;
        }
        if (playerStats == object) {
            return true;
        }
        return Objects.equal((Object)Float.valueOf((object = (PlayerStats)object).getAverageSessionLength()), (Object)Float.valueOf(playerStats.getAverageSessionLength())) && Objects.equal((Object)Float.valueOf(object.getChurnProbability()), (Object)Float.valueOf(playerStats.getChurnProbability())) && Objects.equal((Object)object.getDaysSinceLastPlayed(), (Object)playerStats.getDaysSinceLastPlayed()) && Objects.equal((Object)object.getNumberOfPurchases(), (Object)playerStats.getNumberOfPurchases()) && Objects.equal((Object)object.getNumberOfSessions(), (Object)playerStats.getNumberOfSessions()) && Objects.equal((Object)Float.valueOf(object.getSessionPercentile()), (Object)Float.valueOf(playerStats.getSessionPercentile())) && Objects.equal((Object)Float.valueOf(object.getSpendPercentile()), (Object)Float.valueOf(playerStats.getSpendPercentile())) && Objects.equal((Object)Float.valueOf(object.getSpendProbability()), (Object)Float.valueOf(playerStats.getSpendProbability())) && Objects.equal((Object)Float.valueOf(object.getHighSpenderProbability()), (Object)Float.valueOf(playerStats.getHighSpenderProbability())) && Objects.equal((Object)Float.valueOf(object.getTotalSpendNext28Days()), (Object)Float.valueOf(playerStats.getTotalSpendNext28Days()));
    }
}

