/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.snapshot;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.data.DataBufferRef;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameRef;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.snapshot.SnapshotMetadata;
import com.google.android.gms.games.snapshot.SnapshotMetadataEntity;

public final class SnapshotMetadataRef
extends DataBufferRef
implements SnapshotMetadata {
    private final Game zza;
    private final Player zzb;

    @Override
    public final float getCoverImageAspectRatio() {
        float f = this.getFloat("cover_icon_image_height");
        float f2 = this.getFloat("cover_icon_image_width");
        if (f == 0.0f) {
            return 0.0f;
        }
        return f2 / f;
    }

    public final int describeContents() {
        return 0;
    }

    public final int hashCode() {
        return SnapshotMetadataEntity.zzb(this);
    }

    @Override
    public final long getLastModifiedTimestamp() {
        return this.getLong("last_modified_timestamp");
    }

    @Override
    public final long getPlayedTime() {
        return this.getLong("duration");
    }

    @Override
    public final long getProgressValue() {
        return this.getLong("progress_value");
    }

    @Override
    @NonNull
    public final Uri getCoverImageUri() {
        return this.parseUri("cover_icon_image_uri");
    }

    @Override
    @NonNull
    public final Game getGame() {
        return this.zza;
    }

    @Override
    @NonNull
    public final Player getOwner() {
        return this.zzb;
    }

    @NonNull
    public final /* synthetic */ Object freeze() {
        SnapshotMetadataEntity snapshotMetadataEntity = new SnapshotMetadataEntity(this);
        return snapshotMetadataEntity;
    }

    @Override
    @NonNull
    public String getCoverImageUrl() {
        return this.getString("cover_icon_image_url");
    }

    @Override
    @NonNull
    public final String getDescription() {
        return this.getString("description");
    }

    @Override
    @NonNull
    public final String getDeviceName() {
        return this.getString("device_name");
    }

    @Override
    @NonNull
    public final String getSnapshotId() {
        return this.getString("external_snapshot_id");
    }

    @Override
    @NonNull
    public final String getUniqueName() {
        return this.getString("unique_name");
    }

    @NonNull
    public final String toString() {
        return SnapshotMetadataEntity.zzc(this);
    }

    public SnapshotMetadataRef(@NonNull DataHolder dataHolder, int n) {
        super(dataHolder, n);
        DataBufferRef dataBufferRef = new GameRef(dataHolder, n);
        this.zza = dataBufferRef;
        super(dataHolder, n, null);
        this.zzb = dataBufferRef;
    }

    @Override
    public final void getDescription(@NonNull CharArrayBuffer charArrayBuffer) {
        this.copyToBuffer("description", charArrayBuffer);
    }

    public final void writeToParcel(@NonNull Parcel parcel, int n) {
        SnapshotMetadataEntity snapshotMetadataEntity = new SnapshotMetadataEntity(this);
        snapshotMetadataEntity.writeToParcel(parcel, n);
    }

    public final boolean equals(@Nullable Object object) {
        return SnapshotMetadataEntity.zzd(this, object);
    }

    @Override
    public final boolean hasChangePending() {
        return this.getInteger("pending_change_count") > 0;
    }

    @Override
    @NonNull
    public final String zza() {
        return this.getString("title");
    }
}

