/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.snapshot;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.apps.common.proguard.UsedByReflection;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.util.DataUtils;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.internal.zzc;
import com.google.android.gms.games.snapshot.SnapshotMetadata;
import com.google.android.gms.games.snapshot.zzd;

@SafeParcelable.Reserved(value={1000})
@SafeParcelable.Class(creator="SnapshotMetadataEntityCreator")
@UsedByReflection(value="GamesGmsClientImpl.java")
public final class SnapshotMetadataEntity
extends zzc
implements SnapshotMetadata {
    @NonNull
    public static final Parcelable.Creator<SnapshotMetadataEntity> CREATOR;
    @SafeParcelable.Field(id=1, getter="getGame")
    private final GameEntity zza;
    @SafeParcelable.Field(id=2, getter="getOwner")
    private final PlayerEntity zzb;
    @SafeParcelable.Field(id=3, getter="getSnapshotId")
    private final String zzc;
    @SafeParcelable.Field(id=5, getter="getCoverImageUri")
    @Nullable
    private final Uri zzd;
    @SafeParcelable.Field(id=6, getter="getCoverImageUrl")
    @Nullable
    private final String zze;
    @SafeParcelable.Field(id=7, getter="getTitle")
    private final String zzf;
    @SafeParcelable.Field(id=8, getter="getDescription")
    private final String zzg;
    @SafeParcelable.Field(id=9, getter="getLastModifiedTimestamp")
    private final long zzh;
    @SafeParcelable.Field(id=10, getter="getPlayedTime")
    private final long zzi;
    @SafeParcelable.Field(id=11, getter="getCoverImageAspectRatio")
    private final float zzj;
    @SafeParcelable.Field(id=12, getter="getUniqueName")
    private final String zzk;
    @SafeParcelable.Field(id=13, getter="hasChangePending")
    private final boolean zzl;
    @SafeParcelable.Field(id=14, getter="getProgressValue")
    private final long zzm;
    @SafeParcelable.Field(id=15, getter="getDeviceName")
    @Nullable
    private final String zzn;

    @Override
    public float getCoverImageAspectRatio() {
        return this.zzj;
    }

    public int hashCode() {
        return SnapshotMetadataEntity.zzb(this);
    }

    @Override
    public long getLastModifiedTimestamp() {
        return this.zzh;
    }

    @Override
    public long getPlayedTime() {
        return this.zzi;
    }

    @Override
    public long getProgressValue() {
        return this.zzm;
    }

    @Override
    @Nullable
    public Uri getCoverImageUri() {
        return this.zzd;
    }

    @Override
    @NonNull
    public Game getGame() {
        return this.zza;
    }

    @Override
    @NonNull
    public Player getOwner() {
        return this.zzb;
    }

    @NonNull
    public SnapshotMetadata freeze() {
        return this;
    }

    @Override
    @Nullable
    public String getCoverImageUrl() {
        return this.zze;
    }

    @Override
    @NonNull
    public String getDescription() {
        return this.zzg;
    }

    @Override
    @NonNull
    public String getDeviceName() {
        return this.zzn;
    }

    @Override
    @NonNull
    public String getSnapshotId() {
        return this.zzc;
    }

    @Override
    @NonNull
    public String getUniqueName() {
        return this.zzk;
    }

    @NonNull
    public String toString() {
        return SnapshotMetadataEntity.zzc(this);
    }

    static {
        zzd zzd2;
        CREATOR = zzd2 = new zzd();
    }

    public SnapshotMetadataEntity(@NonNull SnapshotMetadata snapshotMetadata) {
        GameEntity gameEntity;
        PlayerEntity playerEntity = new PlayerEntity(snapshotMetadata.getOwner());
        this.zza = gameEntity = new GameEntity(snapshotMetadata.getGame());
        this.zzb = playerEntity;
        this.zzc = snapshotMetadata.getSnapshotId();
        this.zzd = snapshotMetadata.getCoverImageUri();
        this.zze = snapshotMetadata.getCoverImageUrl();
        this.zzj = snapshotMetadata.getCoverImageAspectRatio();
        this.zzf = snapshotMetadata.zza();
        this.zzg = snapshotMetadata.getDescription();
        this.zzh = snapshotMetadata.getLastModifiedTimestamp();
        this.zzi = snapshotMetadata.getPlayedTime();
        this.zzk = snapshotMetadata.getUniqueName();
        this.zzl = snapshotMetadata.hasChangePending();
        this.zzm = snapshotMetadata.getProgressValue();
        this.zzn = snapshotMetadata.getDeviceName();
    }

    @SafeParcelable.Constructor
    SnapshotMetadataEntity(@SafeParcelable.Param(id=1) GameEntity gameEntity, @SafeParcelable.Param(id=2) PlayerEntity playerEntity, @SafeParcelable.Param(id=3) String string, @SafeParcelable.Param(id=5) @Nullable Uri uri, @SafeParcelable.Param(id=6) @Nullable String string2, @SafeParcelable.Param(id=7) String string3, @SafeParcelable.Param(id=8) String string4, @SafeParcelable.Param(id=9) long l, @SafeParcelable.Param(id=10) long l2, @SafeParcelable.Param(id=11) float f, @SafeParcelable.Param(id=12) String string5, @SafeParcelable.Param(id=13) boolean bl, @SafeParcelable.Param(id=14) long l3, @SafeParcelable.Param(id=15) @Nullable String string6) {
        this.zza = gameEntity;
        this.zzb = playerEntity;
        this.zzc = string;
        this.zzd = uri;
        this.zze = string2;
        this.zzj = f;
        this.zzf = string3;
        this.zzg = string4;
        this.zzh = l;
        this.zzi = l2;
        this.zzk = string5;
        this.zzl = bl;
        this.zzm = l3;
        this.zzn = string6;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void getDescription(@NonNull CharArrayBuffer dataOut) {
        void var1_1;
        DataUtils.copyStringToBuffer((String)this.zzg, (CharArrayBuffer)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel out, int flags) {
        void var2_2;
        void var1_1;
        int n = SafeParcelWriter.beginObjectHeader((Parcel)out);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)1, (Parcelable)this.getGame(), (int)var2_2, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)2, (Parcelable)this.getOwner(), (int)var2_2, (boolean)false);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)3, (String)this.getSnapshotId(), (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)5, (Parcelable)this.getCoverImageUri(), (int)var2_2, (boolean)false);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)6, (String)this.getCoverImageUrl(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)7, (String)this.zzf, (boolean)false);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)8, (String)this.getDescription(), (boolean)false);
        SafeParcelWriter.writeLong((Parcel)var1_1, (int)9, (long)this.getLastModifiedTimestamp());
        SafeParcelWriter.writeLong((Parcel)var1_1, (int)10, (long)this.getPlayedTime());
        SafeParcelWriter.writeFloat((Parcel)var1_1, (int)11, (float)this.getCoverImageAspectRatio());
        SafeParcelWriter.writeString((Parcel)var1_1, (int)12, (String)this.getUniqueName(), (boolean)false);
        SafeParcelWriter.writeBoolean((Parcel)var1_1, (int)13, (boolean)this.hasChangePending());
        SafeParcelWriter.writeLong((Parcel)var1_1, (int)14, (long)this.getProgressValue());
        SafeParcelWriter.writeString((Parcel)var1_1, (int)15, (String)this.getDeviceName(), (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)var1_1, (int)n);
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(@Nullable Object obj) {
        void var1_1;
        return SnapshotMetadataEntity.zzd(this, var1_1);
    }

    @Override
    public boolean hasChangePending() {
        return this.zzl;
    }

    public boolean isDataValid() {
        return true;
    }

    static int zzb(SnapshotMetadata snapshotMetadata) {
        Object[] objectArray = new Object[]{snapshotMetadata.getGame(), snapshotMetadata.getOwner(), snapshotMetadata.getSnapshotId(), snapshotMetadata.getCoverImageUri(), Float.valueOf(snapshotMetadata.getCoverImageAspectRatio()), snapshotMetadata.zza(), snapshotMetadata.getDescription(), snapshotMetadata.getLastModifiedTimestamp(), snapshotMetadata.getPlayedTime(), snapshotMetadata.getUniqueName(), snapshotMetadata.hasChangePending(), snapshotMetadata.getProgressValue(), snapshotMetadata.getDeviceName()};
        return Objects.hashCode((Object[])objectArray);
    }

    @Override
    @NonNull
    public final String zza() {
        return this.zzf;
    }

    static String zzc(SnapshotMetadata snapshotMetadata) {
        return Objects.toStringHelper((Object)snapshotMetadata).add("Game", (Object)snapshotMetadata.getGame()).add("Owner", (Object)snapshotMetadata.getOwner()).add("SnapshotId", (Object)snapshotMetadata.getSnapshotId()).add("CoverImageUri", (Object)snapshotMetadata.getCoverImageUri()).add("CoverImageUrl", (Object)snapshotMetadata.getCoverImageUrl()).add("CoverImageAspectRatio", (Object)Float.valueOf(snapshotMetadata.getCoverImageAspectRatio())).add("Description", (Object)snapshotMetadata.getDescription()).add("LastModifiedTimestamp", (Object)snapshotMetadata.getLastModifiedTimestamp()).add("PlayedTime", (Object)snapshotMetadata.getPlayedTime()).add("UniqueName", (Object)snapshotMetadata.getUniqueName()).add("ChangePending", (Object)snapshotMetadata.hasChangePending()).add("ProgressValue", (Object)snapshotMetadata.getProgressValue()).add("DeviceName", (Object)snapshotMetadata.getDeviceName()).toString();
    }

    static boolean zzd(SnapshotMetadata snapshotMetadata, Object object) {
        if (!(object instanceof SnapshotMetadata)) {
            return false;
        }
        if (snapshotMetadata == object) {
            return true;
        }
        return Objects.equal((Object)(object = (SnapshotMetadata)object).getGame(), (Object)snapshotMetadata.getGame()) && Objects.equal((Object)object.getOwner(), (Object)snapshotMetadata.getOwner()) && Objects.equal((Object)object.getSnapshotId(), (Object)snapshotMetadata.getSnapshotId()) && Objects.equal((Object)object.getCoverImageUri(), (Object)snapshotMetadata.getCoverImageUri()) && Objects.equal((Object)Float.valueOf(object.getCoverImageAspectRatio()), (Object)Float.valueOf(snapshotMetadata.getCoverImageAspectRatio())) && Objects.equal((Object)object.zza(), (Object)snapshotMetadata.zza()) && Objects.equal((Object)object.getDescription(), (Object)snapshotMetadata.getDescription()) && Objects.equal((Object)object.getLastModifiedTimestamp(), (Object)snapshotMetadata.getLastModifiedTimestamp()) && Objects.equal((Object)object.getPlayedTime(), (Object)snapshotMetadata.getPlayedTime()) && Objects.equal((Object)object.getUniqueName(), (Object)snapshotMetadata.getUniqueName()) && Objects.equal((Object)object.hasChangePending(), (Object)snapshotMetadata.hasChangePending()) && Objects.equal((Object)object.getProgressValue(), (Object)snapshotMetadata.getProgressValue()) && Objects.equal((Object)object.getDeviceName(), (Object)snapshotMetadata.getDeviceName());
    }
}

