/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.snapshot;

import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.apps.common.proguard.UsedByReflection;
import com.google.android.gms.common.data.BitmapTeleporter;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.games.snapshot.SnapshotMetadataChange;
import com.google.android.gms.games.snapshot.zzc;

@SafeParcelable.Reserved(value={1000})
@SafeParcelable.Class(creator="SnapshotMetadataChangeCreator")
@UsedByReflection(value="GamesGmsClientImpl.java")
public final class SnapshotMetadataChangeEntity
extends com.google.android.gms.games.internal.zzc
implements SnapshotMetadataChange {
    @NonNull
    public static final Parcelable.Creator<SnapshotMetadataChangeEntity> CREATOR;
    @SafeParcelable.Field(id=1, getter="getDescription")
    private final String zza;
    @SafeParcelable.Field(id=2, getter="getPlayedTimeMillis")
    private final Long zzb;
    @SafeParcelable.Field(id=4, getter="getCoverImageUri")
    private final Uri zzc;
    @SafeParcelable.Field(id=5, getter="getCoverImageTeleporter")
    private BitmapTeleporter zzd;
    @SafeParcelable.Field(id=6, getter="getProgressValue")
    private final Long zze;

    @Override
    @Nullable
    public final Bitmap getCoverImage() {
        SnapshotMetadataChangeEntity snapshotMetadataChangeEntity = snapshotMetadataChangeEntity.zzd;
        if (snapshotMetadataChangeEntity == null) {
            return null;
        }
        return snapshotMetadataChangeEntity.get();
    }

    @Override
    @Nullable
    public final Long getPlayedTimeMillis() {
        return this.zzb;
    }

    @Override
    @Nullable
    public final Long getProgressValue() {
        return this.zze;
    }

    @Override
    @Nullable
    public final String getDescription() {
        return this.zza;
    }

    static {
        zzc zzc2;
        CREATOR = zzc2 = new zzc();
    }

    SnapshotMetadataChangeEntity() {
        this(null, null, null, null, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    @SafeParcelable.Constructor
    SnapshotMetadataChangeEntity(@SafeParcelable.Param(id=1) String string, @SafeParcelable.Param(id=2) Long l, @SafeParcelable.Param(id=5) BitmapTeleporter bitmapTeleporter, @SafeParcelable.Param(id=4) Uri uri, @SafeParcelable.Param(id=6) Long l2) {
        this.zza = string;
        this.zzb = l;
        this.zzd = bitmapTeleporter;
        this.zzc = uri;
        this.zze = l2;
        boolean bl = this.zzd != null ? uri == null : true;
        Preconditions.checkState((boolean)bl, (Object)"Cannot set both a URI and an image");
    }

    public final void writeToParcel(@NonNull Parcel parcel, int n) {
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel);
        SafeParcelWriter.writeString((Parcel)parcel, (int)1, (String)this.zza, (boolean)false);
        SafeParcelWriter.writeLongObject((Parcel)parcel, (int)2, (Long)this.zzb, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)parcel, (int)4, (Parcelable)this.zzc, (int)n, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)parcel, (int)5, (Parcelable)this.zzd, (int)n, (boolean)false);
        SafeParcelWriter.writeLongObject((Parcel)parcel, (int)6, (Long)this.zze, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel, (int)n2);
    }

    @Override
    @Nullable
    public final BitmapTeleporter zza() {
        return this.zzd;
    }
}

