/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.snapshot;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.apps.common.proguard.UsedByReflection;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.games.internal.zzc;
import com.google.android.gms.games.snapshot.Snapshot;
import com.google.android.gms.games.snapshot.SnapshotContents;
import com.google.android.gms.games.snapshot.SnapshotContentsEntity;
import com.google.android.gms.games.snapshot.SnapshotMetadata;
import com.google.android.gms.games.snapshot.SnapshotMetadataEntity;
import com.google.android.gms.games.snapshot.zzb;

@SafeParcelable.Reserved(value={1000})
@SafeParcelable.Class(creator="SnapshotEntityCreator")
@UsedByReflection(value="GamesGmsClientImpl.java")
public final class SnapshotEntity
extends zzc
implements Snapshot {
    @NonNull
    public static final Parcelable.Creator<SnapshotEntity> CREATOR;
    @SafeParcelable.Field(id=1, getter="getMetadata")
    private final SnapshotMetadataEntity zza;
    @SafeParcelable.Field(id=3, getter="getSnapshotContents")
    private final SnapshotContentsEntity zzb;

    public int hashCode() {
        Object[] objectArray = new Object[]{this.getMetadata(), this.getSnapshotContents()};
        return Objects.hashCode((Object[])objectArray);
    }

    @NonNull
    public Snapshot freeze() {
        return this;
    }

    @Override
    @Nullable
    public SnapshotContents getSnapshotContents() {
        if (this.zzb.isClosed()) {
            return null;
        }
        return this.zzb;
    }

    @Override
    @NonNull
    public SnapshotMetadata getMetadata() {
        return this.zza;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NonNull
    public String toString() {
        boolean bl;
        Objects.ToStringHelper toStringHelper = Objects.toStringHelper((Object)this).add("Metadata", (Object)this.getMetadata());
        if (this.getSnapshotContents() != null) {
            bl = true;
            return toStringHelper.add("HasContents", (Object)bl).toString();
        }
        bl = false;
        return toStringHelper.add("HasContents", (Object)bl).toString();
    }

    static {
        zzb zzb2;
        CREATOR = zzb2 = new zzb();
    }

    @SafeParcelable.Constructor
    public SnapshotEntity(@SafeParcelable.Param(id=1) @NonNull SnapshotMetadata snapshotMetadata, @SafeParcelable.Param(id=3) @NonNull SnapshotContentsEntity snapshotContentsEntity) {
        SnapshotMetadataEntity snapshotMetadataEntity;
        this.zza = snapshotMetadataEntity = new SnapshotMetadataEntity(snapshotMetadata);
        this.zzb = snapshotContentsEntity;
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel out, int flags) {
        void var2_2;
        void var1_1;
        int n = SafeParcelWriter.beginObjectHeader((Parcel)out);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)1, (Parcelable)this.getMetadata(), (int)var2_2, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)3, (Parcelable)this.getSnapshotContents(), (int)var2_2, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)var1_1, (int)n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object obj) {
        Snapshot snapshot;
        if (!(obj instanceof Snapshot)) {
            return false;
        }
        if (this == snapshot) {
            return true;
        }
        if (!Objects.equal((Object)(snapshot = (Snapshot)snapshot).getMetadata(), (Object)this.getMetadata())) return false;
        if (Objects.equal((Object)snapshot.getSnapshotContents(), (Object)this.getSnapshotContents())) return true;
        return false;
    }

    public boolean isDataValid() {
        return true;
    }
}

