/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.snapshot;

import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import com.google.android.apps.common.proguard.UsedByReflection;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.util.IOUtils;
import com.google.android.gms.drive.Contents;
import com.google.android.gms.games.internal.zzc;
import com.google.android.gms.games.snapshot.SnapshotContents;
import com.google.android.gms.games.snapshot.zza;
import com.google.android.gms.internal.games.zzft;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;

@SafeParcelable.Reserved(value={1000})
@SafeParcelable.Class(creator="SnapshotContentsEntityCreator")
@UsedByReflection(value="GamesGmsClientImpl.java")
public final class SnapshotContentsEntity
extends zzc
implements SnapshotContents {
    @NonNull
    public static final Parcelable.Creator<SnapshotContentsEntity> CREATOR;
    private static final Object zza;
    @SafeParcelable.Field(id=1, getter="getContents")
    private Contents zzb;

    @Override
    @NonNull
    public final ParcelFileDescriptor getParcelFileDescriptor() {
        Preconditions.checkState((boolean)(this.isClosed() ^ true), (Object)"Cannot mutate closed contents!");
        return this.zzb.getParcelFileDescriptor();
    }

    static {
        Object object;
        zza = object = new Object();
        object = new zza();
        CREATOR = object;
    }

    @SafeParcelable.Constructor
    public SnapshotContentsEntity(@SafeParcelable.Param(id=1) @NonNull Contents contents) {
        this.zzb = contents;
    }

    public final void writeToParcel(@NonNull Parcel parcel, int n) {
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel);
        SafeParcelWriter.writeParcelable((Parcel)parcel, (int)1, (Parcelable)this.zzb, (int)n, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel, (int)n2);
    }

    @Override
    public final boolean isClosed() {
        return this.zzb == null;
    }

    @Override
    public final boolean modifyBytes(int n, @NonNull byte[] byArray, int n2, int n3) {
        return this.zzc(n, byArray, n2, byArray.length, false);
    }

    @Override
    public final boolean writeBytes(@NonNull byte[] byArray) {
        return this.zzc(0, byArray, 0, byArray.length, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NonNull
    public final byte[] readFully() throws IOException {
        Preconditions.checkState((boolean)(((SnapshotContentsEntity)object2).isClosed() ^ true), (Object)"Must provide a previously opened Snapshot");
        Object object = zza;
        synchronized (object) {
            Object object2 = ((SnapshotContentsEntity)object2).zzb;
            object2 = object2.getParcelFileDescriptor();
            FileInputStream fileInputStream = new FileInputStream(object2.getFileDescriptor());
            object2 = new BufferedInputStream(fileInputStream);
            try {
                fileInputStream.getChannel().position(0L);
                object2 = IOUtils.readInputStreamFully((InputStream)object2, (boolean)false);
                fileInputStream.getChannel().position(0L);
                return object2;
            }
            catch (IOException iOException) {}
            zzft.zze("SnapshotContentsEntity", "Failed to read snapshot data", iOException);
            throw iOException;
        }
    }

    @Override
    @NonNull
    public final Contents zza() {
        return this.zzb;
    }

    @Override
    public final void zzb() {
        this.zzb = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean zzc(int n, byte[] byArray, int n2, int n3, boolean bl) {
        Preconditions.checkState((boolean)(((SnapshotContentsEntity)object2).isClosed() ^ true), (Object)"Must provide a previously opened SnapshotContents");
        Object object = zza;
        synchronized (object) {
            Object object2 = ((SnapshotContentsEntity)object2).zzb;
            object2 = object2.getParcelFileDescriptor();
            Closeable closeable = new FileOutputStream(object2.getFileDescriptor());
            object2 = new BufferedOutputStream((OutputStream)closeable);
            try {
                closeable = ((FileOutputStream)closeable).getChannel();
                ((FileChannel)closeable).position(n);
                ((OutputStream)object2).write(byArray, n2, n3);
                if (bl) {
                    ((FileChannel)closeable).truncate(byArray.length);
                }
                ((OutputStream)object2).flush();
                return true;
            }
            catch (IOException iOException) {
                zzft.zzc("SnapshotContentsEntity", "Failed to write snapshot data", iOException);
                return false;
            }
        }
    }
}

