/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.leaderboard;

import android.util.SparseArray;
import androidx.annotation.NonNull;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.games.zzfl;
import com.google.android.gms.internal.games.zzfp;

public final class ScoreSubmissionData {
    private static final String[] zza;
    private String zzb;
    private String zzc;
    private int zzd;
    private SparseArray zze;

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Result getScoreResult(int timeSpan) {
        void var1_1;
        return (Result)this.zze.get((int)var1_1);
    }

    @NonNull
    public String getLeaderboardId() {
        return this.zzb;
    }

    @NonNull
    public String getPlayerId() {
        return this.zzc;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NonNull
    public String toString() {
        Objects.ToStringHelper toStringHelper = Objects.toStringHelper((Object)this).add("PlayerId", (Object)this.zzc).add("StatusCode", (Object)this.zzd);
        int n = 0;
        while (n < 3) {
            Object object = (Result)this.zze.get(n);
            toStringHelper.add("TimesSpan", (Object)zzfl.zza(n));
            object = object == null ? "null" : ((Result)object).toString();
            toStringHelper.add("Result", object);
            ++n;
        }
        return toStringHelper.toString();
    }

    static {
        String[] stringArray = new String[]{"leaderboardId", "playerId", "timeSpan", "hasResult", "rawScore", "formattedScore", "newBest", "scoreTag"};
        zza = stringArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    public ScoreSubmissionData(@NonNull DataHolder dataHolder) {
        SparseArray sparseArray;
        this.zzd = dataHolder.getStatusCode();
        this.zze = sparseArray = new SparseArray();
        int n = dataHolder.getCount();
        int n2 = n == 3 ? 1 : 0;
        Preconditions.checkArgument(n2 != 0);
        n2 = 0;
        while (n2 < n) {
            int n3 = dataHolder.getWindowIndex(n2);
            if (n2 == 0) {
                this.zzb = dataHolder.getString("leaderboardId", 0, n3);
                this.zzc = dataHolder.getString("playerId", 0, n3);
                n2 = 0;
            }
            if (dataHolder.getBoolean("hasResult", n2, n3)) {
                Result result = new Result(dataHolder.getLong("rawScore", n2, n3), dataHolder.getString("formattedScore", n2, n3), dataHolder.getString("scoreTag", n2, n3), dataHolder.getBoolean("newBest", n2, n3));
                this.zze.put(dataHolder.getInteger("timeSpan", n2, n3), (Object)result);
            }
            ++n2;
        }
        return;
    }

    public static final class Result {
        public final long rawScore;
        @NonNull
        public final String formattedScore;
        @NonNull
        public final String scoreTag;
        public final boolean newBest;

        @NonNull
        public String toString() {
            return Objects.toStringHelper((Object)this).add("RawScore", (Object)this.rawScore).add("FormattedScore", (Object)this.formattedScore).add("ScoreTag", (Object)this.scoreTag).add("NewBest", (Object)this.newBest).toString();
        }

        /*
         * WARNING - void declaration
         */
        @zzfp
        public Result(long rawScore, @NonNull String formattedScore, @NonNull String scoreTag, boolean newBest) {
            void var5_4;
            void var4_3;
            void var3_2;
            void var1_1;
            this.rawScore = var1_1;
            this.formattedScore = var3_2;
            this.scoreTag = var4_3;
            this.newBest = var5_4;
        }
    }
}

