/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.leaderboard;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.apps.common.proguard.UsedByReflection;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.games.leaderboard.LeaderboardVariant;
import com.google.android.gms.internal.games.zzfl;

@UsedByReflection(value="GamesGmsClientImpl.java")
public final class LeaderboardVariantEntity
implements LeaderboardVariant {
    private final int zza;
    private final int zzb;
    private final boolean zzc;
    private final long zzd;
    private final String zze;
    private final long zzf;
    private final String zzg;
    private final String zzh;
    private final long zzi;
    private final String zzj;
    private final String zzk;
    private final String zzl;

    @Override
    public final int getCollection() {
        return this.zzb;
    }

    @Override
    public final int getTimeSpan() {
        return this.zza;
    }

    public final int hashCode() {
        return LeaderboardVariantEntity.zzd(this);
    }

    @Override
    public final long getNumScores() {
        return this.zzi;
    }

    @Override
    public final long getPlayerRank() {
        return this.zzf;
    }

    @Override
    public final long getRawPlayerScore() {
        return this.zzd;
    }

    @Override
    @NonNull
    public final String getDisplayPlayerRank() {
        return this.zzg;
    }

    @Override
    @NonNull
    public final String getDisplayPlayerScore() {
        return this.zze;
    }

    @Override
    @NonNull
    public final String getPlayerScoreTag() {
        return this.zzh;
    }

    @NonNull
    public final String toString() {
        return LeaderboardVariantEntity.zze(this);
    }

    public LeaderboardVariantEntity(@NonNull LeaderboardVariant leaderboardVariant) {
        this.zza = leaderboardVariant.getTimeSpan();
        this.zzb = leaderboardVariant.getCollection();
        this.zzc = leaderboardVariant.hasPlayerInfo();
        this.zzd = leaderboardVariant.getRawPlayerScore();
        this.zze = leaderboardVariant.getDisplayPlayerScore();
        this.zzf = leaderboardVariant.getPlayerRank();
        this.zzg = leaderboardVariant.getDisplayPlayerRank();
        this.zzh = leaderboardVariant.getPlayerScoreTag();
        this.zzi = leaderboardVariant.getNumScores();
        this.zzj = leaderboardVariant.zza();
        this.zzk = leaderboardVariant.zzc();
        this.zzl = leaderboardVariant.zzb();
    }

    public final boolean equals(@Nullable Object object) {
        return LeaderboardVariantEntity.zzf(this, object);
    }

    @Override
    public final boolean hasPlayerInfo() {
        return this.zzc;
    }

    public final boolean isDataValid() {
        return true;
    }

    static int zzd(LeaderboardVariant leaderboardVariant) {
        Object[] objectArray = new Object[]{leaderboardVariant.getTimeSpan(), leaderboardVariant.getCollection(), leaderboardVariant.hasPlayerInfo(), leaderboardVariant.getRawPlayerScore(), leaderboardVariant.getDisplayPlayerScore(), leaderboardVariant.getPlayerRank(), leaderboardVariant.getDisplayPlayerRank(), leaderboardVariant.getNumScores(), leaderboardVariant.zza(), leaderboardVariant.zzb(), leaderboardVariant.zzc()};
        return Objects.hashCode((Object[])objectArray);
    }

    @Override
    @NonNull
    public final String zza() {
        return this.zzj;
    }

    @Override
    @NonNull
    public final String zzb() {
        return this.zzl;
    }

    @Override
    @NonNull
    public final String zzc() {
        return this.zzk;
    }

    /*
     * Enabled aggressive block sorting
     */
    static String zze(LeaderboardVariant object) {
        Object object2;
        Object object3 = Objects.toStringHelper((Object)object).add("TimeSpan", (Object)zzfl.zza(object.getTimeSpan()));
        int n = object.getCollection();
        switch (n) {
            case -1: {
                object2 = "UNKNOWN";
                break;
            }
            case 4: {
                object2 = "SOCIAL_1P";
                break;
            }
            case 3: {
                object2 = "FRIENDS";
                break;
            }
            case 2: {
                object2 = "SOCIAL_1P";
                break;
            }
            case 1: {
                object2 = "SOCIAL";
                break;
            }
            default: {
                object3 = new StringBuilder();
                ((StringBuilder)object3).append("Unknown leaderboard collection: ");
                ((StringBuilder)object3).append(n);
                object = new IllegalArgumentException(((StringBuilder)object3).toString());
                throw object;
            }
            case 0: {
                object2 = "PUBLIC";
            }
        }
        object3 = object3.add("Collection", object2);
        object2 = object.hasPlayerInfo() ? Long.valueOf(object.getRawPlayerScore()) : "none";
        object3 = object3.add("RawPlayerScore", object2);
        object2 = object.hasPlayerInfo() ? object.getDisplayPlayerScore() : "none";
        object3 = object3.add("DisplayPlayerScore", object2);
        object2 = object.hasPlayerInfo() ? Long.valueOf(object.getPlayerRank()) : "none";
        object3 = object3.add("PlayerRank", object2);
        if (object.hasPlayerInfo()) {
            object2 = object.getDisplayPlayerRank();
            return object3.add("DisplayPlayerRank", object2).add("NumScores", (Object)object.getNumScores()).add("TopPageNextToken", (Object)object.zza()).add("WindowPageNextToken", (Object)object.zzb()).add("WindowPagePrevToken", (Object)object.zzc()).toString();
        }
        object2 = "none";
        return object3.add("DisplayPlayerRank", object2).add("NumScores", (Object)object.getNumScores()).add("TopPageNextToken", (Object)object.zza()).add("WindowPageNextToken", (Object)object.zzb()).add("WindowPagePrevToken", (Object)object.zzc()).toString();
    }

    static boolean zzf(LeaderboardVariant leaderboardVariant, Object object) {
        if (!(object instanceof LeaderboardVariant)) {
            return false;
        }
        if (leaderboardVariant == object) {
            return true;
        }
        return Objects.equal((Object)(object = (LeaderboardVariant)object).getTimeSpan(), (Object)leaderboardVariant.getTimeSpan()) && Objects.equal((Object)object.getCollection(), (Object)leaderboardVariant.getCollection()) && Objects.equal((Object)object.hasPlayerInfo(), (Object)leaderboardVariant.hasPlayerInfo()) && Objects.equal((Object)object.getRawPlayerScore(), (Object)leaderboardVariant.getRawPlayerScore()) && Objects.equal((Object)object.getDisplayPlayerScore(), (Object)leaderboardVariant.getDisplayPlayerScore()) && Objects.equal((Object)object.getPlayerRank(), (Object)leaderboardVariant.getPlayerRank()) && Objects.equal((Object)object.getDisplayPlayerRank(), (Object)leaderboardVariant.getDisplayPlayerRank()) && Objects.equal((Object)object.getNumScores(), (Object)leaderboardVariant.getNumScores()) && Objects.equal((Object)object.zza(), (Object)leaderboardVariant.zza()) && Objects.equal((Object)object.zzb(), (Object)leaderboardVariant.zzb()) && Objects.equal((Object)object.zzc(), (Object)leaderboardVariant.zzc());
    }
}

