/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.leaderboard;

import android.database.CharArrayBuffer;
import android.net.Uri;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.data.DataBufferRef;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerRef;
import com.google.android.gms.games.leaderboard.LeaderboardScore;
import com.google.android.gms.games.leaderboard.LeaderboardScoreEntity;

public final class LeaderboardScoreRef
extends DataBufferRef
implements LeaderboardScore {
    private final PlayerRef zza;

    public final int hashCode() {
        return LeaderboardScoreEntity.zza(this);
    }

    @Override
    public final long getRank() {
        return this.getLong("rank");
    }

    @Override
    public final long getRawScore() {
        return this.getLong("raw_score");
    }

    @Override
    public final long getTimestampMillis() {
        return this.getLong("achieved_timestamp");
    }

    @Override
    @Nullable
    public final Uri getScoreHolderHiResImageUri() {
        if (this.hasNull("external_player_id")) {
            return null;
        }
        return this.zza.getHiResImageUri();
    }

    @Override
    @NonNull
    public final Uri getScoreHolderIconImageUri() {
        if (this.hasNull("external_player_id")) {
            return this.parseUri("default_display_image_uri");
        }
        return this.zza.getIconImageUri();
    }

    @Override
    @Nullable
    public final Player getScoreHolder() {
        if (this.hasNull("external_player_id")) {
            return null;
        }
        return this.zza;
    }

    @NonNull
    public final /* synthetic */ Object freeze() {
        LeaderboardScoreEntity leaderboardScoreEntity = new LeaderboardScoreEntity(this);
        return leaderboardScoreEntity;
    }

    @Override
    @NonNull
    public final String getDisplayRank() {
        return this.getString("display_rank");
    }

    @Override
    @NonNull
    public final String getDisplayScore() {
        return this.getString("display_score");
    }

    @Override
    @NonNull
    public final String getScoreHolderDisplayName() {
        if (this.hasNull("external_player_id")) {
            return this.getString("default_display_name");
        }
        return this.zza.getDisplayName();
    }

    @Override
    @Nullable
    public String getScoreHolderHiResImageUrl() {
        if (this.hasNull("external_player_id")) {
            return null;
        }
        return this.zza.getHiResImageUrl();
    }

    @Override
    @NonNull
    public String getScoreHolderIconImageUrl() {
        if (this.hasNull("external_player_id")) {
            return this.getString("default_display_image_url");
        }
        return this.zza.getIconImageUrl();
    }

    @Override
    @NonNull
    public final String getScoreTag() {
        return this.getString("score_tag");
    }

    @NonNull
    public final String toString() {
        return LeaderboardScoreEntity.zzb(this);
    }

    public LeaderboardScoreRef(@NonNull DataHolder dataHolder, int n) {
        super(dataHolder, n);
        PlayerRef playerRef;
        this.zza = playerRef = new PlayerRef(dataHolder, n, null);
    }

    @Override
    public final void getDisplayRank(@NonNull CharArrayBuffer charArrayBuffer) {
        this.copyToBuffer("display_rank", charArrayBuffer);
    }

    @Override
    public final void getDisplayScore(@NonNull CharArrayBuffer charArrayBuffer) {
        this.copyToBuffer("display_score", charArrayBuffer);
    }

    @Override
    public final void getScoreHolderDisplayName(@NonNull CharArrayBuffer charArrayBuffer) {
        if (this.hasNull("external_player_id")) {
            this.copyToBuffer("default_display_name", charArrayBuffer);
            return;
        }
        this.zza.getDisplayName(charArrayBuffer);
    }

    public final boolean equals(@Nullable Object object) {
        return LeaderboardScoreEntity.zzc(this, object);
    }
}

