/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.leaderboard;

import android.database.CharArrayBuffer;
import android.net.Uri;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.apps.common.proguard.UsedByReflection;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.DataUtils;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.leaderboard.LeaderboardScore;

@UsedByReflection(value="GamesGmsClientImpl.java")
public final class LeaderboardScoreEntity
implements LeaderboardScore {
    private final long zza;
    private final String zzb;
    private final String zzc;
    private final long zzd;
    private final long zze;
    private final String zzf;
    private final Uri zzg;
    private final Uri zzh;
    private final PlayerEntity zzi;
    private final String zzj;
    private final String zzk;
    private final String zzl;

    public final int hashCode() {
        return LeaderboardScoreEntity.zza(this);
    }

    @Override
    public final long getRank() {
        return this.zza;
    }

    @Override
    public final long getRawScore() {
        return this.zzd;
    }

    @Override
    public final long getTimestampMillis() {
        return this.zze;
    }

    @Override
    @NonNull
    public final Uri getScoreHolderHiResImageUri() {
        PlayerEntity playerEntity = this.zzi;
        if (playerEntity == null) {
            return this.zzh;
        }
        return playerEntity.getHiResImageUri();
    }

    @Override
    @NonNull
    public final Uri getScoreHolderIconImageUri() {
        PlayerEntity playerEntity = this.zzi;
        if (playerEntity == null) {
            return this.zzg;
        }
        return playerEntity.getIconImageUri();
    }

    @Override
    @NonNull
    public final Player getScoreHolder() {
        return this.zzi;
    }

    @Override
    @NonNull
    public final String getDisplayRank() {
        return this.zzb;
    }

    @Override
    @NonNull
    public final String getDisplayScore() {
        return this.zzc;
    }

    @Override
    @NonNull
    public final String getScoreHolderDisplayName() {
        PlayerEntity playerEntity = this.zzi;
        if (playerEntity == null) {
            return this.zzf;
        }
        return playerEntity.getDisplayName();
    }

    @Override
    @NonNull
    public String getScoreHolderHiResImageUrl() {
        PlayerEntity playerEntity = this.zzi;
        if (playerEntity == null) {
            return this.zzl;
        }
        return playerEntity.getHiResImageUrl();
    }

    @Override
    @NonNull
    public String getScoreHolderIconImageUrl() {
        PlayerEntity playerEntity = this.zzi;
        if (playerEntity == null) {
            return this.zzk;
        }
        return playerEntity.getIconImageUrl();
    }

    @Override
    @NonNull
    public final String getScoreTag() {
        return this.zzj;
    }

    @NonNull
    public final String toString() {
        return LeaderboardScoreEntity.zzb(this);
    }

    /*
     * Enabled aggressive block sorting
     */
    public LeaderboardScoreEntity(@NonNull LeaderboardScore leaderboardScore) {
        this.zza = leaderboardScore.getRank();
        this.zzb = (String)Preconditions.checkNotNull((Object)leaderboardScore.getDisplayRank());
        this.zzc = (String)Preconditions.checkNotNull((Object)leaderboardScore.getDisplayScore());
        this.zzd = leaderboardScore.getRawScore();
        this.zze = leaderboardScore.getTimestampMillis();
        this.zzf = leaderboardScore.getScoreHolderDisplayName();
        this.zzg = leaderboardScore.getScoreHolderIconImageUri();
        this.zzh = leaderboardScore.getScoreHolderHiResImageUri();
        Player player = leaderboardScore.getScoreHolder();
        if (player == null) {
            player = null;
        } else {
            PlayerEntity playerEntity = new PlayerEntity(player);
            player = playerEntity;
        }
        this.zzi = player;
        this.zzj = leaderboardScore.getScoreTag();
        this.zzk = leaderboardScore.getScoreHolderIconImageUrl();
        this.zzl = leaderboardScore.getScoreHolderHiResImageUrl();
    }

    @Override
    public final void getDisplayRank(@NonNull CharArrayBuffer charArrayBuffer) {
        DataUtils.copyStringToBuffer((String)this.zzb, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final void getDisplayScore(@NonNull CharArrayBuffer charArrayBuffer) {
        DataUtils.copyStringToBuffer((String)this.zzc, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final void getScoreHolderDisplayName(@NonNull CharArrayBuffer charArrayBuffer) {
        PlayerEntity playerEntity = this.zzi;
        if (playerEntity == null) {
            DataUtils.copyStringToBuffer((String)this.zzf, (CharArrayBuffer)charArrayBuffer);
            return;
        }
        playerEntity.getDisplayName(charArrayBuffer);
    }

    public final boolean equals(@Nullable Object object) {
        return LeaderboardScoreEntity.zzc(this, object);
    }

    public final boolean isDataValid() {
        return true;
    }

    static int zza(LeaderboardScore leaderboardScore) {
        Object[] objectArray = new Object[]{leaderboardScore.getRank(), leaderboardScore.getDisplayRank(), leaderboardScore.getRawScore(), leaderboardScore.getDisplayScore(), leaderboardScore.getTimestampMillis(), leaderboardScore.getScoreHolderDisplayName(), leaderboardScore.getScoreHolderIconImageUri(), leaderboardScore.getScoreHolderHiResImageUri(), leaderboardScore.getScoreHolder()};
        return Objects.hashCode((Object[])objectArray);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static String zzb(LeaderboardScore leaderboardScore) {
        Player player;
        Objects.ToStringHelper toStringHelper = Objects.toStringHelper((Object)leaderboardScore).add("Rank", (Object)leaderboardScore.getRank()).add("DisplayRank", (Object)leaderboardScore.getDisplayRank()).add("Score", (Object)leaderboardScore.getRawScore()).add("DisplayScore", (Object)leaderboardScore.getDisplayScore()).add("Timestamp", (Object)leaderboardScore.getTimestampMillis()).add("DisplayName", (Object)leaderboardScore.getScoreHolderDisplayName()).add("IconImageUri", (Object)leaderboardScore.getScoreHolderIconImageUri()).add("IconImageUrl", (Object)leaderboardScore.getScoreHolderIconImageUrl()).add("HiResImageUri", (Object)leaderboardScore.getScoreHolderHiResImageUri()).add("HiResImageUrl", (Object)leaderboardScore.getScoreHolderHiResImageUrl());
        if (leaderboardScore.getScoreHolder() == null) {
            player = null;
            return toStringHelper.add("Player", (Object)player).add("ScoreTag", (Object)leaderboardScore.getScoreTag()).toString();
        }
        player = leaderboardScore.getScoreHolder();
        return toStringHelper.add("Player", (Object)player).add("ScoreTag", (Object)leaderboardScore.getScoreTag()).toString();
    }

    static boolean zzc(LeaderboardScore leaderboardScore, Object object) {
        if (!(object instanceof LeaderboardScore)) {
            return false;
        }
        if (leaderboardScore == object) {
            return true;
        }
        return Objects.equal((Object)(object = (LeaderboardScore)object).getRank(), (Object)leaderboardScore.getRank()) && Objects.equal((Object)object.getDisplayRank(), (Object)leaderboardScore.getDisplayRank()) && Objects.equal((Object)object.getRawScore(), (Object)leaderboardScore.getRawScore()) && Objects.equal((Object)object.getDisplayScore(), (Object)leaderboardScore.getDisplayScore()) && Objects.equal((Object)object.getTimestampMillis(), (Object)leaderboardScore.getTimestampMillis()) && Objects.equal((Object)object.getScoreHolderDisplayName(), (Object)leaderboardScore.getScoreHolderDisplayName()) && Objects.equal((Object)object.getScoreHolderIconImageUri(), (Object)leaderboardScore.getScoreHolderIconImageUri()) && Objects.equal((Object)object.getScoreHolderHiResImageUri(), (Object)leaderboardScore.getScoreHolderHiResImageUri()) && Objects.equal((Object)object.getScoreHolder(), (Object)leaderboardScore.getScoreHolder()) && Objects.equal((Object)object.getScoreTag(), (Object)leaderboardScore.getScoreTag());
    }
}

