/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.leaderboard;

import android.database.CharArrayBuffer;
import android.net.Uri;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.data.DataBufferRef;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameRef;
import com.google.android.gms.games.leaderboard.Leaderboard;
import com.google.android.gms.games.leaderboard.LeaderboardEntity;
import com.google.android.gms.games.leaderboard.LeaderboardVariant;
import com.google.android.gms.games.leaderboard.zzb;
import java.util.ArrayList;

public final class LeaderboardRef
extends DataBufferRef
implements Leaderboard {
    private final int zza;
    private final Game zzb;

    @Override
    public final int getScoreOrder() {
        return this.getInteger("score_order");
    }

    public final int hashCode() {
        return LeaderboardEntity.zzb(this);
    }

    @Override
    @NonNull
    public final Uri getIconImageUri() {
        return this.parseUri("board_icon_image_uri");
    }

    @NonNull
    public final /* synthetic */ Object freeze() {
        LeaderboardEntity leaderboardEntity = new LeaderboardEntity(this);
        return leaderboardEntity;
    }

    @Override
    @NonNull
    public final String getDisplayName() {
        return this.getString("name");
    }

    @Override
    @NonNull
    public String getIconImageUrl() {
        return this.getString("board_icon_image_url");
    }

    @Override
    @NonNull
    public final String getLeaderboardId() {
        return this.getString("external_leaderboard_id");
    }

    @NonNull
    public final String toString() {
        return LeaderboardEntity.zzc(this);
    }

    @Override
    @NonNull
    public final ArrayList<LeaderboardVariant> getVariants() {
        ArrayList<LeaderboardVariant> arrayList = new ArrayList<LeaderboardVariant>(this.zza);
        for (int i = 0; i < this.zza; ++i) {
            zzb zzb2 = new zzb(this.mDataHolder, this.mDataRow + i);
            arrayList.add(zzb2);
        }
        return arrayList;
    }

    LeaderboardRef(DataHolder dataHolder, int n, int n2) {
        super(dataHolder, n);
        this.zza = n2;
        GameRef gameRef = new GameRef(dataHolder, n);
        this.zzb = gameRef;
    }

    @Override
    public final void getDisplayName(@NonNull CharArrayBuffer charArrayBuffer) {
        this.copyToBuffer("name", charArrayBuffer);
    }

    public final boolean equals(@Nullable Object object) {
        return LeaderboardEntity.zzd(this, object);
    }

    @Override
    @NonNull
    public final Game zza() {
        return this.zzb;
    }
}

